/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte.world;

import java.util.List;
import java.util.Random;
import jp.ngt.mcte.world.WorldData;
import jp.ngt.ngtlib.math.NGTMath;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ChunkProviderPictorialCustom
implements IChunkGenerator {
    private Random rand;
    private NoiseGeneratorOctaves noiseOct0;
    private NoiseGeneratorOctaves noiseOct1;
    private NoiseGeneratorOctaves noiseOct2;
    private NoiseGeneratorPerlin noisePer0;
    public NoiseGeneratorOctaves noiseGen5;
    public NoiseGeneratorOctaves noiseGen6;
    public NoiseGeneratorOctaves mobSpawnerNoise;
    private World worldObj;
    private final boolean mapFeaturesEnabled;
    private WorldType field_147435_p;
    private final double[] field_147434_q;
    private final float[] parabolicField;
    private double[] stoneNoise = new double[256];
    private MapGenBase caveGenerator = new MapGenCaves();
    private MapGenStronghold strongholdGenerator = new MapGenStronghold();
    private MapGenVillage villageGenerator = new MapGenVillage();
    private MapGenMineshaft mineshaftGenerator = new MapGenMineshaft();
    private MapGenScatteredFeature scatteredFeatureGenerator = new MapGenScatteredFeature();
    private MapGenBase ravineGenerator = new MapGenRavine();
    private Biome[] biomesForGeneration;
    private WorldData worldData;

    public ChunkProviderPictorialCustom(World par1, long par2, boolean par3, WorldData par4) {
        this.caveGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.caveGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.strongholdGenerator = (MapGenStronghold)TerrainGen.getModdedMapGen((MapGenBase)this.strongholdGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD);
        this.villageGenerator = (MapGenVillage)TerrainGen.getModdedMapGen((MapGenBase)this.villageGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE);
        this.mineshaftGenerator = (MapGenMineshaft)TerrainGen.getModdedMapGen((MapGenBase)this.mineshaftGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT);
        this.scatteredFeatureGenerator = (MapGenScatteredFeature)TerrainGen.getModdedMapGen((MapGenBase)this.scatteredFeatureGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.SCATTERED_FEATURE);
        this.ravineGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.ravineGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE);
        this.worldObj = par1;
        this.mapFeaturesEnabled = par3;
        this.worldData = par4;
        this.field_147435_p = par1.func_72912_H().func_76067_t();
        this.rand = new Random(par2);
        this.noiseOct0 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseOct1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseOct2 = new NoiseGeneratorOctaves(this.rand, 8);
        this.noisePer0 = new NoiseGeneratorPerlin(this.rand, 4);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 10);
        this.noiseGen6 = new NoiseGeneratorOctaves(this.rand, 16);
        this.mobSpawnerNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.field_147434_q = new double[825];
        this.parabolicField = new float[25];
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                float f;
                this.parabolicField[j + 2 + (k + 2) * 5] = f = 10.0f / (float)NGTMath.firstSqrt((double)((float)(j * j + k * k) + 0.2f));
            }
        }
        InitNoiseGensEvent.ContextOverworld ctx = new InitNoiseGensEvent.ContextOverworld(this.noiseOct0, this.noiseOct1, this.noiseOct2, this.noisePer0, this.noiseGen5, this.noiseGen6, this.mobSpawnerNoise);
        ctx = (InitNoiseGensEvent.ContextOverworld)TerrainGen.getModdedNoiseGenerators((World)par1, (Random)this.rand, (InitNoiseGensEvent.Context)ctx);
        this.noiseOct0 = ctx.getLPerlin1();
        this.noiseOct1 = ctx.getLPerlin2();
        this.noiseOct2 = ctx.getPerlin();
        this.noisePer0 = ctx.getHeight();
        this.noiseGen5 = ctx.getScale();
        this.noiseGen6 = ctx.getDepth();
        this.mobSpawnerNoise = ctx.getForest();
    }

    public void setBlocksInChunk(int par1, int par2, ChunkPrimer par3) {
        int x = par1 << 4;
        int z = par2 << 4;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int height = this.worldData.getWorldGenerator().getHeight(x + i, z + j);
                int y = height;
                if (this.worldData.seaLevel > y) {
                    y = this.worldData.seaLevel;
                }
                for (int k = 0; k < y; ++k) {
                    if (k < height) {
                        par3.func_177855_a(i, j, k, this.worldData.baseBlock.func_176223_P());
                        continue;
                    }
                    par3.func_177855_a(i, j, k, Blocks.field_150355_j.func_176223_P());
                }
            }
        }
    }

    public void replaceBlocksForBiome(int par1, int par2, ChunkPrimer par4, Biome[] par5) {
        double d0 = 0.03125;
        this.stoneNoise = this.noisePer0.func_151599_a(this.stoneNoise, (double)(par1 * 16), (double)(par2 * 16), 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                Biome Biome2 = par5[l + k * 16];
                this.genBiomeTerrain(Biome2, this.worldObj, this.rand, par4, par1 * 16 + k, par2 * 16 + l, this.stoneNoise[l + k * 16]);
            }
        }
    }

    private void genBiomeTerrain(Biome biome, World world, Random random, ChunkPrimer primer, int x, int z, double noise) {
        int i = world.func_181545_F();
        IBlockState iblockstate = biome.field_76752_A;
        IBlockState iblockstate1 = biome.field_76753_B;
        int j = -1;
        int k = (int)(noise / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
        int l = x & 0xF;
        int i1 = z & 0xF;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j1 = 255; j1 >= 0; --j1) {
            if (j1 <= this.rand.nextInt(5)) {
                primer.func_177855_a(i1, j1, l, Blocks.field_150357_h.func_176223_P());
                continue;
            }
            IBlockState iblockstate2 = primer.func_177856_a(i1, j1, l);
            if (iblockstate2.func_177230_c().func_149688_o(iblockstate2) == Material.field_151579_a) {
                j = -1;
                continue;
            }
            if (iblockstate2.func_177230_c() != Blocks.field_150348_b) continue;
            if (j == -1) {
                if (k <= 0) {
                    iblockstate = null;
                    iblockstate1 = Blocks.field_150348_b.func_176223_P();
                } else if (j1 >= i - 4 && j1 <= i + 1) {
                    iblockstate = biome.field_76752_A;
                    iblockstate1 = biome.field_76753_B;
                }
                if (j1 < i && (iblockstate == null || iblockstate.func_185904_a() == Material.field_151579_a)) {
                    iblockstate = biome.func_180626_a((BlockPos)blockpos$mutableblockpos.func_181079_c(x, j1, z)) < 0.15f ? Blocks.field_150432_aD.func_176223_P() : Blocks.field_150355_j.func_176223_P();
                }
                j = k;
                if (j1 >= i - 1) {
                    primer.func_177855_a(i1, j1, l, iblockstate);
                    continue;
                }
                if (j1 < i - 7 - k) {
                    iblockstate = null;
                    iblockstate1 = Blocks.field_150348_b.func_176223_P();
                    primer.func_177855_a(i1, j1, l, Blocks.field_150351_n.func_176223_P());
                    continue;
                }
                primer.func_177855_a(i1, j1, l, iblockstate1);
                continue;
            }
            if (j <= 0) continue;
            primer.func_177855_a(i1, j1, l, iblockstate1);
            if (--j != 0 || iblockstate1.func_177230_c() != Blocks.field_150354_m) continue;
            j = this.rand.nextInt(4) + Math.max(0, j1 - 63);
            iblockstate1 = iblockstate1.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.RED_SAND ? Blocks.field_180395_cM.func_176223_P() : Blocks.field_150322_A.func_176223_P();
        }
    }

    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.setBlocksInChunk(x, z, chunkprimer);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76937_a(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.replaceBlocksForBiome(x, z, chunkprimer, this.biomesForGeneration);
        if (this.mapFeaturesEnabled) {
            this.caveGenerator.func_186125_a(this.worldObj, x, z, chunkprimer);
            this.ravineGenerator.func_186125_a(this.worldObj, x, z, chunkprimer);
            this.mineshaftGenerator.func_186125_a(this.worldObj, x, z, chunkprimer);
            this.villageGenerator.func_186125_a(this.worldObj, x, z, chunkprimer);
            this.strongholdGenerator.func_186125_a(this.worldObj, x, z, chunkprimer);
            this.scatteredFeatureGenerator.func_186125_a(this.worldObj, x, z, chunkprimer);
        }
        Chunk chunk = new Chunk(this.worldObj, chunkprimer, x, z);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int x, int z) {
        BlockFalling.field_149832_M = true;
        int k = x * 16;
        int l = z * 16;
        BlockPos blockpos = new BlockPos(k, 0, l);
        Biome Biome2 = this.worldObj.getBiomeForCoordsBody(blockpos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.worldObj.func_72905_C());
        long ln1 = this.rand.nextLong() / 2L * 2L + 1L;
        long ln2 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)x * ln1 + (long)z * ln2 ^ this.worldObj.func_72905_C());
        boolean flag = false;
        ChunkPos chunkcoordintpair = new ChunkPos(x, z);
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre((IChunkGenerator)this, this.worldObj, this.rand, x, z, flag));
        if (this.mapFeaturesEnabled) {
            this.mineshaftGenerator.func_175794_a(this.worldObj, this.rand, chunkcoordintpair);
            flag = this.villageGenerator.func_175794_a(this.worldObj, this.rand, chunkcoordintpair);
            this.strongholdGenerator.func_175794_a(this.worldObj, this.rand, chunkcoordintpair);
            this.scatteredFeatureGenerator.func_175794_a(this.worldObj, this.rand, chunkcoordintpair);
        }
        if (Biome2 != Biomes.field_76769_d && Biome2 != Biomes.field_76786_s && !flag && this.rand.nextInt(4) == 0 && TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
            int i1 = this.rand.nextInt(16) + 8;
            int j1 = this.rand.nextInt(256);
            int k1 = this.rand.nextInt(16) + 8;
            new WorldGenLakes((Block)Blocks.field_150355_j).func_180709_b(this.worldObj, this.rand, blockpos.func_177982_a(i1, j1, k1));
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA) && !flag && this.rand.nextInt(8) == 0) {
            int i2 = this.rand.nextInt(16) + 8;
            int l2 = this.rand.nextInt(this.rand.nextInt(248) + 8);
            int k3 = this.rand.nextInt(16) + 8;
            if (l2 < 63 || this.rand.nextInt(10) == 0) {
                new WorldGenLakes((Block)Blocks.field_150353_l).func_180709_b(this.worldObj, this.rand, blockpos.func_177982_a(i2, l2, k3));
            }
        }
        boolean doGen = TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON);
        for (int j2 = 0; doGen && j2 < 8; ++j2) {
            int i3 = this.rand.nextInt(16) + 8;
            int l3 = this.rand.nextInt(256);
            int l1 = this.rand.nextInt(16) + 8;
            new WorldGenDungeons().func_180709_b(this.worldObj, this.rand, blockpos.func_177982_a(i3, l3, l1));
        }
        Biome2.func_180624_a(this.worldObj, this.rand, new BlockPos(k, 0, l));
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldEntitySpawner.func_77191_a((World)this.worldObj, (Biome)Biome2, (int)(k + 8), (int)(l + 8), (int)16, (int)16, (Random)this.rand);
        }
        blockpos = blockpos.func_177982_a(8, 0, 8);
        doGen = TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE);
        for (int k2 = 0; doGen && k2 < 16; ++k2) {
            for (int j3 = 0; j3 < 16; ++j3) {
                BlockPos blockpos1 = this.worldObj.func_175725_q(blockpos.func_177982_a(k2, 0, j3));
                BlockPos blockpos2 = blockpos1.func_177977_b();
                if (this.worldObj.func_175675_v(blockpos2)) {
                    this.worldObj.func_180501_a(blockpos2, Blocks.field_150432_aD.func_176223_P(), 2);
                }
                if (!this.worldObj.func_175708_f(blockpos1, true)) continue;
                this.worldObj.func_180501_a(blockpos1, Blocks.field_150431_aC.func_176223_P(), 2);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post((IChunkGenerator)this, this.worldObj, this.rand, x, z, flag));
        BlockFalling.field_149832_M = false;
    }

    public List func_177458_a(EnumCreatureType p_73155_1_, BlockPos pos) {
        Biome Biome2 = this.worldObj.getBiomeForCoordsBody(pos);
        return p_73155_1_ == EnumCreatureType.MONSTER && this.scatteredFeatureGenerator.func_175798_a(pos) ? this.scatteredFeatureGenerator.func_82667_a() : Biome2.func_76747_a(p_73155_1_);
    }

    public BlockPos func_180513_a(World world, String structureName, BlockPos position, boolean findUnexplored) {
        return "Stronghold".equals(structureName) && this.strongholdGenerator != null ? this.strongholdGenerator.func_180706_b(world, position, false) : null;
    }

    public void func_180514_a(Chunk p_180514_1_, int p_82695_1_, int p_82695_2_) {
        if (this.mapFeaturesEnabled) {
            this.mineshaftGenerator.func_186125_a(this.worldObj, p_82695_1_, p_82695_2_, null);
            this.villageGenerator.func_186125_a(this.worldObj, p_82695_1_, p_82695_2_, null);
            this.strongholdGenerator.func_186125_a(this.worldObj, p_82695_1_, p_82695_2_, null);
            this.scatteredFeatureGenerator.func_186125_a(this.worldObj, p_82695_1_, p_82695_2_, null);
        }
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }
}

