/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte.world;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import jp.ngt.mcte.MCTE;
import jp.ngt.mcte.block.TileEntityMiniature;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.block.NGTObject;
import jp.ngt.ngtlib.world.NGTWorld;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MCTEWorld
extends NGTWorld {
    public boolean updated;
    private long tickCount;
    private List<BUEntry> updateList = new ArrayList<BUEntry>();
    private Map<BlockPos, ITickable> tickables = new HashMap<BlockPos, ITickable>();
    private boolean syncFlag = false;

    public MCTEWorld(World par1, NGTObject par2, int x2, int y2, int z2) {
        super(par1, par2, x2, y2, z2);
        this.initWorld();
    }

    public MCTEWorld(World par1, NGTObject par2) {
        super(par1, par2);
        this.initWorld();
    }

    protected void initWorld() {
        this.updated = true;
        for (int i = 0; i < this.blockObject.xSize; ++i) {
            for (int j = 0; j < this.blockObject.ySize; ++j) {
                for (int k = 0; k < this.blockObject.zSize; ++k) {
                    BlockPos pos = new BlockPos(i, j, k);
                    TileEntity tileEntity = this.func_175625_s(pos);
                    if (tileEntity == null) continue;
                    this.func_175690_a(pos, tileEntity);
                }
            }
        }
    }

    public boolean func_180501_a(BlockPos pos, IBlockState newState, int flags) {
        if (!this.field_72995_K) {
            int meta = newState.func_177230_c().func_176201_c(newState);
            if (this.blockObject.setBlockSet(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), newState.func_177230_c(), meta)) {
                this.func_175722_b(pos, newState.func_177230_c(), true);
                TileEntityMiniature miniature = (TileEntityMiniature)BlockUtil.getTileEntity((IBlockAccess)this.world, (int)this.posX, (int)this.posY, (int)this.posZ);
                miniature.func_189518_D_();
                this.updated = true;
                if (newState.func_177230_c().func_149740_M(newState)) {
                    this.func_175666_e(pos, newState.func_177230_c());
                }
                return true;
            }
        }
        return false;
    }

    public void func_175690_a(BlockPos pos, @Nullable TileEntity tileEntity) {
        tileEntity.func_145834_a((World)this);
        this.worldTileEntities.put(pos, tileEntity);
        if (tileEntity instanceof ITickable) {
            this.tickables.put(pos, (ITickable)tileEntity);
        }
    }

    public void func_175713_t(BlockPos pos) {
        this.worldTileEntities.remove(pos);
        this.tickables.remove(pos);
    }

    public void func_180497_b(BlockPos pos, Block block, int delay, int priority) {
        this.func_175654_a(pos, block, delay, priority);
    }

    public void func_175684_a(BlockPos pos, Block blockIn, int delay) {
        this.func_175654_a(pos, blockIn, delay, 0);
    }

    public void func_175654_a(BlockPos pos, Block block, int delay, int priority) {
        this.updateList.add(new BUEntry(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), block, (long)delay + this.func_82737_E(), priority));
    }

    public boolean func_175691_a(BlockPos pos, Block blockType) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int i = 0; i < this.updateList.size(); ++i) {
            BUEntry entry = this.updateList.get(i);
            if (entry.x != x || entry.y != y || entry.z != z) continue;
            return true;
        }
        return false;
    }

    public void func_175641_c(BlockPos pos, Block blockIn, int eventID, int eventParam) {
        this.func_180495_p(pos).func_189547_a((World)this, pos, eventID, eventParam);
    }

    public long func_82737_E() {
        return this.tickCount;
    }

    public void func_72835_b() {
        ++this.tickCount;
        this.func_72955_a(false);
        this.func_147456_g();
        this.func_72939_s();
    }

    public boolean func_72955_a(boolean flag) {
        if (!this.updateList.isEmpty()) {
            ArrayList<BUEntry> delList = new ArrayList<BUEntry>();
            for (int i = 0; i < this.updateList.size(); ++i) {
                BUEntry entry = this.updateList.get(i);
                if (this.func_82737_E() < entry.time) continue;
                BlockPos pos = new BlockPos(entry.x, entry.y, entry.z);
                IBlockState state = this.func_180495_p(pos);
                if (Block.func_149680_a((Block)state.func_177230_c(), (Block)entry.block)) {
                    state.func_177230_c().func_180650_b((World)this, pos, state, this.field_73012_v);
                    this.syncFlag = true;
                }
                delList.add(entry);
            }
            this.updateList.removeAll(delList);
        }
        return true;
    }

    public boolean needsSync() {
        boolean flag = this.syncFlag;
        this.syncFlag = false;
        return flag;
    }

    protected void func_147456_g() {
    }

    public void func_72939_s() {
        for (Map.Entry<BlockPos, ITickable> entry : this.tickables.entrySet()) {
            entry.getValue().func_73660_a();
        }
    }

    public void onPortChanged(int x, int y, int z) {
        this.world.func_175685_c(new BlockPos(this.posX, this.posY, this.posZ), MCTE.miniature, true);
    }

    private class BUEntry {
        public final long time;
        public final int x;
        public final int y;
        public final int z;
        public final Block block;
        public final int priority;

        public BUEntry(int p2, int p3, int p4, Block pBlock, long pTime, int pPriority) {
            this.x = p2;
            this.y = p3;
            this.z = p4;
            this.block = pBlock;
            this.time = pTime;
            this.priority = pPriority;
        }
    }
}

