/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte.world;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import jp.ngt.mcte.MCTE;
import jp.ngt.mcte.network.PacketGenerator;
import jp.ngt.ngtlib.block.BlockSet;
import jp.ngt.ngtlib.io.NGTImage;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TerrainData {
    private static BlockSet default_BlockSet = new BlockSet(Blocks.field_150348_b, 0);
    public File terrainFile;
    public File blocksFile;
    public Map<Integer, BlockSet> blockMap = new TreeMap<Integer, BlockSet>();
    public float yScale = 1.0f;

    public TerrainData() {
        this.blockMap.put(0, default_BlockSet);
    }

    public void generate(int x, int y, int z) {
        BufferedImage terrain = null;
        if (this.terrainFile != null) {
            try {
                terrain = ImageIO.read(this.terrainFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        BufferedImage blocks = null;
        if (this.blocksFile != null) {
            try {
                blocks = ImageIO.read(this.blocksFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        int height = 0;
        int width = 0;
        if (terrain != null) {
            height = terrain.getHeight();
            width = terrain.getWidth();
        } else if (blocks != null) {
            height = blocks.getHeight();
            width = blocks.getWidth();
        }
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                BlockSet set;
                int color0 = 0;
                int value = 1;
                if (terrain != null) {
                    color0 = terrain.getRGB(j, i) & 0xFFFFFF;
                    value = NGTImage.getColorValue((int)color0);
                    if ((value = (int)((float)value * this.yScale)) > 255) {
                        value = 255;
                    }
                }
                int color1 = 0;
                if (blocks != null) {
                    color1 = blocks.getRGB(j, i) & 0xFFFFFF;
                }
                if ((set = this.blockMap.get(color1)) == null) {
                    set = default_BlockSet;
                }
                for (int k = 0; k < value; ++k) {
                    int x0 = x + j;
                    int y0 = y + k;
                    int z0 = z + i;
                    MCTE.NETWORK_WRAPPER.sendToServer((IMessage)new PacketGenerator(x0, y0, z0, ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)set.block)).toString(), set.metadata));
                }
            }
        }
    }

    private static BlockSet getBlockAndColor(String s) {
        String[] sa1;
        String[] sa0 = s.split(":");
        if (sa0 != null && sa0.length == 2 && (sa1 = sa0[1].split(",")) != null && sa1.length == 2) {
            try {
                int color = Integer.decode(sa0[0]);
                Block block = Block.func_149684_b((String)sa1[0]);
                int meta = Integer.valueOf(sa1[1]);
                return new BlockSet(color, 0, 0, block, meta);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static BufferedImage getImageFromText(File file) {
        String imgName = file.getName().replace(".txt", ".png");
        File imgFile = new File(file.getParentFile(), imgName);
        try {
            return ImageIO.read(imgFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

