/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte.world;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.util.Config;
import net.minecraft.block.Block;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class WorldData {
    private Config cfg = new Config();
    private WorldGenerator generator;
    public Map<Integer, Biome> biomeMap = new TreeMap<Integer, Biome>();
    public Block baseBlock = Blocks.field_150348_b;
    public String terrainImagePath;
    public String biomesImagePath;
    public int minY;
    public float yScale = 1.0f;
    public int seaLevel = 63;

    public WorldData(String par1) {
        File file = new File(par1);
        try {
            this.loadWorldData(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected WorldData(File par1, String par2) throws IOException {
        if (par1.exists() || par2 == null) {
            this.init(par1, false);
        } else {
            par1.mkdir();
            File tmpFile = new File(par2);
            File cfgFile = new File(par1, "mcte.cfg");
            Files.copy(tmpFile.toPath(), cfgFile.toPath(), new CopyOption[0]);
            tmpFile.delete();
            this.init(par1, true);
        }
    }

    private void init(File par1, boolean par2) throws IOException {
        File cfgFile = new File(par1, "mcte.cfg");
        this.loadWorldData(cfgFile);
        File terrainImg = new File(par1, "terrain.png");
        File biomesImg = new File(par1, "biomes.png");
        if (par2) {
            File imgFile;
            if (this.cfg.containsKey("Image", "terrain")) {
                imgFile = new File(this.cfg.getProperty("Image", "terrain"));
                Files.copy(imgFile.toPath(), terrainImg.toPath(), new CopyOption[0]);
            }
            if (this.cfg.containsKey("Image", "biomes")) {
                imgFile = new File(this.cfg.getProperty("Image", "biomes"));
                Files.copy(imgFile.toPath(), biomesImg.toPath(), new CopyOption[0]);
            }
        }
        this.generator = new WorldGenerator(terrainImg, biomesImg);
    }

    public static void getBiomeColorMapFromString(Map<Integer, Biome> par1, String par2) {
        String[] sa0;
        if (par2 == null || par2.length() == 0) {
            return;
        }
        for (String s : sa0 = par2.split(",")) {
            String[] sa1 = s.split(":");
            if (sa1.length != 2) continue;
            try {
                int color = Integer.decode(sa1[0]);
                Biome biome = WorldData.getBiomeFromName(sa1[1]);
                par1.put(color, biome);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getStringFromBiomeColorMap(Map<Integer, Biome> par1) {
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<Integer, Biome>> set = par1.entrySet();
        for (Map.Entry<Integer, Biome> entry : set) {
            sb.append(String.format("0x%06x", entry.getKey())).append(":").append(entry.getValue().func_185359_l()).append(",");
        }
        return sb.toString();
    }

    public static Biome getBiomeFromName(String par1) {
        for (ResourceLocation res : Biome.field_185377_q.func_148742_b()) {
            Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)res);
            if (biome == null || !biome.func_185359_l().equals(par1)) continue;
            return biome;
        }
        return Biomes.field_76772_c;
    }

    public static WorldData getWorldData(World world, String cfgPath) {
        File saveDir = world.func_72860_G().func_75765_b();
        File mcteDir = new File(saveDir, "mcte");
        if (mcteDir.exists()) {
            try {
                return new WorldData(mcteDir, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (cfgPath != null && cfgPath.length() > 0) {
            try {
                return new WorldData(mcteDir, cfgPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void loadWorldData(File par1) throws IOException {
        this.cfg.load(par1);
        this.terrainImagePath = this.cfg.getProperty("Image", "terrain");
        this.biomesImagePath = this.cfg.getProperty("Image", "biomes");
        this.minY = NGTMath.getIntFromString((String)this.cfg.getProperty("World", "minY"), (int)0, (int)255, (int)0);
        this.yScale = NGTMath.getFloatFromString((String)this.cfg.getProperty("World", "yScale"), (float)0.00390625f, (float)256.0f, (float)1.0f);
        this.seaLevel = NGTMath.getIntFromString((String)this.cfg.getProperty("World", "seaLevel"), (int)0, (int)256, (int)63);
        WorldData.getBiomeColorMapFromString(this.biomeMap, this.cfg.getProperty("Biome", "biome_color"));
        this.baseBlock = Block.func_149684_b((String)this.cfg.getProperty("Block", "baseBlock"));
        if (this.baseBlock == null) {
            this.baseBlock = Blocks.field_150348_b;
        }
    }

    public String saveWorldData(String par1) {
        if (this.terrainImagePath != null) {
            this.cfg.setProperty("Image", "terrain", this.terrainImagePath);
        }
        if (this.biomesImagePath != null) {
            this.cfg.setProperty("Image", "biomes", this.biomesImagePath);
        }
        this.cfg.setProperty("World", "minY", String.valueOf(this.minY));
        this.cfg.setProperty("World", "yScale", String.valueOf(this.yScale));
        this.cfg.setProperty("World", "seaLevel", String.valueOf(this.seaLevel));
        this.cfg.setProperty("Biome", "biome_color", WorldData.getStringFromBiomeColorMap(this.biomeMap));
        this.cfg.setProperty("Block", "baseBlock", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.baseBlock)).toString());
        try {
            File file = new File(par1);
            if (!file.exists()) {
                file = File.createTempFile("mcte", ".cfg.tmp");
            }
            this.cfg.save(file);
            return file.getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public WorldGenerator getWorldGenerator() {
        return this.generator;
    }

    protected class WorldGenerator {
        private BufferedImage terrain;
        private BufferedImage biomes;
        private boolean genTerrain;
        private boolean genBiomes;

        public WorldGenerator(File par1, File par2) {
            try {
                this.terrain = ImageIO.read(par1);
                this.genTerrain = true;
            }
            catch (IOException e) {
                this.genTerrain = false;
            }
            catch (IllegalArgumentException e) {
                this.genTerrain = false;
            }
            try {
                this.biomes = ImageIO.read(par2);
                this.genBiomes = true;
            }
            catch (IOException e) {
                this.genBiomes = false;
            }
            catch (IllegalArgumentException e) {
                this.genBiomes = false;
            }
        }

        public boolean hasTerrainData() {
            return this.genTerrain;
        }

        public boolean hasBiomesData() {
            return this.genBiomes;
        }

        public int getHeight(int x, int z) {
            int height = this.getColor(this.terrain, x, z, 255);
            if ((height = (int)((float)height * WorldData.this.yScale) + WorldData.this.minY) > 255) {
                return 255;
            }
            return height;
        }

        public Biome getBiome(int x, int z) {
            int color = this.getColor(this.biomes, x, z, 0xFFFFFF);
            if (WorldData.this.biomeMap.containsKey(color)) {
                return WorldData.this.biomeMap.get(color);
            }
            return Biomes.field_76772_c;
        }

        protected int getColor(BufferedImage img, int x, int z, int mask) {
            int w0 = img.getWidth() >> 1;
            int h0 = img.getHeight() >> 1;
            if ((x += w0) >= 0 && x < img.getWidth() && (z += h0) >= 0 && z < img.getHeight()) {
                return img.getRGB(x, z) & mask;
            }
            return 0;
        }
    }
}

