/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.block;

import java.util.Random;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.rtm.RTMMaterial;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;

public abstract class BlockLiquidBase
extends BlockFluidClassic {
    public BlockLiquidBase(Fluid fluid, Material par1) {
        super(fluid, par1);
    }

    public int func_149738_a(World world) {
        return 5;
    }

    public boolean func_176209_a(IBlockState state, boolean hitIfLiquid) {
        return hitIfLiquid;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (!world.field_72995_K) {
            int meta;
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            int prevMeta = meta = BlockUtil.getMetadata((IBlockAccess)world, x, y, z);
            if ((meta = this.setLiquid(world, x, y, z, x, y - 1, z, meta)) == prevMeta) {
                if (meta >= 0 && this.canFlowLiquid(world, x - 1, y - 1, z) > 0 || this.canFlowLiquid(world, x - 1, y, z) + meta > 15) {
                    meta = this.setLiquid(world, x, y, z, x - 1, y, z, meta);
                }
                if (meta >= 0 && this.canFlowLiquid(world, x + 1, y - 1, z) > 0 || this.canFlowLiquid(world, x + 1, y, z) + meta > 15) {
                    meta = this.setLiquid(world, x, y, z, x + 1, y, z, meta);
                }
                if (meta >= 0 && this.canFlowLiquid(world, x, y - 1, z - 1) > 0 || this.canFlowLiquid(world, x, y, z - 1) + meta > 15) {
                    meta = this.setLiquid(world, x, y, z, x, y, z - 1, meta);
                }
                if (meta >= 0 && this.canFlowLiquid(world, x, y - 1, z + 1) > 0 || this.canFlowLiquid(world, x, y, z + 1) + meta > 15) {
                    meta = this.setLiquid(world, x, y, z, x, y, z + 1, meta);
                }
            }
            if (this == BlockUtil.getBlock((IBlockAccess)world, x, y, z)) {
                this.meltNeighborBlocks(world, x, y, z, random);
            }
            if (meta != prevMeta) {
                world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 0);
            }
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (this == BlockUtil.getBlock((IBlockAccess)world, pos)) {
            world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 0);
        }
    }

    protected int canFlowLiquid(World world, int x, int y, int z) {
        if (world.func_175623_d(new BlockPos(x, y, z))) {
            return 15;
        }
        if (this == BlockUtil.getBlock((IBlockAccess)world, x, y, z)) {
            return 14 - BlockUtil.getMetadata((IBlockAccess)world, x, y, z);
        }
        return -1;
    }

    protected int setLiquid(World world, int x, int y, int z, int targetX, int targetY, int targetZ, int myMetadata) {
        int i0 = this.canFlowLiquid(world, targetX, targetY, targetZ);
        if (i0 >= 0) {
            BlockUtil.setBlock(world, targetX, targetY, targetZ, (Block)this, this.clampMetadata(15 - i0), 2);
            world.func_180497_b(new BlockPos(targetX, targetY, targetZ), (Block)this, this.func_149738_a(world), 0);
            if (myMetadata > 0) {
                BlockUtil.setBlock(world, x, y, z, (Block)this, this.clampMetadata(--myMetadata), 2);
                return myMetadata;
            }
            world.func_175698_g(new BlockPos(x, y, z));
            return -1;
        }
        return myMetadata;
    }

    public static int addLiquid(World world, int x, int y, int z, Block block, int amount, boolean checkBlock) {
        Block block0 = BlockUtil.getBlock((IBlockAccess)world, x, y, z);
        if (!checkBlock || block0 == Blocks.field_150350_a || block0 == block && block0 instanceof BlockLiquidBase) {
            int i0 = BlockUtil.getMetadata((IBlockAccess)world, x, y, z) + amount;
            int i1 = i0 & 0xF;
            BlockUtil.setBlock(world, x, y, z, block, i1, 2);
            return i0 > i1 ? i0 - i1 : 0;
        }
        return amount;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 0);
    }

    protected int clampMetadata(int par1) {
        return NGTMath.clamp(par1, 0, 15);
    }

    private void meltNeighborBlocks(World world, int x, int y, int z, Random random) {
        int i = random.nextInt(BlockUtil.facing.length);
        int x0 = x + BlockUtil.facing[i][0];
        int y0 = y + BlockUtil.facing[i][1];
        int z0 = z + BlockUtil.facing[i][2];
        this.meltBlock(world, x0, y0, z0);
    }

    protected void meltBlock(World world, int x, int y, int z) {
        IBlockState state = world.func_180495_p(new BlockPos(x, y, z));
        Block block = BlockUtil.getBlock((IBlockAccess)world, x, y, z);
        Material material = block.func_149688_o(state);
        if (material == RTMMaterial.fireproof || material == RTMMaterial.melted || material == Material.field_151579_a || material == Material.field_151587_i || material == Material.field_151586_h) {
            return;
        }
        if (material == Material.field_151578_c) {
            this.setFire(world, x, y, z);
        } else {
            if (block == Blocks.field_150357_h) {
                return;
            }
            if (material == Material.field_151576_e || material == Material.field_151573_f || material == Material.field_151574_g) {
                BlockPos blockPos = new BlockPos(x, y, z);
                if (block.func_176195_g(state, world, blockPos) < 3.5f) {
                    this.setFire(world, x, y, z);
                }
            } else {
                if (material == Material.field_151595_p || material == Material.field_151571_B) {
                    return;
                }
                if (block == Blocks.field_150335_W) {
                    BlockPos pos = new BlockPos(x, y, z);
                    world.func_175698_g(pos);
                    Blocks.field_150335_W.func_176206_d(world, pos, Blocks.field_150335_W.func_176223_P());
                } else if (material.func_76217_h()) {
                    this.setFire(world, x, y, z);
                } else if (material == Material.field_151577_b || material == Material.field_151594_q || material == Material.field_151583_m || material == Material.field_151585_k || material == Material.field_151589_v || material == Material.field_151570_A || material == Material.field_151569_G || material == Material.field_151572_C) {
                    this.setFire(world, x, y, z);
                } else if (material == Material.field_151581_o || material == Material.field_151592_s || material == Material.field_151591_t || material == Material.field_151588_w || material == Material.field_151598_x || material == Material.field_151597_y || material == Material.field_151596_z || material == Material.field_151568_F) {
                    world.func_175698_g(new BlockPos(x, y, z));
                }
            }
        }
    }

    private void setFire(World world, int x, int y, int z) {
        for (int i = 0; i < BlockUtil.facing.length; ++i) {
            int x0 = x - BlockUtil.facing[i][0];
            int y0 = y - BlockUtil.facing[i][1];
            int z0 = z - BlockUtil.facing[i][2];
            if (!BlockUtil.isAir((IBlockAccess)world, x0, y0, z0)) continue;
            BlockUtil.setBlock(world, x0, y0, z0, (Block)Blocks.field_150480_ab, i, 2);
        }
    }
}

