/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.block;

import jp.ngt.ngtlib.block.BlockUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSet
implements Comparable<BlockSet> {
    public static final BlockSet AIR = new BlockSet(Blocks.field_150350_a, 0);
    public final int x;
    public final int y;
    public final int z;
    public final Block block;
    public final byte metadata;
    public final NBTTagCompound nbt;
    private final int blockId;

    public BlockSet(Block par1, int par2) {
        this(0, -1, 0, par1, par2);
    }

    public BlockSet(Block par1, int par2, NBTTagCompound par3) {
        this(0, -1, 0, par1, par2, par3);
    }

    public BlockSet(int par1, int par2, int par3, Block par4, int par5) {
        this(par1, par2, par3, par4, par5, null);
    }

    public BlockSet(int par1, int par2, int par3, Block par4, int par5, NBTTagCompound par6) {
        this.x = par1;
        this.y = par2;
        this.z = par3;
        this.block = par4;
        this.metadata = (byte)par5;
        this.nbt = par6;
        this.blockId = Block.func_149682_b((Block)par4);
    }

    public boolean hasNBT() {
        return this.nbt != null;
    }

    public BlockSet setNBT(NBTTagCompound nbt) {
        return new BlockSet(this.block, this.metadata, nbt);
    }

    public static BlockSet readFromNBT(NBTTagCompound nbt) {
        Block block = Block.func_149684_b((String)nbt.func_74779_i("Block"));
        if (block == null) {
            return AIR;
        }
        int meta = 0;
        meta = nbt.func_150297_b("Meta", 3) ? nbt.func_74762_e("Meta") : (int)nbt.func_74771_c("Meta");
        if (nbt.func_74764_b("TagData")) {
            NBTTagCompound tagCompound = nbt.func_74775_l("TagData");
            return new BlockSet(block, meta, tagCompound);
        }
        return new BlockSet(block, meta);
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        String name = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.block)).toString();
        if (name == null) {
            return nbt;
        }
        nbt.func_74778_a("Block", name);
        nbt.func_74774_a("Meta", this.metadata);
        if (this.nbt != null) {
            nbt.func_74782_a("TagData", (NBTBase)this.nbt);
        }
        return nbt;
    }

    public static BlockSet toBlockSet(BlockPos pos) {
        return new BlockSet(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), null, 0);
    }

    public BlockPos toBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public IBlockState toBlockState() {
        return this.block.func_176203_a((int)this.metadata);
    }

    public static BlockSet getBlockSet(World world, int x, int y, int z, boolean savePos) {
        TileEntity tile;
        Block block = BlockUtil.getBlock((IBlockAccess)world, x, y, z);
        int meta = BlockUtil.getMetadata((IBlockAccess)world, x, y, z);
        NBTTagCompound nbt = null;
        if (block.hasTileEntity(block.func_176203_a(meta)) && (tile = BlockUtil.getTileEntity((IBlockAccess)world, x, y, z)) != null) {
            nbt = new NBTTagCompound();
            tile.func_189515_b(nbt);
        }
        if (savePos) {
            return new BlockSet(x, y, z, block, meta, nbt);
        }
        return new BlockSet(block, meta, nbt);
    }

    public BlockSet asKey() {
        BlockSet set = new BlockSet(0, -1, 0, this.block, this.metadata, this.nbt);
        return set;
    }

    public boolean equals(Object par1) {
        if (par1 instanceof BlockSet) {
            boolean falgNBT;
            BlockSet bs = (BlockSet)par1;
            boolean flagMeta = this.block == bs.block && bs.metadata == this.metadata;
            boolean bl = falgNBT = this.nbt != null && bs.nbt != null ? this.nbt.equals((Object)bs.nbt) : true;
            if (this.y < 0 && bs.y < 0) {
                return flagMeta && falgNBT;
            }
            return bs.x == this.x && bs.y == this.y && bs.z == this.z && flagMeta && falgNBT;
        }
        return false;
    }

    public int hashCode() {
        return this.blockId;
    }

    @Override
    public int compareTo(BlockSet obj) {
        return this.blockId - obj.blockId;
    }
}

