/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.block;

import java.util.ArrayList;
import java.util.List;
import jp.ngt.ngtlib.math.NGTMath;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class BlockUtil {
    public static final int[][] facing = new int[][]{{0, -1, 0}, {0, 1, 0}, {0, 0, -1}, {0, 0, 1}, {-1, 0, 0}, {1, 0, 0}};
    public static final int[][] field_01 = new int[][]{{1, 0, 0}, {-1, 0, 0}, {0, 1, 0}, {0, -1, 0}, {0, 0, 1}, {0, 0, -1}};

    public static boolean[] isConnectedBlock(IBlockAccess world, Object[][] blocks, int x, int y, int z) {
        boolean[] b0 = new boolean[6];
        block0: for (int i0 = 0; i0 < 6; ++i0) {
            boolean i2 = false;
            for (int i1 = 0; i1 < blocks.length; ++i1) {
                boolean flag2;
                IBlockState state = world.func_180495_p(new BlockPos(x + field_01[i0][0], y + field_01[i0][1], z + field_01[i0][2]));
                boolean flag1 = blocks[i1][0].equals(state.func_177230_c());
                boolean bl = flag2 = blocks[i1][1].equals(-1) || blocks[i1][1].equals(state.func_177230_c().func_176201_c(state));
                if (!flag1 || !flag2) continue;
                b0[i0] = true;
                continue block0;
            }
        }
        return b0;
    }

    public static boolean[] isConnectedSolid(IBlockAccess world, int x, int y, int z) {
        return new boolean[]{world.isSideSolid(new BlockPos(x + 1, y, z), EnumFacing.WEST, true), world.isSideSolid(new BlockPos(x - 1, y, z), EnumFacing.EAST, true), world.isSideSolid(new BlockPos(x, y + 1, z), EnumFacing.DOWN, true), world.isSideSolid(new BlockPos(x, y - 1, z), EnumFacing.UP, true), world.isSideSolid(new BlockPos(x, y, z + 1), EnumFacing.NORTH, true), world.isSideSolid(new BlockPos(x, y, z - 1), EnumFacing.SOUTH, true)};
    }

    public static List<int[]> getBlockList(IBlockAccess world, int x, int y, int z, Block block, int range) {
        ArrayList<int[]> array = new ArrayList<int[]>();
        int r2 = range * 2;
        for (int i0 = 0; i0 < r2; ++i0) {
            for (int i1 = 0; i1 < r2; ++i1) {
                for (int i2 = 0; i2 < r2; ++i2) {
                    Block block2 = world.func_180495_p(new BlockPos(x - range + i0, y - range + i1, z - range + i2)).func_177230_c();
                    if (block2 != block || i0 == range && i1 == range && i2 == range) continue;
                    array.add(new int[]{x - range + i0, y - range + i1, z - range + i2});
                }
            }
        }
        return array;
    }

    public static int[] rotateBlockPos(byte rotation, int x, int y, int z) {
        if (rotation == 1) {
            return new int[]{-z, y, x};
        }
        if (rotation == 2) {
            return new int[]{-x, y, -z};
        }
        if (rotation == 3) {
            return new int[]{z, y, -x};
        }
        return new int[]{x, y, z};
    }

    public static RayTraceResult getMOPFromPlayer(EntityPlayer player, double distance, boolean liquid) {
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f + 1.62 - player.func_70033_W();
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3d vec3 = new Vec3d(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - NGTMath.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - NGTMath.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        Vec3d vec31 = vec3.func_72441_c((double)f7 * distance, (double)f6 * distance, (double)f8 * distance);
        return player.field_70170_p.func_72901_a(vec3, vec31, liquid);
    }

    public static boolean isAir(IBlockAccess world, int x, int y, int z) {
        return BlockUtil.getBlock(world, new BlockPos(x, y, z)) == Blocks.field_150350_a;
    }

    public static IBlockState getBlockState(IBlockAccess world, int x, int y, int z) {
        return world.func_180495_p(new BlockPos(x, y, z));
    }

    public static Block getBlock(IBlockAccess world, int x, int y, int z) {
        return BlockUtil.getBlock(world, new BlockPos(x, y, z));
    }

    public static Block getBlock(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c();
    }

    public static int getMetadata(IBlockAccess world, int x, int y, int z) {
        return BlockUtil.getMetadata(world, new BlockPos(x, y, z));
    }

    public static int getMetadata(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().func_176201_c(state);
    }

    public static TileEntity getTileEntity(IBlockAccess world, int x, int y, int z) {
        return BlockUtil.getTileEntity(world, new BlockPos(x, y, z));
    }

    public static TileEntity getTileEntity(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (!state.func_177230_c().hasTileEntity(state)) {
            return null;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null && world instanceof World) {
            List list = ((World)world).field_147482_g;
            for (int i = 0; i < list.size(); ++i) {
                if (!pos.equals((Object)((TileEntity)list.get(i)).func_174877_v())) continue;
                return (TileEntity)list.get(i);
            }
        }
        return tile;
    }

    public static boolean setAir(World world, int x, int y, int z) {
        return BlockUtil.setBlock(world, x, y, z, Blocks.field_150350_a, 0, 3);
    }

    public static boolean setBlock(World world, int x, int y, int z, Block block, int meta, int flag) {
        return BlockUtil.setBlock(world, new BlockPos(x, y, z), block, meta, flag);
    }

    public static boolean setBlock(World world, BlockPos pos, Block block, int meta, int flag) {
        IBlockState newState = block.func_176203_a(meta);
        boolean b = world.func_180501_a(pos, newState, flag);
        return b;
    }

    public static void markBlockForUpdate(World world, int x, int y, int z) {
        BlockUtil.markBlockForUpdate(world, new BlockPos(x, y, z));
    }

    public static void markBlockForUpdate(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        world.func_184138_a(pos, state, state, 2);
    }

    public static int[] toArray(BlockPos pos) {
        return new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
    }

    public static void playBlockBreakSound(World world, BlockPos pos, Block block, int meta) {
        world.func_175718_b(2001, pos, Block.func_149682_b((Block)block) + (meta << 12));
    }
}

