/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.block;

import java.util.ArrayList;
import jp.ngt.ngtlib.block.BlockSet;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.block.NGTObject;
import jp.ngt.ngtlib.block.TileEntityCustom;
import jp.ngt.ngtlib.io.NGTLog;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class NGTOUtil {
    public static NGTObject copyBlocks(World world, int x, int y, int z, int width, int height, int depth) {
        NGTLog.startTimer();
        ArrayList<BlockSet> list = new ArrayList<BlockSet>();
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                for (int k = 0; k < depth; ++k) {
                    TileEntity tile;
                    int x0 = x + i;
                    int y0 = y + j;
                    int z0 = z + k;
                    Block block = BlockUtil.getBlock((IBlockAccess)world, x0, y0, z0);
                    int meta = BlockUtil.getMetadata((IBlockAccess)world, x0, y0, z0);
                    NBTTagCompound nbt = null;
                    if (block.hasTileEntity(block.func_176203_a(meta)) && (tile = BlockUtil.getTileEntity((IBlockAccess)world, x0, y0, z0)) != null) {
                        nbt = new NBTTagCompound();
                        tile.func_189515_b(nbt);
                    }
                    list.add(new BlockSet(block, meta, nbt));
                }
            }
        }
        NGTLog.stopTimer("copy block");
        NGTObject object = NGTObject.createNGTO(list, width, height, depth, x, y, z);
        return object;
    }

    public static void deleteBlocks(World world, int x, int y, int z, int width, int height, int depth, int flag) {
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                for (int k = 0; k < depth; ++k) {
                    int x0 = x + i;
                    int y0 = y + j;
                    int z0 = z + k;
                    BlockUtil.setBlock(world, x0, y0, z0, Blocks.field_150350_a, 0, flag);
                }
            }
        }
    }

    public static void setBlocks(World world, int x, int y, int z, NGTObject ngto, int flag) {
        int index = 0;
        for (int i = 0; i < ngto.xSize; ++i) {
            for (int j = 0; j < ngto.ySize; ++j) {
                for (int k = 0; k < ngto.zSize; ++k) {
                    TileEntity tile;
                    int x0 = x + i;
                    int y0 = y + j;
                    int z0 = z + k;
                    BlockSet set = ngto.blockList.get(index);
                    NGTOUtil.setBlock(world, x0, y0, z0, set.block, set.metadata, flag);
                    if (set.block.hasTileEntity(set.block.func_176203_a((int)set.metadata)) && (tile = BlockUtil.getTileEntity((IBlockAccess)world, x0, y0, z0)) != null) {
                        NGTOUtil.setTileEntityData(tile, set.nbt, x0, y0, z0);
                    }
                    ++index;
                }
            }
        }
    }

    private static void setBlock(World world, int x, int y, int z, Block block, int metadata, int flag) {
        if (block instanceof BlockLeaves && (metadata < 4 || metadata > 7)) {
            metadata = (metadata & 3) + 4;
        }
        BlockUtil.setBlock(world, x, y, z, block, metadata, flag);
        if (block != Blocks.field_150350_a) {
            world.func_175664_x(new BlockPos(x, y, z));
        }
    }

    private static void setTileEntityData(TileEntity tile, NBTTagCompound nbt, int x, int y, int z) {
        int prevX = 0;
        int prevY = 0;
        int prevZ = 0;
        if (nbt != null) {
            NBTTagCompound nbt0 = nbt.func_74737_b();
            prevX = nbt0.func_74762_e("x");
            prevY = nbt0.func_74762_e("y");
            prevZ = nbt0.func_74762_e("z");
            nbt0.func_74768_a("x", x);
            nbt0.func_74768_a("y", y);
            nbt0.func_74768_a("z", z);
            tile.func_145839_a(nbt0);
        }
        if (tile instanceof TileEntityCustom) {
            ((TileEntityCustom)tile).setPos(x, y, z, prevX, prevY, prevZ);
        } else {
            tile.func_174878_a(new BlockPos(x, y, z));
        }
    }
}

