/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.block;

import com.google.common.collect.HashBiMap;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.ngt.ngtlib.block.BlockSet;
import jp.ngt.ngtlib.io.FileType;
import jp.ngt.ngtlib.renderer.model.VoxelUtil;
import jp.ngt.ngtlib.util.NBTUtil;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.ngtlib.world.NGTWorld;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NGTObject {
    private static List<NGTObject> loadedNGTO = new ArrayList<NGTObject>();
    public long objId;
    public HashBiMap<Integer, BlockSet> blockIdMap = HashBiMap.create();
    public List<BlockSet> blockList;
    private NBTTagList entityList;
    public int xSize;
    public int ySize;
    public int zSize;
    public int origX;
    public int origY;
    public int origZ;
    @Deprecated
    private int lightValue = -1;

    public static NGTObject createNGTO(List<BlockSet> blocks, int w, int h, int d, int x, int y, int z) {
        return NGTObject.createNGTO(blocks, new NBTTagList(), w, h, d, x, y, z);
    }

    public static NGTObject createNGTO(List<BlockSet> blocks, NBTTagList nbt, int w, int h, int d, int x, int y, int z) {
        return NGTObject.createNGTO(NGTUtil.getUniqueId(), blocks, nbt, w, h, d, x, y, z);
    }

    public static NGTObject createNGTO(long id, List<BlockSet> blocks, NBTTagList nbt, int w, int h, int d, int x, int y, int z) {
        NGTObject ngto = new NGTObject(id, blocks, nbt, w, h, d, x, y, z);
        int index = loadedNGTO.indexOf(ngto);
        if (index >= 0) {
            return loadedNGTO.get(index);
        }
        return ngto;
    }

    private NGTObject(long id, List<BlockSet> blocks, NBTTagList nbt, int w, int h, int d, int x, int y, int z) {
        this.objId = id;
        this.blockList = blocks;
        this.entityList = nbt;
        this.xSize = w;
        this.ySize = h;
        this.zSize = d;
        this.origX = x;
        this.origY = y;
        this.origZ = z;
        loadedNGTO.add(this);
    }

    public boolean isValidPos(int x, int y, int z) {
        return x >= 0 && y >= 0 && z >= 0 && x < this.xSize && y < this.ySize && z < this.zSize;
    }

    public BlockSet getBlockSet(int x, int y, int z) {
        int index;
        if (this.isValidPos(x, y, z) && (index = x * this.ySize * this.zSize + y * this.zSize + z) < this.blockList.size()) {
            return this.blockList.get(index);
        }
        return BlockSet.AIR;
    }

    public boolean setBlockSet(int x, int y, int z, Block block, int meta) {
        int index;
        if (this.isValidPos(x, y, z) && (index = x * this.ySize * this.zSize + y * this.zSize + z) < this.blockList.size()) {
            BlockSet set = this.getBlockSet(x, y, z);
            if (block != set.block || meta != set.metadata) {
                this.blockList.set(index, new BlockSet(x, y, z, block, meta));
                return true;
            }
        }
        return false;
    }

    public NBTTagCompound writeToNBT() {
        HashMap<BlockSet, Integer> idMap = new HashMap<BlockSet, Integer>();
        idMap.put(BlockSet.AIR, 0);
        int idCount = 1;
        NBTTagCompound nbts = new NBTTagCompound();
        int[] blockIds = new int[this.blockList.size()];
        for (int i = 0; i < this.blockList.size(); ++i) {
            BlockSet set = this.blockList.get(i).asKey();
            Integer val = (Integer)idMap.get(set);
            if (val == null) {
                val = idCount;
                idMap.put(set, val);
                ++idCount;
            }
            blockIds[i] = val;
            if (!set.hasNBT()) continue;
            nbts.func_74782_a(String.valueOf(i), (NBTBase)set.nbt);
        }
        NBTTagCompound data = new NBTTagCompound();
        if (idCount > 255) {
            data.func_74783_a("IData", blockIds);
        } else {
            byte[] bytes = new byte[blockIds.length];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (byte)(blockIds[i] - 128);
            }
            data.func_74773_a("BData", bytes);
        }
        data.func_74782_a("NBTs", (NBTBase)nbts);
        NBTTagList tagList2 = new NBTTagList();
        for (Map.Entry set : idMap.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a("Set", (NBTBase)((BlockSet)set.getKey()).writeToNBT());
            tag.func_74768_a("Id", ((Integer)set.getValue()).intValue());
            tagList2.func_74742_a((NBTBase)tag);
        }
        data.func_74782_a("IdList", (NBTBase)tagList2);
        data.func_74768_a("SizeX", this.xSize);
        data.func_74768_a("SizeY", this.ySize);
        data.func_74768_a("SizeZ", this.zSize);
        data.func_74768_a("OrigX", this.origX);
        data.func_74768_a("OrigY", this.origY);
        data.func_74768_a("OrigZ", this.origZ);
        data.func_74772_a("ObjId", this.objId);
        data.func_74782_a("Entities", (NBTBase)this.entityList);
        return NGTObject.compress(data);
    }

    public static NGTObject readFromNBT(NBTTagCompound data) {
        int i;
        int[] ids;
        if (data.func_74764_b("ByteData")) {
            data = NGTObject.decompress(data);
        }
        HashMap<Integer, BlockSet> idMap = new HashMap<Integer, BlockSet>();
        idMap.put(0, BlockSet.AIR);
        NBTTagList tagList2 = data.func_150295_c("IdList", 10);
        for (int i2 = 0; i2 < tagList2.func_74745_c(); ++i2) {
            NBTTagCompound tag = tagList2.func_150305_b(i2);
            BlockSet set = BlockSet.readFromNBT(tag.func_74775_l("Set"));
            int id = tag.func_74762_e("Id");
            idMap.put(id, set);
        }
        ArrayList<BlockSet> list = new ArrayList<BlockSet>();
        if (data.func_74764_b("IData") || data.func_74764_b("Blocks")) {
            ids = data.func_74764_b("IData") ? data.func_74759_k("IData") : data.func_74759_k("Blocks");
        } else {
            byte[] bytes = data.func_74770_j("BData");
            ids = new int[bytes.length];
            for (i = 0; i < bytes.length; ++i) {
                ids[i] = bytes[i] + 128;
            }
        }
        if (ids != null) {
            NBTTagCompound nbts = data.func_74775_l("NBTs");
            for (i = 0; i < ids.length; ++i) {
                BlockSet set;
                int id = ids[i];
                BlockSet blockSet = set = idMap.containsKey(id) ? (BlockSet)idMap.get(id) : BlockSet.AIR;
                if (nbts.func_74764_b(String.valueOf(i))) {
                    NBTTagCompound tagData = nbts.func_74775_l(String.valueOf(i));
                    list.add(set.setNBT(tagData));
                    continue;
                }
                list.add(set);
            }
        }
        int x = data.func_74762_e("SizeX");
        int y = data.func_74762_e("SizeY");
        int z = data.func_74762_e("SizeZ");
        int ox = data.func_74762_e("OrigX");
        int oy = data.func_74762_e("OrigY");
        int oz = data.func_74762_e("OrigZ");
        long objId = data.func_74763_f("ObjId");
        NBTTagList tagList = data.func_150295_c("Entities", 10);
        if (tagList == null) {
            tagList = new NBTTagList();
        }
        return NGTObject.createNGTO(objId, list, tagList, x, y, z, ox, oy, oz);
    }

    private static NBTTagCompound compress(NBTTagCompound data) {
        byte[] compressedData = NBTUtil.compress(data);
        if (compressedData != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74773_a("ByteData", compressedData);
            return nbt;
        }
        return data;
    }

    private static NBTTagCompound decompress(NBTTagCompound data) {
        byte[] compressedData = data.func_74770_j("ByteData");
        NBTTagCompound decData = NBTUtil.decompress(compressedData);
        return decData != null ? decData : data;
    }

    public void exportToFile(File file) {
        if (FileType.OBJ.match(file)) {
            VoxelUtil.exportToPolygon(this, file);
            return;
        }
        NBTTagCompound data = this.writeToNBT();
        try {
            CompressedStreamTools.func_74795_b((NBTTagCompound)data, (File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static NGTObject importFromFile(File file, float scale) {
        NBTTagCompound data;
        if (FileType.OBJ.match(file) || FileType.MQO.match(file)) {
            return VoxelUtil.importFromPolygon(file, scale);
        }
        try {
            data = CompressedStreamTools.func_74797_a((File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return NGTObject.readFromNBT(data);
    }

    public static NGTObject load(InputStream stream) {
        NBTTagCompound data;
        DataInputStream dis = new DataInputStream(new BufferedInputStream(stream));
        try {
            data = CompressedStreamTools.func_74794_a((DataInputStream)dis);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return NGTObject.readFromNBT(data);
    }

    public Template toTemplate(World par1) {
        Template template = new Template();
        NGTWorld world = new NGTWorld(par1, this);
        template.func_186254_a((World)world, new BlockPos(0, 0, 0), new BlockPos(this.xSize - 1, this.ySize - 1, this.zSize - 1), true, Blocks.field_150350_a);
        return template;
    }

    @SideOnly(value=Side.CLIENT)
    public static void addInformation(List list, NBTTagCompound data, float scale) {
        if (data.func_74764_b("ByteData")) {
            data = NGTObject.decompress(data);
        }
        int x = data.func_74762_e("SizeX");
        int y = data.func_74762_e("SizeY");
        int z = data.func_74762_e("SizeZ");
        list.add(TextFormatting.GRAY + "Size : " + x + " x " + y + " x " + z);
        list.add(TextFormatting.GRAY + "Scale : " + scale);
    }

    @Deprecated
    public int getLightValue() {
        if (this.lightValue < 0) {
            int brightness = 0;
            for (BlockSet set : this.blockList) {
                int i = set.block.func_149750_m(set.toBlockState());
                if (i > 0) {
                    brightness += i;
                    continue;
                }
                --brightness;
            }
            this.lightValue = brightness > 15 ? 15 : (brightness < 0 ? 0 : brightness);
        }
        return this.lightValue;
    }

    public NBTTagList getEntityList() {
        return this.entityList;
    }

    public int hashCode() {
        return this.xSize << 20 & 0x400 | this.ySize << 10 & 0x400 | this.zSize & 0x400;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NGTObject) {
            NGTObject ngto = (NGTObject)obj;
            if (ngto.xSize == this.xSize && ngto.ySize == this.ySize && ngto.zSize == this.zSize) {
                for (int i = 0; i < this.blockList.size(); ++i) {
                    BlockSet set1;
                    BlockSet set0 = this.blockList.get(i);
                    if (set0.equals(set1 = ngto.blockList.get(i))) continue;
                    return false;
                }
                if (this.entityList != null) {
                    return this.entityList.equals((Object)ngto.entityList);
                }
                return ngto.entityList == null;
            }
        }
        return false;
    }
}

