/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.event;

import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.command.CommandUsage;
import jp.ngt.ngtlib.event.TickProcessEntry;
import jp.ngt.ngtlib.event.TickProcessQueue;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.protection.ProtectionManager;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.ngtlib.util.VersionChecker;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class NGTEventHandler {
    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            TickProcessQueue.getInstance(Side.SERVER).onTick(event.world);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && NGTUtil.getClientWorld() != null) {
            TickProcessQueue.getInstance(Side.CLIENT).onTick(NGTUtil.getClientWorld());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientConnected(final FMLNetworkEvent.ClientConnectedToServerEvent event) {
        TickProcessQueue.getInstance(Side.CLIENT).add(new TickProcessEntry(){

            @Override
            public boolean process(World world) {
                VersionChecker.showUpdateMessage((INetHandlerPlayClient)event.getHandler());
                CommandUsage.showUsage();
                return true;
            }
        });
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ProtectionManager.INSTANCE.sendDataToClient();
    }

    @SubscribeEvent
    public void onLoadWorld(WorldEvent.Load event) {
        ProtectionManager.INSTANCE.loadData(event.getWorld());
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getItemStack().func_190926_b()) {
            return;
        }
        try {
            int x = NGTMath.floor(event.getHitVec().field_72450_a);
            int y = NGTMath.floor(event.getHitVec().field_72448_b);
            int z = NGTMath.floor(event.getHitVec().field_72449_c);
            if (ProtectionManager.INSTANCE.rightClickBlock(event.getEntityPlayer(), x, y, z) && !event.getWorld().field_72995_K) {
                event.setCanceled(true);
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        try {
            int x = NGTMath.floor(event.getHitVec().field_72450_a);
            int y = NGTMath.floor(event.getHitVec().field_72448_b);
            int z = NGTMath.floor(event.getHitVec().field_72449_c);
            if (ProtectionManager.INSTANCE.leftClickBlock(event.getEntityPlayer(), x, y, z)) {
                event.setCanceled(true);
                BlockUtil.markBlockForUpdate(event.getEntityPlayer().field_70170_p, x, y, z);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onPlayerBreakBlock(BlockEvent.BreakEvent event) {
        int x = event.getPos().func_177958_n();
        int y = event.getPos().func_177956_o();
        int z = event.getPos().func_177952_p();
        if (ProtectionManager.INSTANCE.leftClickBlock(event.getPlayer(), x, y, z)) {
            event.setCanceled(true);
            BlockUtil.markBlockForUpdate(event.getPlayer().field_70170_p, x, y, z);
        }
    }

    @SubscribeEvent
    public void onPlayerInteractEntity(PlayerInteractEvent.EntityInteract event) {
        if (ProtectionManager.INSTANCE.rightClickEntity(event.getEntityPlayer(), event.getTarget())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerAttackEntity(AttackEntityEvent event) {
        if (ProtectionManager.INSTANCE.leftClickEntity(event.getEntityPlayer(), event.getTarget())) {
            event.setCanceled(true);
        }
    }
}

