/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.io;

import java.awt.Component;
import java.awt.HeadlessException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import jp.ngt.ngtlib.NGTCore;
import jp.ngt.ngtlib.io.FileMatcher;
import jp.ngt.ngtlib.io.FileType;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.io.ScanResult;
import jp.ngt.ngtlib.util.NGTUtilClient;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public final class NGTFileLoader {
    public static final String NO_ZIP = "no_zip";
    private static final String[] EXCEPT_WORD = new String[]{"lang", "block", "item", "gui"};
    private static List<File> MODS_DIR;
    private static File PREV_OPENED_FOLDER;

    public static void log(String par1, Object ... par2) {
        if (NGTCore.debugLog) {
            NGTLog.debug(par1, par2);
        }
    }

    public static List<File> findFile(FileMatcher matcher) {
        ScanResult result = NGTFileLoader.findFile(new FileMatcher[]{matcher});
        return result.asList();
    }

    public static ScanResult findFile(FileMatcher ... matchers) {
        ScanResult findFiles = new ScanResult();
        List<File> modsDir = NGTFileLoader.getModsDir();
        for (File dir : modsDir) {
            NGTFileLoader.log("[NGTFL] Set search path : " + dir.getAbsolutePath(), new Object[0]);
            try {
                NGTFileLoader.findFileInDirectory(findFiles, dir, matchers);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return findFiles;
    }

    public static List<File> findFileInDirectory(File dir, FileMatcher matcher) throws IOException {
        ScanResult result = new ScanResult();
        NGTFileLoader.findFileInDirectory(result, dir, matcher);
        return result.asList();
    }

    public static void findFileInDirectory(ScanResult result, File dir, FileMatcher ... matchers) throws IOException {
        String[] files = dir.list();
        if (files == null || files.length == 0) {
            return;
        }
        for (String entryName : files) {
            File entry = new File(dir, entryName);
            if (entry.isFile()) {
                String name = entry.getName();
                if (FileType.ZIP.match(name) || FileType.JAR.match(name)) {
                    NGTFileLoader.findFileInZip(result, entry, "", matchers);
                    continue;
                }
                for (FileMatcher matcher : matchers) {
                    if (!matcher.match(entry)) continue;
                    result.add(NO_ZIP, matcher, entry);
                }
                continue;
            }
            if (!entry.isDirectory() || NGTFileLoader.isExeptFolder(entry)) continue;
            NGTFileLoader.findFileInDirectory(result, entry, matchers);
        }
    }

    private static void findFileInZip(ScanResult result, File archive, String encoding, FileMatcher ... matchers) {
        NGTFileLoader.log("[NGTFL] Scan zip : " + archive.getName(), new Object[0]);
        try {
            ZipFile zip = NGTFileLoader.getArchive(archive, encoding);
            zip.stream().filter(x -> !x.isDirectory()).forEach(entry -> {
                File file = new File(zip.getName(), entry.getName());
                for (FileMatcher matcher : matchers) {
                    if (!matcher.match(file)) continue;
                    result.add(archive.getName(), matcher, file);
                }
            });
            zip.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            NGTLog.debug("[NGTFL] IOException:" + archive.getName());
        }
        catch (IllegalArgumentException e) {
            if (encoding.isEmpty()) {
                NGTFileLoader.findFileInZip(result, archive, "MS932", matchers);
                return;
            }
            e.printStackTrace();
            NGTLog.debug("[NGTFL] IllegalArgumentException:" + archive.getName());
        }
    }

    private static boolean isExeptFolder(File folder) {
        if (folder.getAbsolutePath().contains("sounds")) {
            return false;
        }
        for (String word : EXCEPT_WORD) {
            if (!folder.getName().equals(word)) continue;
            return true;
        }
        return false;
    }

    public static byte[] readBytes(File par1) throws IOException {
        FileInputStream is = new FileInputStream(par1);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = ((InputStream)is).read(buffer)) > 0) {
            bout.write(buffer, 0, len);
        }
        ((InputStream)is).close();
        return bout.toByteArray();
    }

    public static List<File> getModsDir() {
        if (MODS_DIR != null) {
            return MODS_DIR;
        }
        MODS_DIR = new ArrayList<File>();
        try {
            File modsDir2 = new File(Thread.currentThread().getContextClassLoader().getResource("").getPath());
            if (!modsDir2.getAbsolutePath().contains("mods")) {
                MODS_DIR.add(modsDir2);
                NGTLog.debug("[NGTFL] Add mods dir : " + modsDir2.getAbsolutePath());
            }
        }
        catch (NullPointerException modsDir2) {
            // empty catch block
        }
        File modsDir = NGTCore.proxy.getMinecraftDirectory("mods");
        String modsDirPath = modsDir.getAbsolutePath();
        if (modsDirPath.contains(".") && !modsDirPath.contains(".minecraft")) {
            modsDirPath = modsDirPath.replace("\\.", "");
        }
        MODS_DIR.add(new File(modsDirPath));
        NGTLog.debug("[NGTFL] Add mods dir : " + modsDirPath);
        return MODS_DIR;
    }

    private static JFileChooser getCustomChooser(String title) {
        JFileChooser chooser = new JFileChooser(PREV_OPENED_FOLDER){

            @Override
            protected JDialog createDialog(Component parent) throws HeadlessException {
                JDialog dialog = super.createDialog(parent);
                dialog.setAlwaysOnTop(true);
                return dialog;
            }
        };
        chooser.setDialogTitle(title);
        chooser.requestFocusInWindow();
        return chooser;
    }

    public static synchronized File selectFile(FileType ... types) {
        JFileChooser chooser = NGTFileLoader.getCustomChooser("Select File");
        chooser.setAcceptAllFileFilterUsed(false);
        for (FileType type : types) {
            FileNameExtensionFilter filter = new FileNameExtensionFilter(type.getDescription(), type.getExtension());
            chooser.addChoosableFileFilter(filter);
        }
        int state = chooser.showOpenDialog(null);
        if (state == 0) {
            File file = chooser.getSelectedFile();
            PREV_OPENED_FOLDER = file.getParentFile();
            return file;
        }
        return null;
    }

    public static synchronized File saveFile(FileType ... types) {
        JFileChooser chooser = NGTFileLoader.getCustomChooser("Save File");
        chooser.setAcceptAllFileFilterUsed(false);
        for (FileType type : types) {
            FileNameExtensionFilter filter = new FileNameExtensionFilter(type.getDescription(), type.getExtension());
            chooser.addChoosableFileFilter(filter);
        }
        int state = chooser.showSaveDialog(null);
        if (state == 0) {
            File file = chooser.getSelectedFile();
            PREV_OPENED_FOLDER = file.getParentFile();
            if (!file.getName().contains(".")) {
                FileNameExtensionFilter filter = (FileNameExtensionFilter)chooser.getFileFilter();
                file = new File(file.getAbsolutePath() + "." + filter.getExtensions()[0]);
            }
            return file;
        }
        return null;
    }

    public static InputStream getInputStream(ResourceLocation par1) throws IOException {
        if (!NGTCore.proxy.isServer()) {
            return NGTUtilClient.getMinecraft().func_110442_L().func_110536_a(par1).func_110527_b();
        }
        int index = par1.func_110623_a().lastIndexOf("/");
        String fileName = par1.func_110623_a().substring(index + 1);
        List<File> list = NGTFileLoader.findFile((File file) -> file.getName().equals(fileName));
        if (list.isEmpty()) {
            throw new FileNotFoundException("On get stream : " + fileName);
        }
        File file2 = list.get(0);
        return NGTFileLoader.getInputStreamFromFile(file2);
    }

    public static InputStream getInputStreamFromFile(File file) throws IOException {
        String suffix = NGTFileLoader.getArchiveSuffix(file.getAbsolutePath());
        if (!suffix.isEmpty()) {
            return NGTFileLoader.getStreamFromArchive(file, suffix);
        }
        return new FileInputStream(file);
    }

    public static InputStream getStreamFromArchive(File file, String suffix) throws IOException {
        String zipPath = NGTFileLoader.getArchivePath(file.getAbsolutePath(), suffix);
        ZipFile zip = NGTFileLoader.getArchive(new File(zipPath), "");
        Enumeration<? extends ZipEntry> enu = zip.entries();
        while (enu.hasMoreElements()) {
            File fileInZip;
            ZipEntry ze = enu.nextElement();
            if (ze.isDirectory() || !(fileInZip = new File(zipPath, ze.getName())).getName().equals(file.getName())) continue;
            InputStream is = zip.getInputStream(ze);
            return new BufferedInputStream(is);
        }
        zip.close();
        throw new FileNotFoundException("On get stream : " + file.getName());
    }

    public static String getArchivePath(String absPath, String suffix) {
        int index = absPath.indexOf(suffix);
        return absPath.substring(0, index + 4);
    }

    public static ZipFile getArchive(File file, String encoding) throws IOException {
        String en2;
        String string = en2 = encoding.isEmpty() ? "UTF-8" : encoding;
        if (FileType.JAR.match(file.getName())) {
            return new JarFile(file.getAbsolutePath());
        }
        if (FileType.ZIP.match(file.getName())) {
            return new ZipFile(file.getAbsolutePath(), Charset.forName(en2));
        }
        return null;
    }

    public static String getArchiveSuffix(String absPath) {
        if (absPath.contains(".zip")) {
            return ".zip";
        }
        if (absPath.contains(".jar")) {
            return ".jar";
        }
        return "";
    }

    public static File createTempFile(InputStream is, String name) throws IOException {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File tempFile = new File(tempDir, name);
        tempFile.deleteOnExit();
        FileOutputStream out = new FileOutputStream(tempFile);
        IOUtils.copy((InputStream)is, (OutputStream)out);
        return tempFile;
    }
}

