/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.io;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import net.minecraft.client.renderer.texture.TextureUtil;
import org.lwjgl.opengl.GL11;

public final class NGTImage {
    public static int[] getARGBFromInt(int par1) {
        int a = par1 >> 24;
        int r = par1 >> 16 & 0xFF;
        int g = par1 >> 8 & 0xFF;
        int b = par1 & 0xFF;
        return new int[]{a, r, g, b};
    }

    public static int getIntFromARGB(int a, int r, int g, int b) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int getColorValue(int par1) {
        int[] argb = NGTImage.getARGBFromInt(par1);
        int value = 0;
        for (int i = 1; i < argb.length; ++i) {
            if (value >= argb[i]) continue;
            value = argb[i];
        }
        return value;
    }

    public static int getComplementaryColor(int par1) {
        int[] argb = NGTImage.getARGBFromInt(par1);
        int max = 0;
        int min = 255;
        for (int i = 1; i < argb.length; ++i) {
            if (max < argb[i]) {
                max = argb[i];
            }
            if (min <= argb[i]) continue;
            min = argb[i];
        }
        int i0 = max + min;
        return NGTImage.getIntFromARGB(argb[0], i0 - argb[1], i0 - argb[2], i0 - argb[3]);
    }

    public static class Thumbnail {
        private final BufferedImage image;
        private final int glID;

        public Thumbnail(BufferedImage source, int width, int height) {
            BufferedImage thumb = new BufferedImage(width, height, source.getType());
            Graphics2D g2d = thumb.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            g2d.drawImage(source, 0, 0, width, height, null);
            this.image = thumb;
            this.glID = TextureUtil.func_110996_a();
            TextureUtil.func_110987_a((int)this.glID, (BufferedImage)thumb);
        }

        public void bindTexture() {
            GL11.glBindTexture((int)3553, (int)this.glID);
        }

        public void deleteTexture() {
            GL11.glDeleteTextures((int)this.glID);
        }
    }
}

