/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.io;

import java.util.ArrayList;
import java.util.List;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.ngtlib.util.NGTUtilClient;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class NGTLog {
    private static final Logger logger = LogManager.getLogger((String)"NGT");
    private static final List<Long> startTimes = new ArrayList<Long>();

    public static void debug(String par1) {
        NGTLog.debug(par1, new Object[0]);
    }

    public static void debug(String par1, Object ... par2) {
        try {
            String message = par1;
            if (par2 != null && par2.length > 0) {
                message = String.format(par1, par2);
            }
            logger.log(Level.INFO, message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sendChatMessage(ICommandSender player, String message, Object ... objects) {
        player.func_145747_a((ITextComponent)new TextComponentTranslation(message, objects));
    }

    public static void sendChatMessageToAll(String message, Object ... objects) {
        if (NGTUtil.getServer() == null) {
            NGTLog.debug("[NGTLog] Can't send message. This is client.");
        } else {
            NGTUtil.getServer().func_184103_al().func_148539_a((ITextComponent)new TextComponentTranslation(message, objects));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void showChatMessage(ITextComponent component) {
        NGTUtilClient.getMinecraft().field_71456_v.func_146158_b().func_146227_a(component);
    }

    @SideOnly(value=Side.CLIENT)
    public static void showChatMessage(String message, Object ... objects) {
        NGTLog.showChatMessage((ITextComponent)new TextComponentString(String.format(message, objects)));
    }

    public static void startTimer() {
        startTimes.add(System.currentTimeMillis());
    }

    public static void resetTimer(String msg) {
        NGTLog.stopTimer(msg);
        NGTLog.startTimer();
    }

    public static void stopTimer(String msg) {
        if (startTimes.isEmpty()) {
            NGTLog.debug("Timer is not started");
        } else {
            long start = startTimes.remove(startTimes.size() - 1);
            long time = System.currentTimeMillis() - start;
            NGTLog.debug(msg + ":" + time + "ms");
        }
    }
}

