/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jp.ngt.ngtlib.io.NGTFileLoader;
import net.minecraft.util.ResourceLocation;

public final class NGTText {
    public static String getText(ResourceLocation resource, boolean indention) throws IOException {
        List<String> list = NGTText.readText(resource);
        return NGTText.append(list, indention);
    }

    public static List<String> readText(ResourceLocation resource) throws IOException {
        return NGTText.readTextL(NGTFileLoader.getInputStream(resource), "");
    }

    public static String readText(File file, boolean indention, String encoding) throws IOException {
        return NGTText.append(NGTText.readText(file, encoding), indention);
    }

    public static List<String> readText(File file, String encoding) throws IOException {
        return NGTText.readTextL(NGTFileLoader.getInputStreamFromFile(file), encoding);
    }

    public static String[][] readCSV(File file, String encoding) throws IOException {
        List<String> texts = NGTText.readText(file, encoding);
        String[][] array = new String[texts.size()][];
        for (int i = 0; i < texts.size(); ++i) {
            array[i] = texts.get(i).split(",");
        }
        return array;
    }

    public static String append(List<String> list, boolean indention) {
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            sb.append(s);
            if (!indention) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static List<String> readTextL(InputStream is, String encoding) {
        InputStreamReader isr;
        ArrayList<String> list = new ArrayList<String>();
        if (encoding == null || encoding.isEmpty()) {
            isr = new InputStreamReader(is);
        } else {
            try {
                isr = new InputStreamReader(is, encoding);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                isr = new InputStreamReader(is);
            }
        }
        BufferedReader reader = new BufferedReader(isr);
        Stream<String> stream = reader.lines();
        stream.forEachOrdered(line -> list.add((String)line));
        stream.close();
        return list;
    }

    @Deprecated
    public static List<String> readTextL(File file, String encoding) {
        ArrayList<String> strings = new ArrayList<String>();
        if (file.getAbsolutePath().contains(".zip")) {
            String path = file.getAbsolutePath();
            int index = path.indexOf(".zip");
            String zipPath = path.substring(0, index + 4);
            try {
                ZipFile zip = new ZipFile(zipPath);
                Enumeration<? extends ZipEntry> enu = zip.entries();
                while (enu.hasMoreElements()) {
                    String string;
                    File fileInZip;
                    ZipEntry ze = enu.nextElement();
                    if (ze.isDirectory() || !(fileInZip = new File(zipPath, ze.getName())).getName().equals(file.getName())) continue;
                    InputStream is = zip.getInputStream(ze);
                    BufferedInputStream bis = new BufferedInputStream(is);
                    BufferedReader br = new BufferedReader(new InputStreamReader(bis));
                    while ((string = br.readLine()) != null) {
                        strings.add(string);
                    }
                    br.close();
                    break;
                }
                zip.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                String string;
                InputStreamReader isr = encoding.isEmpty() ? new InputStreamReader(new FileInputStream(file)) : new InputStreamReader((InputStream)new FileInputStream(file), encoding);
                BufferedReader br = new BufferedReader(isr);
                while ((string = br.readLine()) != null) {
                    strings.add(string);
                }
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return strings;
    }

    public static boolean writeToText(File file, String ... texts) {
        try {
            PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
            for (String s : texts) {
                pw.println(s);
            }
            pw.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

