/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.io;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.ngt.ngtlib.io.FileMatcher;
import jp.ngt.ngtlib.io.NGTFileLoader;

public class ScanResult {
    private final Map<String, MatchResult> result = new HashMap<String, MatchResult>();

    private MatchResult getMatchResult(String key) {
        if (!this.result.containsKey(key)) {
            this.result.put(key, new MatchResult());
        }
        return this.result.get(key);
    }

    public List<File> asList() {
        ArrayList<File> list = new ArrayList<File>();
        for (MatchResult mr : this.result.values()) {
            list.addAll(mr.asList());
        }
        return list;
    }

    public void add(String key1, FileMatcher key2, File file) {
        this.getMatchResult(key1).add(key2, file);
    }

    public static class MatchResult {
        private final Map<FileMatcher, List<File>> result = new HashMap<FileMatcher, List<File>>();

        private List<File> getList(FileMatcher key) {
            if (!this.result.containsKey(key)) {
                this.result.put(key, new ArrayList());
            }
            return this.result.get(key);
        }

        public List<File> asList() {
            ArrayList<File> list = new ArrayList<File>();
            for (List<File> files : this.result.values()) {
                list.addAll(files);
            }
            return list;
        }

        public void add(FileMatcher key, File file) {
            this.getList(key).add(file);
            NGTFileLoader.log("[NGTFL] Add file : %s (%d)", file.getName(), this.getList(key).size());
        }
    }
}

