/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.math;

import jp.ngt.ngtlib.math.ILine;
import jp.ngt.ngtlib.math.NGTMath;

public final class BezierCurve2
implements ILine {
    private static final int CV = 10000;
    private static final double CV_R = 1.0E-4;
    public final double[] sp;
    public final float[] cpS;
    public final float[] cpE;
    public final float[] ep;
    private byte nbit = (byte)15;
    private byte n3bit = (byte)(this.nbit * 3);
    private long N = 1L << this.nbit;
    private long[] cpSI;
    private long[] cpEI;
    private long[] epI;
    private long[] nb0 = new long[2];
    private long[] nb1 = new long[2];
    private long[] nb2 = new long[2];

    public BezierCurve2(double p1, double p2, double p3, double p4, double p5, double p6, double p7, double p8) {
        this.sp = new double[]{p1, p2};
        this.cpS = new float[]{(float)(p3 - p1), (float)(p4 - p2)};
        this.cpE = new float[]{(float)(p5 - p1), (float)(p6 - p2)};
        this.ep = new float[]{(float)(p7 - p1), (float)(p8 - p2)};
        double d = 10000.0;
        this.cpSI = new long[]{(long)((double)this.cpS[0] * d), (long)((double)this.cpS[1] * d)};
        this.cpEI = new long[]{(long)((double)this.cpE[0] * d), (long)((double)this.cpE[1] * d)};
        this.epI = new long[]{(long)((double)this.ep[0] * d), (long)((double)this.ep[1] * d)};
    }

    @Override
    public double[] getPoint(int par1, int par2) {
        this.nb0[0] = this.epI[0] + (3L * this.N - 3L) * this.cpEI[0] + (3L * this.N * this.N - 6L * this.N + 3L) * this.cpSI[0];
        this.nb0[1] = this.epI[1] + (3L * this.N - 3L) * this.cpEI[1] + (3L * this.N * this.N - 6L * this.N + 3L) * this.cpSI[1];
        this.nb1[0] = 6L * this.epI[0] + (6L * this.N - 18L) * this.cpEI[0] + (18L - 12L * this.N) * this.cpEI[0];
        this.nb1[1] = 6L * this.epI[1] + (6L * this.N - 18L) * this.cpEI[1] + (18L - 12L * this.N) * this.cpEI[1];
        this.nb2[0] = 6L * this.epI[0] - 18L * this.cpEI[0] + 18L * this.cpSI[0];
        this.nb2[1] = 6L * this.epI[1] - 18L * this.cpEI[1] + 18L * this.cpSI[1];
        return null;
    }

    private int[] getPointFromParameter(int par1, int par2) {
        int t = par2 < 0 ? 0 : (par2 > par1 ? par1 : par2);
        int tp = par1 - par2;
        int i0 = t * t * t;
        int i1 = 3 * t * t * tp;
        int i2 = 3 * t * tp * tp;
        int x = 0;
        int y = 0;
        return new int[]{x, y};
    }

    @Override
    public int getNearlestPoint(int par1, double par2, double par3) {
        return 0;
    }

    @Override
    public double getSlope(int par1, int par2) {
        return 0.0;
    }

    @Override
    public double getLength() {
        return 0.0;
    }

    private void setSpliteValue(int par1) {
        double d0 = par1;
        this.cpSI[0] = NGTMath.floor((double)this.cpS[0] * d0);
        this.cpSI[1] = NGTMath.floor((double)this.cpS[1] * d0);
        this.cpEI[0] = NGTMath.floor((double)this.cpE[0] * d0);
        this.cpEI[1] = NGTMath.floor((double)this.cpE[1] * d0);
        this.epI[0] = NGTMath.floor((double)this.ep[0] * d0);
        this.epI[1] = NGTMath.floor((double)this.ep[1] * d0);
    }
}

