/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.math;

import jp.ngt.ngtlib.math.NGTMath;
import net.minecraft.util.math.MathHelper;

public class Vec3 {
    public static final Vec3 ZERO = new Vec3(0.0, 0.0, 0.0);
    private double x;
    private double y;
    private double z;

    public Vec3(double x, double y, double z) {
        this.set(x, y, z);
    }

    protected void set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double length() {
        if (this.getX() != 0.0 || this.getY() != 0.0 || this.getZ() != 0.0) {
            return Math.sqrt(this.getX() * this.getX() + this.getY() * this.getY() + this.getZ() * this.getZ());
        }
        return 0.0;
    }

    public double lengthSq(double px, double py, double pz) {
        double dx = px - this.getX();
        double dy = py - this.getY();
        double dz = pz - this.getZ();
        return dx * dx + dy * dy + dz * dz;
    }

    public Vec3 rotateAroundX(float par1) {
        float rad = NGTMath.toRadians(par1);
        float cos = MathHelper.func_76134_b((float)rad);
        float sin = MathHelper.func_76126_a((float)rad);
        double d0 = this.x;
        double d1 = this.y * (double)cos + this.z * (double)sin;
        double d2 = this.z * (double)cos - this.y * (double)sin;
        return new Vec3(d0, d1, d2);
    }

    public Vec3 rotateAroundY(float par1) {
        float rad = NGTMath.toRadians(par1);
        float cos = MathHelper.func_76134_b((float)rad);
        float sin = MathHelper.func_76126_a((float)rad);
        double d0 = this.x * (double)cos + this.z * (double)sin;
        double d1 = this.y;
        double d2 = this.z * (double)cos - this.x * (double)sin;
        return new Vec3(d0, d1, d2);
    }

    public Vec3 rotateAroundZ(float par1) {
        float rad = NGTMath.toRadians(par1);
        float cos = MathHelper.func_76134_b((float)rad);
        float sin = MathHelper.func_76126_a((float)rad);
        double d0 = this.x * (double)cos + this.y * (double)sin;
        double d1 = this.y * (double)cos - this.x * (double)sin;
        double d2 = this.z;
        return new Vec3(d0, d1, d2);
    }

    public Vec3 rotateAroundVec(Vec3 axis, float rotation) {
        float rad = NGTMath.toRadians(rotation);
        float sin = MathHelper.func_76126_a((float)rad);
        float cos = MathHelper.func_76134_b((float)rad);
        float ncos = 1.0f - cos;
        double x0 = this.x * ((double)cos + axis.x * axis.x * (double)ncos) + this.y * (axis.x * axis.y * (double)ncos - axis.z * (double)sin) + this.z * (axis.z * axis.x * (double)ncos + axis.y * (double)sin);
        double y0 = this.x * (axis.x * axis.y * (double)ncos + axis.z * (double)sin) + this.y * ((double)cos + axis.y * axis.y * (double)ncos) + this.z * (axis.y * axis.z * (double)ncos - axis.x * (double)sin);
        double z0 = this.x * (axis.z * axis.x * (double)ncos - axis.y * (double)sin) + this.y * (axis.y * axis.z * (double)ncos + axis.x * (double)sin) + this.z * ((double)cos + axis.z * axis.z * (double)ncos);
        return new Vec3(x0, y0, z0);
    }

    public Vec3 add(double x, double y, double z) {
        return new Vec3(this.getX() + x, this.getY() + y, this.getZ() + z);
    }

    public Vec3 add(Vec3 vec) {
        return this.add(vec.getX(), vec.getY(), vec.getZ());
    }

    public Vec3 sub(Vec3 vec) {
        return this.add(-vec.getX(), -vec.getY(), -vec.getZ());
    }

    public Vec3 multi(double num) {
        return new Vec3(this.getX() * num, this.getY() * num, this.getZ() * num);
    }

    public Vec3 crossProduct(Vec3 par1) {
        return new Vec3(this.y * par1.z - this.z * par1.y, this.z * par1.x - this.x * par1.z, this.x * par1.y - this.y * par1.x);
    }

    public double dotProduct(Vec3 vec) {
        return this.x * vec.x + this.y * vec.y + this.z * vec.z;
    }

    public Vec3 normalize() {
        double len = this.length();
        if (len > 0.0) {
            double d1 = 1.0 / len;
            return new Vec3(this.x * d1, this.y * d1, this.z * d1);
        }
        return ZERO;
    }

    public float getYaw() {
        return (float)NGTMath.toDegrees(Math.atan2(this.x, this.z));
    }

    public float getPitch() {
        double xz = Math.sqrt(this.x * this.x + this.z * this.z);
        return (float)NGTMath.toDegrees(Math.atan2(this.y, xz));
    }

    public boolean equals(Object obj) {
        if (obj instanceof Vec3) {
            Vec3 vec = (Vec3)obj;
            return vec.getX() == this.getX() && vec.getY() == this.getY() && vec.getZ() == this.getZ();
        }
        return false;
    }

    public double getAngle(Vec3 vec) {
        return Math.acos(this.getAngleCos(vec));
    }

    public double getAngleCos(Vec3 vec) {
        double len2 = this.length() * vec.length();
        if (len2 > 0.0) {
            double d0 = this.dotProduct(vec) / len2;
            return d0 > 1.0 ? 1.0 : d0;
        }
        return 1.0;
    }

    public float getAngle360(Vec3 vec, Vec3 normal) {
        double angle = NGTMath.toDegrees(this.getAngle(vec));
        Vec3 cross = this.crossProduct(vec);
        double dot = cross.dotProduct(normal);
        return NGTMath.wrapAngle((float)angle) * (dot >= 0.0 ? 1.0f : -1.0f);
    }
}

