/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.network;

import io.netty.buffer.ByteBuf;
import jp.ngt.ngtlib.block.BlockUtil;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class PacketCustom
implements IMessage {
    private NBTTagCompound targetData;

    public PacketCustom() {
    }

    public PacketCustom(Entity entity) {
        this.targetData = new NBTTagCompound();
        this.targetData.func_74768_a("EntityId", entity.func_145782_y());
    }

    public PacketCustom(TileEntity tileEntity) {
        this.targetData = new NBTTagCompound();
        BlockPos pos = tileEntity.func_174877_v();
        if (pos.func_177956_o() <= 0) {
            throw new IllegalArgumentException("TileEntity's position is invalid");
        }
        this.targetData.func_74768_a("PosX", pos.func_177958_n());
        this.targetData.func_74768_a("PosY", pos.func_177956_o());
        this.targetData.func_74768_a("PosZ", pos.func_177952_p());
    }

    public void toBytes(ByteBuf buffer) {
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.targetData);
    }

    public void fromBytes(ByteBuf buffer) {
        this.targetData = ByteBufUtils.readTag((ByteBuf)buffer);
    }

    public Entity getEntity(World world) {
        int id = this.targetData.func_74762_e("EntityId");
        Entity entity = world.func_73045_a(id);
        return entity;
    }

    public TileEntity getTileEntity(World world) {
        int x = this.targetData.func_74762_e("PosX");
        int y = this.targetData.func_74762_e("PosY");
        int z = this.targetData.func_74762_e("PosZ");
        TileEntity entity = BlockUtil.getTileEntity((IBlockAccess)world, x, y, z);
        return entity;
    }

    public boolean forEntity() {
        return this.targetData.func_74764_b("EntityId");
    }
}

