/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.protection;

import java.util.Map;
import java.util.UUID;
import jp.ngt.ngtlib.NGTCore;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.network.PacketProtection;
import jp.ngt.ngtlib.protection.Lockable;
import jp.ngt.ngtlib.protection.ProtectionData;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ProtectionManager {
    public static final ProtectionManager INSTANCE = new ProtectionManager();
    public static final String DATA_NAME = "ProtectedObjects";
    public static final String KEY_ID = "ID";
    public static final String KEY_UNBREAKABLE = "Unbreakable";
    public static final String KEY_UNEDITABLE = "Uneditable";
    private ProtectionData lockObjs;

    private ProtectionManager() {
    }

    public ProtectionData getLockObj() {
        if (this.lockObjs == null) {
            this.lockObjs = new ProtectionData(DATA_NAME);
        }
        return this.lockObjs;
    }

    public boolean leftClickBlock(EntityPlayer player, int x, int y, int z) {
        Object target = this.getTarget(player.field_70170_p, x, y, z);
        return this.getLockState(player, target, KEY_UNBREAKABLE);
    }

    public boolean rightClickBlock(EntityPlayer player, int x, int y, int z) {
        Object target = this.getTarget(player.field_70170_p, x, y, z);
        return this.rightClickObject(player, target);
    }

    public boolean leftClickEntity(EntityPlayer player, Entity entity) {
        Object target = this.getTarget(entity);
        return this.getLockState(player, target, KEY_UNBREAKABLE);
    }

    public boolean rightClickEntity(EntityPlayer player, Entity entity) {
        Object target = this.getTarget(entity);
        return this.rightClickObject(player, target);
    }

    public boolean rightClickObject(EntityPlayer player, Object target) {
        NBTTagCompound nbt = this.getKeyNBT(player);
        if (nbt != null) {
            return this.useKey(player, nbt, target);
        }
        return this.getLockState(player, target, KEY_UNEDITABLE);
    }

    private boolean useKey(EntityPlayer player, NBTTagCompound keyNBT, Object target) {
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        String name = this.getObjectName(target);
        String id2 = keyNBT.func_74779_i(KEY_ID);
        if (this.getLockObj().hasObject(name)) {
            NBTTagCompound nbt = this.getLockObj().getObject(name);
            String id1 = nbt.func_74779_i(KEY_ID);
            if (id1.equals(id2)) {
                boolean flag;
                boolean bl = flag = target instanceof Lockable ? ((Lockable)target).unlock(player, id2) : true;
                if (flag) {
                    this.unlockObject(player, name);
                    return true;
                }
            } else {
                NGTLog.sendChatMessage((ICommandSender)player, "Invalid key.", new Object[0]);
            }
        } else {
            Lockable lockable;
            int lockType = 0;
            lockType = target instanceof Lockable ? ((lockable = (Lockable)target).lock(player, id2) ? lockable.getProhibitedAction() : 0) : 3;
            if (lockType > 0) {
                this.lockObject(player, name, id2, lockType);
                return true;
            }
            NGTLog.sendChatMessage((ICommandSender)player, "Unable to lock this object.", new Object[0]);
        }
        return false;
    }

    private boolean getLockState(EntityPlayer player, Object target, String state) {
        NBTTagCompound nbt;
        String name = this.getObjectName(target);
        if (this.getLockObj().hasObject(name) && (nbt = this.getLockObj().getObject(name)).func_74767_n(state)) {
            NGTLog.sendChatMessage((ICommandSender)player, "This object is locked. -> %s", name);
            return true;
        }
        return false;
    }

    private Object getTarget(World world, int x, int y, int z) {
        Object target;
        Block block = BlockUtil.getBlock((IBlockAccess)world, x, y, z);
        TileEntity tileEntity = BlockUtil.getTileEntity((IBlockAccess)world, x, y, z);
        Object object = target = tileEntity != null ? tileEntity : block;
        if (target instanceof Lockable) {
            target = ((Lockable)target).getTarget(world, x, y, z);
        }
        if (target instanceof Block) {
            target = new int[]{x, y, z};
        }
        return target;
    }

    private Object getTarget(Entity entity) {
        Object target = entity;
        if (entity instanceof Lockable) {
            target = ((Lockable)entity).getTarget(entity.field_70170_p, 0, -1, 0);
        }
        return target;
    }

    private String getObjectName(Object object) {
        if (object instanceof int[]) {
            int[] pos = (int[])object;
            return String.format("Block:%d,%d,%d", pos[0], pos[1], pos[2]);
        }
        if (object instanceof TileEntity) {
            TileEntity tileEntity = (TileEntity)object;
            return String.format("TileEntity:%s", tileEntity.func_174877_v().toString());
        }
        if (object instanceof Entity) {
            Entity entity = (Entity)object;
            UUID uuid = entity.func_110124_au();
            return String.format("Entity:%s", uuid.toString());
        }
        return null;
    }

    private NBTTagCompound getKeyNBT(EntityPlayer player) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (stack != null && stack.func_77973_b() == NGTCore.protection_key && stack.func_77942_o()) {
            return stack.func_77978_p();
        }
        return null;
    }

    private void lockObject(EntityPlayer player, String name, String id, int lockType) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a(KEY_ID, id);
        nbt.func_74757_a(KEY_UNBREAKABLE, (lockType & 1) != 0);
        nbt.func_74757_a(KEY_UNEDITABLE, (lockType & 2) != 0);
        this.getLockObj().setObject(name, nbt);
        NGTCore.NETWORK_WRAPPER.sendToAll((IMessage)new PacketProtection(name, nbt));
        NGTLog.sendChatMessage((ICommandSender)player, "Object locked. -> %s", name);
    }

    private void unlockObject(EntityPlayer player, String name) {
        this.getLockObj().removeObject(name);
        NGTCore.NETWORK_WRAPPER.sendToAll((IMessage)new PacketProtection(name, new NBTTagCompound()));
        NGTLog.sendChatMessage((ICommandSender)player, "Object unlocked. -> %s", name);
    }

    public void loadData(World world) {
        if (world instanceof WorldServer && world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD) {
            this.lockObjs = (ProtectionData)world.func_72943_a(ProtectionData.class, DATA_NAME);
            if (this.lockObjs == null) {
                this.lockObjs = new ProtectionData(DATA_NAME);
                world.func_72823_a(DATA_NAME, (WorldSavedData)this.lockObjs);
            }
        }
    }

    public void sendDataToClient() {
        Map<String, NBTTagCompound> map = this.getLockObj().getDatas();
        for (Map.Entry<String, NBTTagCompound> entry : map.entrySet()) {
            NGTCore.NETWORK_WRAPPER.sendToAll((IMessage)new PacketProtection(entry.getKey(), entry.getValue()));
        }
    }

    public void receivePacket(String name, NBTTagCompound data) {
        if (data.func_74764_b(KEY_ID)) {
            this.getLockObj().setObject(name, data);
        } else {
            this.getLockObj().removeObject(name);
        }
    }
}

