/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.renderer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.renderer.DisplayList;
import jp.ngt.ngtlib.renderer.GLObject;
import jp.ngt.ngtlib.renderer.VBO;
import jp.ngt.ngtlib.renderer.VertexArray2;
import jp.ngt.ngtlib.util.Locker;
import jp.ngt.ngtlib.util.NGTUtilClient;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.Util;
import org.lwjgl.util.glu.Project;

@SideOnly(value=Side.CLIENT)
public final class GLHelper {
    public static final GLHelper INSTANCE = new GLHelper();
    public static final Locker LOCKER = new Locker();
    private List<GLObject> activeGLLists = new ArrayList<GLObject>();
    private List<GLObject> deleteGLLists = new ArrayList<GLObject>();
    static int nextVBOId = 1;
    private static final IntBuffer VIEWPORT_BUF = GLAllocation.func_74527_f((int)16);
    private static final IntBuffer SELECT_BUF = GLAllocation.func_74527_f((int)1024);
    private static double DEPTH_RANGE;

    private GLHelper() {
    }

    public static void checkGLError(String par1) {
        GLHelper.checkGLError(par1, false);
    }

    public static void checkGLError(String par1, boolean par2) {
        int i = GL11.glGetError();
        if (i != 0) {
            if (par2) {
                return;
            }
            NGTLog.debug("GL_ERROR@" + par1);
            NGTLog.debug(i + ": " + Util.translateGLErrorString((int)i));
        }
    }

    public static void initGLList() {
        LOCKER.lock();
        if (!GLHelper.INSTANCE.activeGLLists.isEmpty()) {
            for (GLObject dl : GLHelper.INSTANCE.activeGLLists) {
                if (!GL11.glIsList((int)dl.value)) continue;
                dl.setDelFlag(true);
            }
            GLHelper.INSTANCE.activeGLLists.clear();
        }
        LOCKER.unlock();
    }

    public static void deleteGLList(GLObject par1) {
        LOCKER.lock();
        if (par1 != null) {
            GLHelper.INSTANCE.activeGLLists.remove(par1);
            GLHelper.INSTANCE.deleteGLLists.add(par1);
            par1.setDelFlag(true);
        }
        LOCKER.unlock();
    }

    public static DisplayList generateGLList(@Nullable GLObject par1) {
        LOCKER.lock();
        int value = 0;
        value = par1 != null && par1.value > 0 && GL11.glIsList((int)par1.value) ? par1.value : GL11.glGenLists((int)1);
        DisplayList list = new DisplayList(value);
        GLHelper.INSTANCE.activeGLLists.add(list);
        LOCKER.unlock();
        return list;
    }

    @Deprecated
    public static GLObject generateVAO(int size) {
        LOCKER.lock();
        GLObject list = new GLObject(GL30.glGenVertexArrays());
        GLHelper.INSTANCE.activeGLLists.add(list);
        LOCKER.unlock();
        return list;
    }

    public static VBO generateVBO(int size) {
        LOCKER.lock();
        VBO obj = new VBO(++nextVBOId, size);
        GLHelper.INSTANCE.activeGLLists.add(obj);
        LOCKER.unlock();
        return obj;
    }

    public static VertexArray2 generateVA() {
        LOCKER.lock();
        VertexArray2 obj = new VertexArray2(++nextVBOId);
        GLHelper.INSTANCE.activeGLLists.add(obj);
        LOCKER.unlock();
        return obj;
    }

    public static boolean isValid(GLObject par1) {
        if (par1 != null) {
            if (par1.delFlag) {
                return false;
            }
            if (par1.value > 0) {
                return true;
            }
        }
        return false;
    }

    public static void startCompile(GLObject par1) {
        LOCKER.lock();
        GL11.glNewList((int)par1.value, (int)4864);
    }

    public static void endCompile() {
        GL11.glEndList();
        LOCKER.unlock();
    }

    public static void callList(GLObject par1) {
        GL11.glCallList((int)par1.value);
    }

    public static void setColor(int rgb, int alpha) {
        float r = (float)(rgb >> 16) / 255.0f;
        float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(rgb & 0xFF) / 255.0f;
        float a = (float)alpha / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
    }

    public static void setBrightness(int par1) {
        int x = par1 & 0xFFFF;
        int y = par1 >> 16;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)x, (float)y);
    }

    public static void setLightmapMaxBrightness() {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
    }

    public static void enableLighting() {
        GL11.glEnable((int)2896);
    }

    public static void disableLighting() {
        GL11.glDisable((int)2896);
    }

    public static int getBlockTextureWidth() {
        IBlockState state = Blocks.field_150348_b.func_176223_P();
        TextureAtlasSprite icon = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
        int maxSize = NGTMath.floor(1.0f / (icon.func_94212_f() - icon.func_94209_e())) * icon.func_94211_a();
        return maxSize;
    }

    public static int getBlockTextureHeight() {
        IBlockState state = Blocks.field_150348_b.func_176223_P();
        TextureAtlasSprite icon = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
        int maxSize = NGTMath.floor(1.0f / (icon.func_94210_h() - icon.func_94206_g())) * icon.func_94216_b();
        return maxSize;
    }

    public static IntBuffer getBlockTexture(int width, int height) {
        int pixelCount = width * height;
        ByteBuffer byteBuf = ByteBuffer.allocateDirect(pixelCount << 2).order(ByteOrder.nativeOrder());
        IntBuffer buffer = byteBuf.asIntBuffer();
        NGTUtilClient.bindTexture(TextureMap.field_110575_b);
        GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)buffer);
        return buffer;
    }

    public static int getShaderProgram(String vsh, String fsh) {
        int vertShader = GLHelper.createShader(vsh, 35633);
        int fragShader = GLHelper.createShader(fsh, 35632);
        if (vertShader == 0 || fragShader == 0) {
            return -1;
        }
        int program = ARBShaderObjects.glCreateProgramObjectARB();
        if (program == 0) {
            return -1;
        }
        ARBShaderObjects.glAttachObjectARB((int)program, (int)vertShader);
        ARBShaderObjects.glAttachObjectARB((int)program, (int)fragShader);
        ARBShaderObjects.glLinkProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35714) == 0) {
            NGTLog.debug(GLHelper.getShaderErrorLog(program));
            return -1;
        }
        ARBShaderObjects.glValidateProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35715) == 0) {
            NGTLog.debug(GLHelper.getShaderErrorLog(program));
            return -1;
        }
        return program;
    }

    private static int createShader(String shaderObj, int shaderType) {
        int shader = 0;
        try {
            shader = ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            byte[] bytes = shaderObj.getBytes();
            ByteBuffer buffer = GLAllocation.func_74524_c((int)bytes.length);
            buffer.put(bytes);
            buffer.flip();
            ARBShaderObjects.glShaderSourceARB((int)shader, (ByteBuffer)buffer);
            ARBShaderObjects.glCompileShaderARB((int)shader);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35713) == 0) {
                throw new RuntimeException(GLHelper.getShaderErrorLog(shader));
            }
            return shader;
        }
        catch (Exception e) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
            throw e;
        }
    }

    private static String getShaderErrorLog(int shader) {
        return ARBShaderObjects.glGetInfoLogARB((int)shader, (int)ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35716));
    }

    public static void startMousePicking(float range) {
        float mouseX = (float)Display.getWidth() / 2.0f;
        float mouseY = (float)Display.getHeight() / 2.0f;
        VIEWPORT_BUF.clear();
        SELECT_BUF.clear();
        GL11.glGetInteger((int)2978, (IntBuffer)VIEWPORT_BUF);
        GL11.glSelectBuffer((IntBuffer)SELECT_BUF);
        GL11.glRenderMode((int)7170);
        GL11.glInitNames();
        GL11.glPushName((int)0);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        Project.gluPickMatrix((float)mouseX, (float)((float)VIEWPORT_BUF.get(3) - mouseY), (float)range, (float)range, (IntBuffer)VIEWPORT_BUF);
        GL11.glMatrixMode((int)5888);
        DEPTH_RANGE = (double)NGTUtilClient.getMinecraft().field_71474_y.field_151451_c * 16.0 * (double)MathHelper.field_180189_a - 0.05;
    }

    public static int finishMousePicking() {
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        int hits = GL11.glRenderMode((int)7168);
        GL11.glMatrixMode((int)5888);
        return hits;
    }

    public static int getPickedObjId(int count) {
        return SELECT_BUF.get(count * 4 + 3);
    }

    public static double getPickedObjDepth(int count) {
        double depthRaw = Integer.toUnsignedLong(SELECT_BUF.get(count * 4 + 1));
        return depthRaw / 4.294967295E9;
    }

    public static void preMoveTexUV(float u, float v) {
        GL11.glMatrixMode((int)5890);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)u, (float)v, (float)0.0f);
        GL11.glMatrixMode((int)5888);
    }

    public static void postMoveTexUV() {
        GL11.glMatrixMode((int)5890);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
    }
}

