/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.renderer.media;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import jp.ngt.ngtlib.renderer.NGTTessellator;
import jp.ngt.ngtlib.renderer.media.GIF;
import jp.ngt.ngtlib.renderer.media.MediaBase;
import jp.ngt.ngtlib.util.NGTUtilClient;
import net.minecraft.util.ResourceLocation;

public class ElectricBulletinBoard
extends MediaBase {
    private static final ResourceLocation TEXTURE = new ResourceLocation("ngtlib", "textures/ebb/electric_bulletin_board.png");
    private final String name;
    private int offsetU;
    private int offsetV;
    private int resolution;
    private byte[][] colorData;
    private int[] palette;
    private GIF rawData;

    public ElectricBulletinBoard(String par1) {
        this.name = par1;
    }

    public void setParameter(int resolution, int offsetU, int offsetV) {
        this.offsetU = offsetU;
        this.offsetV = offsetV;
        this.resolution = resolution;
    }

    private void loadImage() {
        int i;
        GIF gif = GIF.load(this.name);
        if (gif == null) {
            return;
        }
        this.rawData = gif;
        ArrayList<Integer> list = new ArrayList<Integer>();
        this.colorData = new byte[gif.frameNum][];
        for (i = 0; i < this.colorData.length; ++i) {
            this.colorData[i] = new byte[gif.width * gif.height];
            BufferedImage img = gif.getImage(i);
            for (int w = 0; w < gif.width; ++w) {
                for (int h = 0; h < gif.height; ++h) {
                    int colorIndex;
                    int rawColor = img.getRGB(w, h);
                    int color = rawColor & 0xFFFFFF;
                    if (list.contains(color)) {
                        colorIndex = list.indexOf(color);
                    } else {
                        colorIndex = list.size();
                        list.add(color);
                    }
                    int index = this.getIndex(w, h);
                    this.colorData[i][index] = (byte)((colorIndex & 0xFF) + -128);
                }
            }
        }
        this.palette = new int[list.size()];
        for (i = 0; i < this.palette.length; ++i) {
            this.palette[i] = (Integer)list.get(i);
        }
    }

    private int getIndex(int w, int h) {
        return w + h * this.rawData.width;
    }

    @Override
    public void render(float width, float height, boolean fitAspectRatio) {
        if (this.colorData == null) {
            this.loadImage();
            if (this.colorData == null) {
                return;
            }
        }
        NGTUtilClient.bindTexture(TEXTURE);
        int sizeX = (int)((float)this.resolution * width);
        int sizeY = (int)((float)this.resolution * height);
        float resf = 1.0f / (float)this.resolution;
        float hw = width * 0.5f;
        float hh = height * 0.5f;
        float depth = 0.0f;
        int frameIndex = this.rawData.getCurrentFrameIndex();
        NGTTessellator tessellator = NGTTessellator.instance;
        tessellator.startDrawingQuads();
        for (int u = 0; u < sizeX; ++u) {
            int u2 = (u + this.offsetU) % this.rawData.width;
            float uf = (float)u * resf;
            for (int v = 0; v < sizeY; ++v) {
                int v2 = (v + this.offsetV) % this.rawData.height;
                int pixelIndex = this.getIndex(u2, v2);
                int colorIndex = this.colorData[frameIndex][pixelIndex] - -128;
                int color = this.palette[colorIndex];
                tessellator.setColorRGBA_I(color, 255);
                float vf = (float)v * resf;
                float uOffset = color > 0 ? 0.5f : 0.0f;
                tessellator.addVertexWithUV(-hw + uf, hh - vf, depth, 0.0f + uOffset, 0.0f);
                tessellator.addVertexWithUV(-hw + uf, hh - vf - resf, depth, 0.0f + uOffset, 1.0f);
                tessellator.addVertexWithUV(-hw + uf + resf, hh - vf - resf, depth, 0.5f + uOffset, 1.0f);
                tessellator.addVertexWithUV(-hw + uf + resf, hh - vf, depth, 0.5f + uOffset, 0.0f);
            }
        }
        tessellator.draw();
    }

    @Override
    public void exit() {
    }
}

