/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.renderer.media;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.renderer.media.Camera;
import jp.ngt.ngtlib.renderer.media.ElectricBulletinBoard;
import jp.ngt.ngtlib.renderer.media.MapRenderer;
import jp.ngt.ngtlib.renderer.media.Picture;
import jp.ngt.ngtlib.renderer.media.ScreenCapture;
import jp.ngt.ngtlib.renderer.media.TweetState;
import net.minecraft.client.renderer.GlStateManager;

public abstract class MediaBase {
    private static final Map<MediaType, Map<String, MediaBase>> ALL_MEDIA = new HashMap<MediaType, Map<String, MediaBase>>();

    public abstract void render(float var1, float var2, boolean var3);

    public abstract void exit();

    public void bindTexture(int texture) {
        GlStateManager.func_179144_i((int)texture);
    }

    @Nullable
    public static MediaBase getMedia(MediaType type, String key) {
        Map<String, MediaBase> map;
        if (!ALL_MEDIA.containsKey((Object)type)) {
            ALL_MEDIA.put(type, new HashMap());
            NGTLog.debug("[MediaBase] Add media map : %s", type.toString());
        }
        if (!(map = ALL_MEDIA.get((Object)type)).containsKey(key)) {
            MediaBase media = MediaBase.create(type, key);
            if (media != null) {
                map.put(key, media);
                NGTLog.debug("[MediaBase] Add new media : %s", key);
            }
            return media;
        }
        return map.get(key);
    }

    @Nullable
    private static MediaBase create(MediaType type, String key) {
        switch (type) {
            case CAMERA: {
                return Camera.create(Integer.valueOf(key));
            }
            case CAPTURE: {
                return ScreenCapture.create();
            }
            case PICTURE: {
                return Picture.create(key);
            }
            case TWEET: {
                return new TweetState(key);
            }
            case MAP: {
                return MapRenderer.create(key);
            }
            case EBB: {
                return new ElectricBulletinBoard(key);
            }
        }
        return null;
    }

    public static void clear() {
        for (Map<String, MediaBase> map : ALL_MEDIA.values()) {
            for (MediaBase entry : map.values()) {
                entry.exit();
            }
        }
        NGTLog.debug("[MediaBase] Clear media : %s", ALL_MEDIA.size());
        ALL_MEDIA.clear();
    }

    public static enum MediaType {
        PICTURE,
        CAMERA,
        CAPTURE,
        TWEET,
        MAP,
        EBB;

    }
}

