/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.renderer.media;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.imageio.ImageIO;
import jp.ngt.ngtlib.io.TwitterUtil;
import jp.ngt.ngtlib.renderer.NGTTessellator;
import jp.ngt.ngtlib.renderer.media.MediaBase;
import jp.ngt.ngtlib.util.NGTUtilClient;
import net.minecraft.client.renderer.texture.TextureUtil;
import org.lwjgl.opengl.GL11;
import twitter4j.Status;

public class TweetState
extends MediaBase {
    private static final int UPDATE_FREQ = 2500;
    private final String keyword;
    private Status status;
    private int userIcon = -1;

    public TweetState(String par1) {
        this.keyword = par1;
        this.update();
    }

    public void update() {
        TwitterUtil util = TwitterUtil.getInstance();
        if (util == null) {
            return;
        }
        List<Status> list = util.getTweetWithKeyword(this.keyword, 1);
        if (!list.isEmpty()) {
            Status newStatus = list.get(0);
            if (this.status == null || newStatus.getId() != this.status.getId()) {
                this.status = newStatus;
                this.updateIcon();
            }
        }
    }

    private void updateIcon() {
        if (this.userIcon < 0) {
            this.userIcon = TextureUtil.func_110996_a();
        }
        try {
            URL url = new URL(this.status.getUser().getProfileImageURL());
            BufferedImage image = ImageIO.read(url);
            TextureUtil.func_110987_a((int)this.userIcon, (BufferedImage)image);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isValid() {
        return this.status != null;
    }

    public String getUserName() {
        return this.status.getUser().getName();
    }

    public String getText() {
        return this.status.getText();
    }

    @Override
    public void render(float width, float height, boolean fitAspectRatio) {
        if (!this.isValid()) {
            return;
        }
        if (System.currentTimeMillis() % 2500L == 0L) {
            this.update();
        }
        this.bindTexture(this.userIcon);
        float hw = width * 0.5f;
        float hh = height * 0.5f;
        float depth = 0.0f;
        float iconSize = height * 0.25f;
        float iconTop = height * 0.0625f;
        float w4 = height * 0.25f;
        float strSize = 12.0f;
        NGTTessellator tessellator = NGTTessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(-hw + iconTop, hh - iconTop, depth, 0.0f, 0.0f);
        tessellator.addVertexWithUV(-hw + iconTop, hh - iconTop - iconSize, depth, 0.0f, 1.0f);
        tessellator.addVertexWithUV(-hw + iconTop + iconSize, hh - iconTop - iconSize, depth, 1.0f, 1.0f);
        tessellator.addVertexWithUV(-hw + iconTop + iconSize, hh - iconTop, depth, 1.0f, 0.0f);
        tessellator.draw();
        float scale = 0.015625f;
        GL11.glScalef((float)scale, (float)(-scale), (float)(-scale));
        float posXName = (-hw + iconTop + iconSize + iconTop) / scale;
        float posYName = (-hh + iconTop + iconSize * 0.5f) / scale - strSize * 0.5f;
        float posXText = (-hw + iconTop) / scale;
        float posYText = (-hh + iconTop + iconSize + iconTop) / scale;
        NGTUtilClient.getMinecraft().field_71466_p.func_175065_a(this.getUserName(), posXName, posYName, 0xFFFFFF, false);
        String text = this.getText();
        String[] sa = text.split("\r\n|\n|\r");
        int maxLen = 19;
        for (String s : sa) {
            if ((s = s.replaceAll("\\s", "")).isEmpty()) continue;
            int strIndex = 0;
            while (strIndex < s.length()) {
                int endIndex = strIndex + maxLen;
                if (endIndex > s.length()) {
                    endIndex = s.length();
                }
                String s2 = s.substring(strIndex, endIndex);
                strIndex += maxLen;
                NGTUtilClient.getMinecraft().field_71466_p.func_175065_a(s2, posXText, posYText, 0xFFFFFF, false);
                posYText += strSize;
            }
        }
    }

    @Override
    public void exit() {
    }
}

