/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.renderer.model;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jp.ngt.ngtlib.io.FileType;
import jp.ngt.ngtlib.io.NGTJson;
import jp.ngt.ngtlib.io.NGTText;
import jp.ngt.ngtlib.renderer.model.EncryptedData;
import jp.ngt.ngtlib.renderer.model.ModelFormatException;
import jp.ngt.ngtlib.renderer.model.ModelLoader;
import jp.ngt.ngtlib.renderer.model.PolygonModel;
import jp.ngt.ngtlib.renderer.model.VecAccuracy;

public class EncryptedModel {
    private static final int VERSION = 1;
    private static boolean DEBUG = false;
    private EncryptedData encData;
    private byte[][] md5;
    private byte[][] data;

    public EncryptedModel(File modelFile, File ... jsonFiles) throws IOException {
        this.encData = new EncryptedData();
        this.md5 = this.getMD5s(jsonFiles);
        this.data = this.convertModelData(modelFile);
        this.encData.version = 1;
        this.encData.originalFileName = modelFile.getName();
        this.encData.md5 = this.byteToStr(this.md5);
        this.encData.data = this.byteToStr(this.data);
    }

    public EncryptedModel(EncryptedData par1) throws IOException {
        this.encData = par1;
        this.md5 = this.strToByte(par1.md5);
        this.data = this.strToByte(par1.data);
    }

    public static EncryptedModel getInstance(InputStream is, byte[] jsonMD5) {
        EncryptedModel model;
        try {
            model = new EncryptedModel(EncryptedModel.importData(is));
        }
        catch (Exception e) {
            throw new ModelFormatException("Failed to load NPM", e);
        }
        if (!model.match(jsonMD5)) {
            throw new ModelFormatException("Illegal ModelPack");
        }
        return model;
    }

    private byte[][] convertModelData(File file) throws IOException {
        File[] files;
        byte[][] ba;
        if (FileType.OBJ.match(file.getName())) {
            String mtlFileName = file.getName().replaceAll(".obj", ".mtl");
            File mtlFile = new File(file.getParentFile(), mtlFileName);
            if (mtlFile.exists()) {
                ba = new byte[2][];
                files = new File[]{file, mtlFile};
            } else {
                ba = new byte[1][];
                files = new File[]{file};
            }
        } else {
            ba = new byte[1][];
            files = new File[]{file};
        }
        for (int i = 0; i < ba.length; ++i) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileInputStream fis = new FileInputStream(files[i]);
            byte[] b = new byte[1];
            while (fis.read(b) > 0) {
                baos.write(b);
            }
            fis.close();
            baos.close();
            ba[i] = baos.toByteArray();
        }
        return ba;
    }

    public void exportData(File file) throws IOException {
        NGTJson.writeToJson(NGTJson.getJsonFromObject(this.encData), file);
    }

    public static EncryptedData importData(InputStream is) throws IOException {
        String string;
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((string = br.readLine()) != null) {
            sb.append(string);
        }
        br.close();
        String json = sb.toString();
        EncryptedData res = NGTJson.getObjectFromJson(json, EncryptedData.class);
        return res;
    }

    public PolygonModel getModel(String name, VecAccuracy par1, Object ... args) {
        InputStream[] isa = new InputStream[this.data.length];
        for (int i = 0; i < isa.length; ++i) {
            isa[i] = new ByteArrayInputStream(this.data[i]);
        }
        PolygonModel model = ModelLoader.loadModel(isa, this.encData.originalFileName, par1, args);
        for (int i = 0; i < isa.length; ++i) {
            try {
                isa[i].close();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return model;
    }

    private byte[][] getMD5s(File ... files) {
        byte[][] md5 = new byte[files.length][];
        for (int i = 0; i < md5.length; ++i) {
            try {
                String s = EncryptedModel.formatJson(NGTText.readText(files[i], false, ""));
                md5[i] = EncryptedModel.getMD5(s);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return md5;
    }

    public static String formatJson(String s) {
        s = s.replaceAll("\n", "");
        s = s.replaceAll("\r", "");
        s = s.replaceAll(" ", "");
        s = s.replaceAll("\t", "");
        return s;
    }

    public static byte[] getMD5(String s) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(s.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean match(byte[] ba) {
        for (int i = 0; i < this.md5.length; ++i) {
            if (!MessageDigest.isEqual(ba, this.md5[i])) continue;
            return true;
        }
        return DEBUG;
    }

    private String[] byteToStr(byte[][] arrays) throws IOException {
        String[] sa = new String[arrays.length];
        for (int i = 0; i < arrays.length; ++i) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(baos);
            gos.write(arrays[i]);
            gos.close();
            baos.close();
            byte[] ret = baos.toByteArray();
            sa[i] = Base64.getEncoder().encodeToString(ret);
        }
        return sa;
    }

    private byte[][] strToByte(String[] sa) throws IOException {
        byte[][] ba = new byte[sa.length][];
        for (int i = 0; i < sa.length; ++i) {
            int len;
            byte[] decData = Base64.getDecoder().decode(sa[i]);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ByteArrayInputStream bais = new ByteArrayInputStream(decData);
            GZIPInputStream gis = new GZIPInputStream(bais);
            byte[] buffer = new byte[1024];
            while ((len = gis.read(buffer)) > 0) {
                baos.write(buffer, 0, len);
            }
            gis.close();
            bais.close();
            baos.close();
            byte[] ret = baos.toByteArray();
            ba[i] = ret;
        }
        return ba;
    }
}

