/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.renderer.model;

import java.util.List;
import java.util.Map;
import jp.ngt.ngtlib.math.PooledVec3;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.ngtlib.renderer.IRenderer;
import jp.ngt.ngtlib.renderer.NGTRenderHelper;
import jp.ngt.ngtlib.renderer.model.TextureCoordinate;
import jp.ngt.ngtlib.renderer.model.VecAccuracy;
import jp.ngt.ngtlib.renderer.model.Vertex;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Face {
    private static float[][] MIRROR_PATTERN = new float[][]{{-1.0f, 1.0f, 1.0f}, {1.0f, -1.0f, 1.0f}, {1.0f, 1.0f, -1.0f}};
    public final byte materialId;
    public final Vertex[] vertices;
    public final TextureCoordinate[] textureCoordinates;
    public Vertex faceNormal;
    public Vertex[] vertexNormals;

    public Face(int size, int material) {
        this.vertices = new Vertex[size];
        this.textureCoordinates = new TextureCoordinate[size];
        this.materialId = (byte)material;
    }

    public void addVertex(int index, Vertex v, TextureCoordinate t) {
        this.vertices[index] = v;
        this.textureCoordinates[index] = t;
    }

    public void calculateFaceNormal(VecAccuracy accuracy) {
        Vec3 vec = this.calcCrossProduct().normalize();
        this.faceNormal = Vertex.create(vec, accuracy);
    }

    public void calcVertexNormals(Map<Vertex, List<Face>> map, float angleCos, VecAccuracy accuracy) {
        this.vertexNormals = new Vertex[this.vertices.length];
        for (int i = 0; i < this.vertexNormals.length; ++i) {
            if (i > 2) {
                int i0 = i % 3;
                if (i0 == 0) {
                    this.vertexNormals[i] = this.vertexNormals[0];
                    continue;
                }
                if (i0 == 1) {
                    this.vertexNormals[i] = this.vertexNormals[i - 2];
                    continue;
                }
            }
            Vec3 vec = this.faceNormal.toVec();
            Vertex vtx = this.vertices[i];
            List<Face> list = map.get(vtx);
            for (Face face : list) {
                Vec3 v2;
                Vec3 v1;
                double d0;
                if (face == this || !((d0 = (v1 = this.faceNormal.toVec()).getAngleCos(v2 = face.faceNormal.toVec())) >= (double)angleCos)) continue;
                double angle = v1.getAngle(v2);
                vec = vec.add(face.faceNormal.toVec());
            }
            vec = vec.normalize();
            this.vertexNormals[i] = Vertex.create(vec, accuracy);
        }
    }

    private Vec3 calcCrossProduct() {
        Vec3 vec = Vec3.ZERO;
        for (int i = 0; i < this.vertices.length / 3; ++i) {
            int idx = i * 3;
            Vec3 v1 = PooledVec3.create(this.vertices[idx + 1].getX() - this.vertices[idx].getX(), this.vertices[idx + 1].getY() - this.vertices[idx].getY(), this.vertices[idx + 1].getZ() - this.vertices[idx].getZ());
            Vec3 v2 = PooledVec3.create(this.vertices[idx + 2].getX() - this.vertices[idx].getX(), this.vertices[idx + 2].getY() - this.vertices[idx].getY(), this.vertices[idx + 2].getZ() - this.vertices[idx].getZ());
            vec = vec.add(v1.crossProduct(v2).normalize());
        }
        return vec;
    }

    public void addFaceForRender(IRenderer tessellator, boolean smoothing) {
        NGTRenderHelper.addFace(this, tessellator, smoothing);
    }

    public Face getMirror(int type, Map<Vertex, Vertex> mirrorVertex, VecAccuracy accuracy) {
        int size = this.vertices.length;
        Face face = new Face(size, this.materialId);
        for (int i = 0; i < size; ++i) {
            Vertex vtx2;
            int index;
            Vertex vtx = this.vertices[i];
            int n = index = i > 0 ? size - i : 0;
            if (mirrorVertex.containsKey(vtx)) {
                vtx2 = mirrorVertex.get(vtx);
            } else {
                float x = vtx.getX() * MIRROR_PATTERN[type][0];
                float y = vtx.getY() * MIRROR_PATTERN[type][1];
                float z = vtx.getZ() * MIRROR_PATTERN[type][2];
                boolean flag = type == 0 && x == 0.0f || type == 1 && y == 0.0f || type == 2 && z == 0.0f;
                vtx2 = flag ? vtx : Vertex.create(x, y, z, accuracy);
                mirrorVertex.put(vtx, vtx2);
            }
            face.addVertex(index, vtx2, this.textureCoordinates[i]);
        }
        return face;
    }

    public Face copy() {
        Face face = new Face(this.vertices.length, this.materialId);
        for (int i = 0; i < this.vertices.length; ++i) {
            face.addVertex(i, this.vertices[i].copy(VecAccuracy.MEDIUM), this.textureCoordinates[i].copy());
        }
        return face;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Face) {
            Face face = (Face)object;
            if (this.vertices.length != face.vertices.length) {
                return false;
            }
            for (int i = 0; i < this.vertices.length; ++i) {
                if (this.vertices[i].equals(face.vertices[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

