/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.renderer.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.renderer.IRenderer;
import jp.ngt.ngtlib.renderer.NGTTessellator;
import jp.ngt.ngtlib.renderer.model.Face;
import jp.ngt.ngtlib.renderer.model.VecAccuracy;
import jp.ngt.ngtlib.renderer.model.Vertex;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class GroupObject {
    public String name;
    public byte drawMode;
    public float smoothingAngle;
    public ArrayList<Face> faces = new ArrayList(16);

    public GroupObject(String par1, int par2) {
        this.name = par1;
        this.drawMode = (byte)par2;
    }

    public void calcVertexNormals(VecAccuracy accuracy) {
        HashMap<Vertex, List<Face>> faceMap = new HashMap<Vertex, List<Face>>(this.faces.size() * 4);
        for (Face face : this.faces) {
            if (face.faceNormal == null) {
                face.calculateFaceNormal(accuracy);
            }
            for (int i = 0; i < face.vertices.length; ++i) {
                if (i != 0 && i != 1 && i % 3 != 2) continue;
                Vertex vtx = face.vertices[i];
                ArrayList<Face> list = (ArrayList<Face>)faceMap.get(vtx);
                if (list == null) {
                    list = new ArrayList<Face>();
                    faceMap.put(vtx, list);
                }
                if (list.contains(face)) continue;
                list.add(face);
            }
        }
        float angleCos = NGTMath.cos(this.smoothingAngle);
        for (Face face : this.faces) {
            face.calcVertexNormals(faceMap, angleCos, accuracy);
        }
    }

    public void render(boolean smoothing) {
        if (!this.faces.isEmpty()) {
            NGTTessellator tessellator = NGTTessellator.instance;
            tessellator.startDrawing(this.drawMode);
            this.render(tessellator, smoothing);
            tessellator.draw();
        }
    }

    public void render(IRenderer tessellator, boolean smoothing) {
        if (!this.faces.isEmpty()) {
            for (Face face : this.faces) {
                face.addFaceForRender(tessellator, smoothing);
            }
        }
    }

    public GroupObject copy(String name) {
        GroupObject go = new GroupObject(name, this.drawMode);
        for (Face origFace : this.faces) {
            Face face = origFace.copy();
            go.faces.add(face);
        }
        return go;
    }

    protected final class FaceSet {
        public final Face face;
        public final int index;

        public FaceSet(Face p1, int p2) {
            this.face = p1;
            this.index = p2;
        }
    }
}

