/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.renderer.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import jp.ngt.ngtlib.renderer.model.Material;
import jp.ngt.ngtlib.renderer.model.ModelFormatException;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MtlParser {
    private Map<String, Material> materials = new HashMap<String, Material>();
    private Material currentMaterial;

    public MtlParser(InputStream is) {
        this.loadMaterial(is);
    }

    private void loadMaterial(InputStream inputStream) throws ModelFormatException {
        if (inputStream == null) {
            return;
        }
        BufferedReader reader = null;
        String currentLine = null;
        int lineCount = 0;
        this.materials.clear();
        try {
            reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((currentLine = reader.readLine()) != null) {
                ++lineCount;
                if ((currentLine = currentLine.replaceAll("\\s+", " ").trim()).length() == 0 || currentLine.startsWith("#") || !currentLine.startsWith("newmtl ")) continue;
                String[] sa = currentLine.split(" ");
                this.currentMaterial = new Material((byte)this.materials.size(), null);
                this.materials.put(sa[1], this.currentMaterial);
            }
        }
        catch (IOException e) {
            throw new ModelFormatException("IO Exception reading model format", e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public Map<String, Material> getMaterials() {
        return this.materials;
    }
}

