/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.renderer.model;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import jp.ngt.ngtlib.block.BlockSet;
import jp.ngt.ngtlib.block.NGTObject;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.io.NGTText;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.math.PooledVec3;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.ngtlib.renderer.model.DummyVertexBuffer;
import jp.ngt.ngtlib.renderer.model.Face;
import jp.ngt.ngtlib.renderer.model.FaceWithIndex;
import jp.ngt.ngtlib.renderer.model.GroupObject;
import jp.ngt.ngtlib.renderer.model.ModelLoader;
import jp.ngt.ngtlib.renderer.model.PolygonModel;
import jp.ngt.ngtlib.renderer.model.TextureCoordinate;
import jp.ngt.ngtlib.renderer.model.VecAccuracy;
import jp.ngt.ngtlib.renderer.model.Vertex;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.ngtlib.world.NGTWorld;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class VoxelUtil {
    private static final String DEFAULT_MATERIAL = "mat1";

    public static void exportToPolygon(NGTObject ngto, File file) {
        String mtlName = file.getName().replace("obj", "mtl");
        String texName = file.getName().replace("obj", "png");
        String obj = VoxelUtil.getObjAsText(VoxelUtil.getVertexes(ngto), mtlName);
        NGTText.writeToText(file, obj);
        String mtl = VoxelUtil.getMtlAsText(texName);
        NGTText.writeToText(new File(file.getParentFile(), mtlName), mtl);
        try {
            VoxelUtil.saveBlockTexture(new File(file.getParentFile(), texName));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static NGTObject importFromPolygon(File file, float scale) {
        PolygonModel model = ModelLoader.loadModel(file, VecAccuracy.MEDIUM, new Object[0]);
        return VoxelUtil.toVoxel(model, scale);
    }

    private static String getObjAsText(DummyVertexBuffer buffer, String mtlFile) {
        List<FaceWithIndex> faces = buffer.getFaces();
        ArrayList<Vertex> vertexes = new ArrayList<Vertex>();
        ArrayList<TextureCoordinate> texCoordinates = new ArrayList<TextureCoordinate>();
        for (FaceWithIndex face : faces) {
            for (int i = 0; i < face.vertices.length; ++i) {
                Vertex vtx = face.vertices[i];
                int index = vertexes.indexOf(vtx);
                if (index < 0) {
                    index = vertexes.size();
                    vertexes.add(vtx);
                }
                face.vtxIndexes[i] = index + 1;
                TextureCoordinate texCo = face.textureCoordinates[i];
                index = texCoordinates.indexOf(texCo);
                if (index < 0) {
                    index = texCoordinates.size();
                    texCoordinates.add(texCo);
                }
                face.uvIndexes[i] = index + 1;
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("#NGTLib v2.4.21 Obj File\n");
        sb.append("mtllib " + mtlFile + "\n");
        sb.append("o default\n");
        sb.append("usemtl mat1\n");
        for (Vertex vtx : vertexes) {
            sb.append("v ");
            sb.append(vtx.getX());
            sb.append(" ");
            sb.append(vtx.getY());
            sb.append(" ");
            sb.append(vtx.getZ());
            sb.append("\n");
        }
        for (TextureCoordinate tex : texCoordinates) {
            sb.append("vt ");
            sb.append(tex.getU());
            sb.append(" ");
            sb.append(tex.getV());
            sb.append("\n");
        }
        for (FaceWithIndex face : faces) {
            sb.append("f");
            for (int i = 0; i < face.vertices.length; ++i) {
                sb.append(" ");
                sb.append(face.vtxIndexes[i]);
                sb.append("/");
                sb.append(face.uvIndexes[i]);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Deprecated
    private static List<FaceWithIndex> quadToTriangle(List<FaceWithIndex> quadFaces) {
        ArrayList<FaceWithIndex> faces = new ArrayList<FaceWithIndex>();
        for (Face face : quadFaces) {
            FaceWithIndex face1 = new FaceWithIndex(3, 0);
            face1.vertices[0] = face.vertices[0];
            face1.vertices[1] = face.vertices[1];
            face1.vertices[2] = face.vertices[2];
            face1.textureCoordinates[0] = face.textureCoordinates[0];
            face1.textureCoordinates[1] = face.textureCoordinates[1];
            face1.textureCoordinates[2] = face.textureCoordinates[2];
            faces.add(face1);
            FaceWithIndex face2 = new FaceWithIndex(3, 0);
            face2.vertices[0] = face.vertices[2];
            face2.vertices[1] = face.vertices[3];
            face2.vertices[2] = face.vertices[0];
            face2.textureCoordinates[0] = face.textureCoordinates[2];
            face2.textureCoordinates[1] = face.textureCoordinates[3];
            face2.textureCoordinates[2] = face.textureCoordinates[0];
            faces.add(face2);
        }
        return faces;
    }

    private static DummyVertexBuffer getVertexes(NGTObject ngto) {
        NGTWorld world = new NGTWorld(NGTUtil.getClientWorld(), ngto);
        int bufSize = ngto.blockList.size() * 0x280000 >> 12;
        if (bufSize <= 0) {
            bufSize = 4096;
        }
        DummyVertexBuffer renderer = new DummyVertexBuffer(bufSize);
        renderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        for (int i = 0; i < ngto.xSize; ++i) {
            for (int j = 0; j < ngto.ySize; ++j) {
                for (int k = 0; k < ngto.zSize; ++k) {
                    BlockSet set = ngto.getBlockSet(i, j, k);
                    if (set.toBlockState().func_185904_a() == Material.field_151579_a) continue;
                    BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
                    IBlockState state = set.block.func_176203_a((int)set.metadata);
                    dispatcher.func_175018_a(state, new BlockPos(i, j, k), (IBlockAccess)world, (BufferBuilder)renderer);
                }
            }
        }
        renderer.func_178977_d();
        return renderer;
    }

    private static String getMtlAsText(String texFile) {
        StringBuilder sb = new StringBuilder();
        sb.append("#NGTLib v2.4.21 Mtl File\n");
        sb.append("newmtl mat1\n");
        sb.append("Ns 7.843137\n");
        sb.append("Ka 0.000000 0.000000 0.000000\n");
        sb.append("Kd 0.800000 0.800000 0.800000\n");
        sb.append("Ks 0.000000 0.000000 0.000000\n");
        sb.append("Ni 1.000000\n");
        sb.append("d 0.000000\n");
        sb.append("illum 2\n");
        sb.append("map_Kd " + texFile + "\n");
        sb.append("map_d " + texFile + "\n");
        return sb.toString();
    }

    private static void saveBlockTexture(File file) throws IOException {
        int w = GLHelper.getBlockTextureWidth();
        int h = GLHelper.getBlockTextureHeight();
        IntBuffer buffer = GLHelper.getBlockTexture(w, h);
        BufferedImage image = new BufferedImage(w, h, 2);
        for (int i = 0; i < buffer.capacity(); ++i) {
            int color = buffer.get(i);
            image.getRaster().getDataBuffer().setElem(i, color);
        }
        ImageIO.write((RenderedImage)image, "png", file);
        NGTLog.debug("Save texture : " + file.getAbsolutePath());
    }

    public static NGTObject toVoxel(PolygonModel model, float scale) {
        int maxFace = 0;
        int faceCount = 0;
        float minZ = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float minX = Float.MAX_VALUE;
        float maxZ = Float.MIN_VALUE;
        float maxY = Float.MIN_VALUE;
        float maxX = Float.MIN_VALUE;
        for (GroupObject go : model.groupObjects) {
            for (Face face : go.faces) {
                ++maxFace;
                for (Vertex vtx : face.vertices) {
                    if (minX > vtx.getX()) {
                        minX = vtx.getX();
                    }
                    if (maxX < vtx.getX()) {
                        maxX = vtx.getX();
                    }
                    if (minY > vtx.getY()) {
                        minY = vtx.getY();
                    }
                    if (maxY < vtx.getY()) {
                        maxY = vtx.getY();
                    }
                    if (minZ > vtx.getZ()) {
                        minZ = vtx.getZ();
                    }
                    if (!(maxZ < vtx.getZ())) continue;
                    maxZ = vtx.getZ();
                }
            }
        }
        int xSize = NGTMath.floor((maxX - minX) / scale);
        int ySize = NGTMath.floor((maxY - minY) / scale);
        int zSize = NGTMath.floor((maxZ - minZ) / scale);
        int[][][] posArray = new int[xSize][ySize][zSize];
        for (GroupObject go : model.groupObjects) {
            for (Face face : go.faces) {
                VoxelUtil.genVoxel(face, 1.0 / (double)scale, -minX, -minY, -minZ, posArray);
                if (++faceCount % 1000 != 0) continue;
                NGTLog.debug("Convert Face to Voxel " + faceCount + "/" + maxFace);
            }
        }
        ArrayList<BlockSet> list = new ArrayList<BlockSet>();
        int size = xSize * ySize * zSize;
        for (int i = 0; i < size; ++i) {
            list.add(BlockSet.AIR);
        }
        NGTObject ngto = NGTObject.createNGTO(list, xSize, ySize, zSize, 0, 0, 0);
        for (int i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                for (int k = 0; k < zSize; ++k) {
                    if (posArray[i][j][k] <= 0) continue;
                    ngto.setBlockSet(i, j, k, Blocks.field_150348_b, 0);
                }
            }
        }
        return ngto;
    }

    private static void genVoxel(Face face, double scale, float offsetX, float offsetY, float offsetZ, int[][][] posArray) {
        int vtxCount = face.vertices.length / 3;
        for (int i = 0; i < vtxCount; ++i) {
            VoxelUtil.genVoxel(face.vertices[i * 3], face.vertices[i * 3 + 1], face.vertices[i * 3 + 2], scale, offsetX, offsetY, offsetZ, posArray);
        }
    }

    private static void genVoxel(Vertex vtx1, Vertex vtx2, Vertex vtx3, double scale, float offsetX, float offsetY, float offsetZ, int[][][] posArray) {
        double lenBC;
        double x = (double)vtx1.getX() * scale;
        double y = (double)vtx1.getY() * scale;
        double z = (double)vtx1.getZ() * scale;
        Vec3 vecA = PooledVec3.create(x, y, z);
        x = (double)(vtx2.getX() - vtx1.getX()) * scale;
        y = (double)(vtx2.getY() - vtx1.getY()) * scale;
        z = (double)(vtx2.getZ() - vtx1.getZ()) * scale;
        Vec3 vecAB = PooledVec3.create(x, y, z);
        x = (double)(vtx3.getX() - vtx2.getX()) * scale;
        y = (double)(vtx3.getY() - vtx2.getY()) * scale;
        z = (double)(vtx3.getZ() - vtx2.getZ()) * scale;
        Vec3 vecBC = PooledVec3.create(x, y, z);
        double lenAB = vecAB.length();
        int lenI = NGTMath.floor((lenAB > (lenBC = vecBC.length()) ? lenAB : lenBC) * 2.0);
        for (int i = 0; i < lenI; ++i) {
            double di = (double)i / (double)lenI;
            for (int j = 0; j < i; ++j) {
                double dj = (double)j / (double)lenI;
                int ix = NGTMath.floor(vecA.getX() + vecAB.getX() * di + vecBC.getX() * dj + (double)offsetX * scale);
                int iy = NGTMath.floor(vecA.getY() + vecAB.getY() * di + vecBC.getY() * dj + (double)offsetY * scale);
                int iz = NGTMath.floor(vecA.getZ() + vecAB.getZ() * di + vecBC.getZ() * dj + (double)offsetZ * scale);
                if (ix <= 0 || ix >= posArray.length || iy <= 0 || iy >= posArray[0].length || iz <= 0 || iz >= posArray[0][0].length) continue;
                posArray[ix][iy][iz] = 1;
            }
        }
    }
}

