/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.sound;

import jp.ngt.ngtlib.io.ResourceLocationCustom;
import jp.ngt.ngtlib.sound.SoundEventAccessorCustom;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MovingSoundCustom
extends MovingSound {
    private final String soundName;
    private float prevVolume = -1.0f;
    private float prevPitch = -1.0f;
    private boolean isMCSound;
    private SoundEventAccessor seAccessor;

    public MovingSoundCustom(String sound, boolean repeat) {
        super(MovingSoundCustom.getSoundEvent(sound), SoundCategory.MASTER);
        this.soundName = sound;
        this.field_147659_g = repeat;
        this.field_147665_h = 0;
        this.field_147666_i = ISound.AttenuationType.LINEAR;
        this.isMCSound = this.checkMCSound(sound);
    }

    private boolean checkMCSound(String sound) {
        return SoundEvent.field_187505_a.func_148741_d((Object)new ResourceLocation(sound));
    }

    public void func_73660_a() {
        if (this.prevVolume >= 0.0f) {
            this.field_147662_b = this.prevVolume;
            this.prevVolume = -1.0f;
        }
        if (this.prevPitch >= 0.0f) {
            this.field_147663_c = this.prevPitch;
            this.prevPitch = -1.0f;
        }
    }

    public void stop() {
        this.field_147668_j = true;
    }

    public void setVolume(float par1) {
        this.prevVolume = par1 < 0.0f ? 0.0f : par1;
    }

    public void setPitch(float par1) {
        this.prevPitch = par1 < 0.0f ? 0.0f : par1;
    }

    public SoundEventAccessor func_184366_a(SoundHandler handler) {
        if (this.isMCSound) {
            return super.func_184366_a(handler);
        }
        this.seAccessor = super.func_184366_a(handler);
        if (this.seAccessor == null) {
            this.seAccessor = new SoundEventAccessorCustom(new ResourceLocationCustom(this.soundName));
        }
        this.field_184367_a = this.seAccessor.func_148720_g();
        return this.seAccessor;
    }

    private static SoundEvent getSoundEvent(String sound) {
        SoundEvent se = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("minecraft", sound));
        if (se == null) {
            return new SoundEventDummy(sound);
        }
        return se;
    }

    private static class SoundEventDummy
    extends SoundEvent {
        public SoundEventDummy(String sound) {
            this(new ResourceLocationCustom(sound));
        }

        private SoundEventDummy(ResourceLocation soundNameIn) {
            super(soundNameIn);
        }
    }
}

