/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.util;

public final class ColorUtil {
    public static int getR(int color) {
        return color >> 16 & 0xFF;
    }

    public static int getG(int color) {
        return color >> 8 & 0xFF;
    }

    public static int getB(int color) {
        return color & 0xFF;
    }

    public static int encode(int r, int g, int b) {
        return r << 16 | g << 8 | b;
    }

    public static String toString(int color) {
        String s = Integer.toHexString(color);
        if (color <= 255) {
            s = "0000" + s;
        } else if (color <= 65535) {
            s = "00" + s;
        }
        return s;
    }

    public static int toInteger(String color) {
        if (!color.startsWith("0x")) {
            color = "0x" + color;
        }
        return Integer.decode(color);
    }

    public static int multiplicating(int src, int dst) {
        int r = ColorUtil.multiplicating2(ColorUtil.getR(src), ColorUtil.getR(dst));
        int g = ColorUtil.multiplicating2(ColorUtil.getG(src), ColorUtil.getG(dst));
        int b = ColorUtil.multiplicating2(ColorUtil.getB(src), ColorUtil.getB(dst));
        return ColorUtil.encode(r, g, b);
    }

    private static int multiplicating2(int src, int dst) {
        return src * dst / 255;
    }

    public static int add(int src, int dst) {
        int r = ColorUtil.add2(ColorUtil.getR(src), ColorUtil.getR(dst));
        int g = ColorUtil.add2(ColorUtil.getG(src), ColorUtil.getG(dst));
        int b = ColorUtil.add2(ColorUtil.getB(src), ColorUtil.getB(dst));
        return ColorUtil.encode(r, g, b);
    }

    private static int add2(int src, int dst) {
        return src + dst & 0xFF;
    }

    public static int[] alphaBlending(int srcColor, int srcAlpha, int dstColor, int dstAlpha) {
        if (srcAlpha == 255 || dstAlpha == 0) {
            return new int[]{srcColor, srcAlpha};
        }
        if (srcAlpha == 0) {
            return new int[]{dstColor, dstAlpha};
        }
        int dtms = dstAlpha * (255 - srcAlpha);
        int alpha = ColorUtil.correct(srcAlpha + dtms / 255);
        int srcR = ColorUtil.getR(srcColor);
        int srcG = ColorUtil.getG(srcColor);
        int srcB = ColorUtil.getB(srcColor);
        int dstR = ColorUtil.getR(dstColor);
        int dstG = ColorUtil.getG(dstColor);
        int dstB = ColorUtil.getB(dstColor);
        int r = ColorUtil.correct((srcR * srcAlpha + dstR * dtms / 255) / alpha);
        int g = ColorUtil.correct((srcG * srcAlpha + dstG * dtms / 255) / alpha);
        int b = ColorUtil.correct((srcB * srcAlpha + dstB * dtms / 255) / alpha);
        return new int[]{ColorUtil.encode(r, g, b), alpha};
    }

    private static int correct(int p) {
        return p > 255 ? 255 : p;
    }
}

