/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.util;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.ngt.ngtlib.io.NGTText;

public class Config {
    private Map<String, Map<String, String>> itemMap = new HashMap<String, Map<String, String>>();

    public void load(File file) throws IOException {
        List<String> list = NGTText.readText(file, "");
        if (!list.isEmpty()) {
            String category = "";
            for (String s : list) {
                String[] sa1;
                if (s.startsWith("#")) continue;
                if (s.startsWith("@")) {
                    category = s.substring(1);
                    continue;
                }
                if (!s.contains("=") || (sa1 = s.split("=")).length != 2 || category.length() <= 0) continue;
                this.setProperty(category, sa1[0], sa1[1]);
            }
        }
    }

    public boolean save(File file) {
        StringBuilder sb = new StringBuilder("#NGT_Configuration_File").append("\n");
        for (Map.Entry<String, Map<String, String>> set0 : this.itemMap.entrySet()) {
            String category = set0.getKey();
            Map<String, String> value0 = set0.getValue();
            sb.append("\n").append("@").append(category).append("\n");
            for (Map.Entry<String, String> set1 : value0.entrySet()) {
                String key = set1.getKey();
                String value1 = set1.getValue();
                sb.append(key).append("=").append(value1).append("\n");
            }
        }
        return NGTText.writeToText(file, sb.toString());
    }

    public String getProperty(String category, String key) {
        Map<String, String> map;
        if (this.itemMap.containsKey(category) && (map = this.itemMap.get(category)).containsKey(key)) {
            return map.get(key);
        }
        return "";
    }

    public void setProperty(String category, String key, String value) {
        Map<String, String> map = null;
        map = this.itemMap.containsKey(category) ? this.itemMap.get(category) : new HashMap<String, String>();
        map.put(key, value);
        this.itemMap.put(category, map);
    }

    public boolean containsKey(String category, String key) {
        if (this.itemMap.containsKey(category)) {
            Map<String, String> map = this.itemMap.get(category);
            return map.containsKey(key);
        }
        return false;
    }
}

