/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.ngt.ngtlib.NGTCore;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.io.NGTText;
import jp.ngt.ngtlib.util.NGTUtil;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public final class PermissionManager {
    public static final PermissionManager INSTANCE = new PermissionManager();
    private static boolean DEBUG_MODE = false;
    private static String ALL = "-all";
    private final File saveDir;
    private final File saveFile;
    private final Map<String, List<String>> permissionMap = new HashMap<String, List<String>>();

    private PermissionManager() {
        String path = NGTCore.proxy.getMinecraftDirectory("ngt").getAbsolutePath();
        if (path.contains(".") && !path.contains(".minecraft")) {
            path = path.replace("\\.", "");
        }
        this.saveDir = new File(path);
        this.saveFile = new File(this.saveDir, "permission.txt");
    }

    public void save() {
        String[] sa = new String[this.permissionMap.size()];
        int i = 0;
        for (Map.Entry<String, List<String>> entry : this.permissionMap.entrySet()) {
            StringBuilder sb = new StringBuilder();
            sb.append(entry.getKey()).append(":");
            for (String s : entry.getValue()) {
                sb.append(s).append(",");
            }
            sa[i] = sb.toString();
            ++i;
        }
        NGTText.writeToText(this.saveFile, sa);
    }

    public void load() throws IOException {
        this.initFile();
        List<String> slist = NGTText.readText(this.saveFile, "");
        for (String s : slist) {
            String[] sa3;
            String[] sa2 = s.split(":");
            if (sa2.length != 2) continue;
            List<String> list = this.getPlayerList(sa2[0]);
            for (String s2 : sa3 = sa2[1].split(",")) {
                list.add(s2);
            }
        }
    }

    private void initFile() {
        if (!this.saveDir.exists()) {
            this.saveDir.mkdirs();
        }
        if (!this.saveFile.exists()) {
            try {
                this.saveFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public List<String> getPlayerList(String par1) {
        if (!this.permissionMap.containsKey(par1)) {
            this.permissionMap.put(par1, new ArrayList());
        }
        return this.permissionMap.get(par1);
    }

    public void showPermissionList(ICommandSender player) {
        for (Map.Entry<String, List<String>> entry : this.permissionMap.entrySet()) {
            StringBuilder sb = new StringBuilder();
            sb.append(entry.getKey()).append(":");
            for (String s : entry.getValue()) {
                sb.append(s).append(",");
            }
            NGTLog.sendChatMessage(player, sb.toString(), new Object[0]);
        }
    }

    public void addPermission(ICommandSender player, String targetPlayerName, String category) {
        if (this.isOp(player)) {
            this.getPlayerList(category).add(targetPlayerName);
            NGTLog.sendChatMessageToAll("Add permission (%s) to %s.", category, targetPlayerName);
            this.save();
        } else {
            NGTLog.sendChatMessage(player, "Only operator can use this command.", new Object[0]);
        }
    }

    public void removePermission(ICommandSender player, String targetPlayerName, String category) {
        if (this.isOp(player)) {
            this.getPlayerList(category).remove(targetPlayerName);
            NGTLog.sendChatMessageToAll("Remove permission (%s) from %s.", category, targetPlayerName);
            this.save();
        } else {
            NGTLog.sendChatMessage(player, "Only operator can use this command.", new Object[0]);
        }
    }

    public boolean hasPermission(ICommandSender player, String category) {
        if (this.isOp(player)) {
            return true;
        }
        List<String> list = this.getPlayerList(category);
        if (list.contains(player.func_70005_c_()) || list.contains(ALL)) {
            return true;
        }
        NGTLog.sendChatMessageToAll("%s need permission (%s).", player.func_70005_c_(), category);
        return false;
    }

    public boolean isOp(ICommandSender player) {
        if (!DEBUG_MODE && !NGTUtil.isSMP()) {
            return true;
        }
        if (player instanceof EntityPlayerMP) {
            String[] names;
            for (String name : names = ((EntityPlayerMP)player).field_71133_b.func_184103_al().func_152606_n()) {
                if (!player.func_70005_c_().equals(name)) continue;
                return true;
            }
        } else if (player instanceof MinecraftServer) {
            return true;
        }
        return false;
    }
}

