/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.util.NGTUtil;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public final class Usage {
    public static final Usage INSTANCE = new Usage();
    private final Map<UsageKey, UsageEntry> usages = new HashMap<UsageKey, UsageEntry>();

    private Usage() {
    }

    public void requestUsage(EntityPlayer player) {
        for (Map.Entry<UsageKey, UsageEntry> entry : this.usages.entrySet()) {
            if (!entry.getValue().pattern.match(player)) continue;
            entry.getValue().sendMessage(player);
            return;
        }
        NGTLog.sendChatMessage((ICommandSender)player, "usage.none", new Object[0]);
    }

    public void addTooltip(Object par1, int par2, List<String> tooltip) {
        UsageEntry entry = this.getEntry(par1, par2);
        if (entry != null) {
            for (String s : entry.messages) {
                tooltip.add(TextFormatting.YELLOW + NGTUtil.translate(s));
            }
        }
    }

    private UsageEntry getEntry(Object par1, int par2) {
        UsageKey key = new UsageKey(par1, par2);
        return this.usages.get(key);
    }

    public UsageEntry add(final Block block, final int meta, String ... par2) {
        UsageEntry entry = new UsageEntry(new UsagePattern(){

            @Override
            public boolean match(EntityPlayer player) {
                Item item = Item.func_150898_a((Block)block);
                ItemStack stack = player.func_184614_ca();
                return stack != null && stack.func_77973_b() == item && (meta < 0 || meta == stack.func_77952_i());
            }
        }, par2);
        this.usages.put(new UsageKey(block, meta), entry);
        return entry;
    }

    public UsageEntry add(final Item item, final int meta, String ... par2) {
        UsageEntry entry = new UsageEntry(new UsagePattern(){

            @Override
            public boolean match(EntityPlayer player) {
                ItemStack stack = player.func_184614_ca();
                return stack != null && stack.func_77973_b() == item && (meta < 0 || meta == stack.func_77952_i());
            }
        }, par2);
        this.usages.put(new UsageKey(item, meta), entry);
        return entry;
    }

    public UsageEntry add(final Class<? extends Entity> clazz, String ... par2) {
        UsageEntry entry = new UsageEntry(new UsagePattern(){

            @Override
            public boolean match(EntityPlayer player) {
                Entity entity = player.func_184187_bx();
                return entity != null && Usage.isInstance(entity.getClass(), clazz);
            }
        }, par2);
        this.usages.put(new UsageKey(clazz, 0), entry);
        return entry;
    }

    private static boolean isInstance(Class<?> target, Class<?> clazz) {
        if (target == clazz) {
            return true;
        }
        if (target.getSuperclass() != null) {
            return Usage.isInstance(target.getSuperclass(), clazz);
        }
        return false;
    }

    public static class UsageKey {
        public final Object key1;
        public final int key2;

        public UsageKey(Object par1, int par2) {
            this.key1 = par1;
            this.key2 = par2;
        }

        public int hashCode() {
            return this.key1.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof UsageKey) {
                UsageKey key = (UsageKey)obj;
                return key.key1 == this.key1 && (this.key2 < 0 || key.key2 < 0 || key.key2 == this.key2);
            }
            return false;
        }
    }

    public static interface UsagePattern {
        public boolean match(EntityPlayer var1);
    }

    public static class UsageEntry {
        public final UsagePattern pattern;
        public final String[] messages;

        public UsageEntry(UsagePattern par1, String ... par2) {
            this.pattern = par1;
            this.messages = par2;
        }

        public void sendMessage(EntityPlayer player) {
            for (String s : this.messages) {
                NGTLog.sendChatMessage((ICommandSender)player, s, new Object[0]);
            }
        }
    }
}

