/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.world;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.ngt.ngtlib.block.BlockSet;
import jp.ngt.ngtlib.block.NGTObject;
import jp.ngt.ngtlib.block.TileEntityCustom;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.ngtlib.world.IBlockAccessNGT;
import jp.ngt.ngtlib.world.SaveHandlerDummy;
import jp.ngt.ngtlib.world.WorldProviderDummy;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.VillageCollection;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class NGTWorld
extends World
implements IBlockAccessNGT {
    public final World world;
    public final NGTObject blockObject;
    public final int posX;
    public final int posY;
    public final int posZ;
    private List<TileEntity> renderTileEntities = new ArrayList<TileEntity>();
    private Map<Integer, Entity> entityIdMap = new HashMap<Integer, Entity>();
    public boolean tileEntityLoaded;
    protected Map<BlockPos, TileEntity> worldTileEntities = new HashMap<BlockPos, TileEntity>();
    private int nextEntityId;

    public NGTWorld(World par1, NGTObject par2) {
        this(par1, par2, 0, -1, 0);
    }

    public NGTWorld(World par1, NGTObject par2, int x2, int y2, int z2) {
        super((ISaveHandler)new SaveHandlerDummy(), new WorldInfo(new WorldSettings(0L, GameType.CREATIVE, false, false, WorldType.field_77138_c), "NGT"), (WorldProvider)new WorldProviderDummy(), new Profiler(), par1 == null ? true : par1.field_72995_K);
        this.field_73011_w.func_76558_a((World)this);
        this.field_72982_D = new VillageCollection((World)this);
        this.world = par1;
        this.blockObject = par2;
        this.posX = x2;
        this.posY = y2;
        this.posZ = z2;
        this.loadTileEntity();
        this.loadEntity();
    }

    private void loadTileEntity() {
        this.tileEntityLoaded = false;
    }

    private void loadEntity() {
        NBTTagList tagList = this.blockObject.getEntityList();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbt = tagList.func_150305_b(i);
            Entity entity2 = this.getEntityFromNBT(nbt);
            if (entity2 == null) continue;
            this.addEntity(entity2);
            Entity entity = entity2;
            NBTTagCompound nbt2 = nbt;
            while (nbt2.func_150297_b("Riding", 10)) {
                Entity entity1 = EntityList.func_75615_a((NBTTagCompound)nbt2.func_74775_l("Riding"), (World)this);
                if (entity1 != null) {
                    this.addEntity(entity1);
                    entity.func_184220_m(entity1);
                }
                entity = entity1;
                nbt2 = nbt2.func_74775_l("Riding");
            }
        }
        for (int pass = 0; pass < 2; ++pass) {
            for (int j = 0; j < this.field_72996_f.size(); ++j) {
                Entity entity = (Entity)this.field_72996_f.get(j);
                double x = entity.field_70165_t;
                double y = entity.field_70163_u - entity.func_70033_W();
                double z = entity.field_70161_v;
                try {
                    entity.func_70071_h_();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                entity.func_70012_b(x, y, z, entity.field_70177_z, entity.field_70125_A);
            }
        }
    }

    private Entity getEntityFromNBT(NBTTagCompound nbt) {
        if ("Player".equals(nbt.func_74779_i("id"))) {
            // empty if block
        }
        return EntityList.func_75615_a((NBTTagCompound)nbt, (World)this);
    }

    private void addEntity(Entity entity) {
        double x = entity.field_70165_t - (double)this.blockObject.origX;
        double y = entity.field_70163_u - (double)this.blockObject.origY - entity.func_70033_W();
        double z = entity.field_70161_v - (double)this.blockObject.origZ;
        entity.func_70012_b(x, y, z, entity.field_70177_z, entity.field_70125_A);
        this.field_72996_f.add(entity);
        entity.func_145769_d(++this.nextEntityId);
        this.entityIdMap.put(entity.func_145782_y(), entity);
    }

    public static NBTTagList writeEntitiesToNBT(List list) {
        NBTTagList tagList = new NBTTagList();
        for (Entity entity : list) {
            NBTTagCompound nbt = new NBTTagCompound();
            try {
                if (!entity.func_70039_c(nbt)) continue;
                tagList.func_74742_a((NBTBase)nbt);
            }
            catch (Exception e) {
                FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"An Entity type %s has thrown an exception trying to write NBT.", (Object[])new Object[]{entity.getClass().getName()});
            }
        }
        return tagList;
    }

    protected IChunkProvider func_72970_h() {
        return null;
    }

    public boolean func_175668_a(BlockPos pos, boolean allowEmpty) {
        return this.blockObject.isValidPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    protected boolean func_175680_a(int x, int z, boolean allowEmpty) {
        return false;
    }

    public Chunk func_72964_e(int x, int z) {
        return null;
    }

    public boolean func_180501_a(BlockPos pos, IBlockState newState, int flags) {
        int meta = newState.func_177230_c().func_176201_c(newState);
        return this.blockObject.setBlockSet(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), newState.func_177230_c(), meta);
    }

    public void markAndNotifyBlock(BlockPos pos, Chunk chunk, IBlockState old, IBlockState new_, int flags) {
    }

    public Entity func_73045_a(int id) {
        return this.entityIdMap.get(id);
    }

    public List<Entity> func_175674_a(Entity entityIn, AxisAlignedBB boundingBox, Predicate<? super Entity> predicate) {
        return new ArrayList<Entity>();
    }

    public boolean func_72838_d(Entity par1) {
        this.field_72996_f.add(par1);
        return true;
    }

    public List<TileEntity> getTileEntityList() {
        return this.renderTileEntities;
    }

    public void setTileEntityList(List<TileEntity> list) {
        this.renderTileEntities.addAll(list);
    }

    public List<Entity> getEntityList() {
        return this.field_72996_f;
    }

    @Override
    public BlockSet getBlockSet(int x, int y, int z) {
        return this.blockObject.getBlockSet(x, y, z);
    }

    public IBlockState func_180495_p(BlockPos pos) {
        BlockSet set = this.getBlockSet(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return set.toBlockState();
    }

    public TileEntity func_175625_s(BlockPos pos) {
        if (this.worldTileEntities.containsKey(pos)) {
            return this.worldTileEntities.get(pos);
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        BlockSet set = this.getBlockSet(x, y, z);
        if (set.block.hasTileEntity(set.block.func_176203_a((int)set.metadata))) {
            TileEntity tile = null;
            try {
                tile = set.block.createTileEntity((World)this, set.toBlockState());
                tile.func_145834_a((World)this);
                if (set.nbt != null) {
                    tile.func_145839_a(set.nbt.func_74737_b());
                }
            }
            catch (Exception e) {
                return null;
            }
            if (tile instanceof TileEntityCustom) {
                ((TileEntityCustom)tile).setPos(x, y, z, x + this.blockObject.origX, y + this.blockObject.origY, z + this.blockObject.origZ);
            } else {
                tile.func_174878_a(pos);
            }
            this.worldTileEntities.put(pos, tile);
            return tile;
        }
        return null;
    }

    public float func_175724_o(BlockPos pos) {
        return this.field_73011_w.func_177497_p()[this.func_175671_l(pos)];
    }

    public int func_175671_l(BlockPos pos) {
        return this.getLightValue(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0, false);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_175705_a(EnumSkyBlock type, BlockPos pos) {
        BlockSet set = this.getBlockSet(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        if (set.block.func_149710_n(set.toBlockState())) {
            int up = this.getLightValue(pos.func_177984_a(), type.field_77198_c, false);
            int east = this.getLightValue(pos.func_177974_f(), type.field_77198_c, false);
            int west = this.getLightValue(pos.func_177976_e(), type.field_77198_c, false);
            int south = this.getLightValue(pos.func_177984_a(), type.field_77198_c, false);
            int north = this.getLightValue(pos.func_177984_a(), type.field_77198_c, false);
            int res = up;
            if (east > up) {
                res = east;
            }
            if (west > res) {
                res = west;
            }
            if (south > res) {
                res = south;
            }
            if (north > res) {
                res = north;
            }
            return res;
        }
        return this.func_175678_i(pos) ? type.field_77198_c : this.getLightValue(pos, type.field_77198_c, false);
    }

    public int func_175642_b(EnumSkyBlock type, BlockPos pos) {
        int z;
        int y;
        int x = pos.func_177958_n();
        if (this.blockObject.isValidPos(x, y = pos.func_177956_o(), z = pos.func_177952_p())) {
            return this.blockObject.getBlockSet((int)x, (int)y, (int)z).block.getLightValue(this.func_180495_p(pos), (IBlockAccess)this, pos);
        }
        return type.field_77198_c;
    }

    private int getLightValue(BlockPos pos, int defaultValue, boolean blend) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        return this.getLightValue(x, y, z, defaultValue, blend);
    }

    private int getLightValue(int x, int y, int z, int defaultValue, boolean blend) {
        int brightness;
        BlockPos pos = new BlockPos(x, y, z);
        int skyLight = this.func_175642_b(EnumSkyBlock.SKY, pos);
        int blockLight = this.func_175642_b(EnumSkyBlock.BLOCK, pos);
        if (blockLight < defaultValue) {
            blockLight = defaultValue;
        }
        if (blockLight < (brightness = NGTUtil.getLightValue(this.world, this.posX, this.posY, this.posZ))) {
            blockLight = brightness;
        }
        if (this.posY < 0) {
            blockLight = 15;
            skyLight = 15;
        }
        return blend ? skyLight << 20 | blockLight << 4 : (skyLight > blockLight ? skyLight : blockLight);
    }

    public boolean func_175678_i(BlockPos pos) {
        for (int y0 = pos.func_177956_o() + 1; y0 < this.blockObject.ySize; ++y0) {
            IBlockState state = this.func_180495_p(new BlockPos(pos.func_177958_n(), y0, pos.func_177952_p()));
            if (state.func_177230_c() == Blocks.field_150350_a) continue;
            return false;
        }
        return true;
    }

    public boolean func_175623_d(BlockPos pos) {
        return this.getBlockSet((int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p()).block == Blocks.field_150350_a;
    }

    public Biome func_180494_b(BlockPos pos) {
        return Biomes.field_76771_b;
    }

    public Biome getBiomeForCoordsBody(BlockPos pos) {
        return this.func_180494_b(pos);
    }

    public int func_72800_K() {
        return 64;
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        int z;
        int y;
        int x = pos.func_177958_n();
        if (this.blockObject.isValidPos(x, y = pos.func_177956_o(), z = pos.func_177952_p())) {
            BlockSet set = this.getBlockSet(x, y, z);
            return set.block.isSideSolid(set.toBlockState(), (IBlockAccess)this, pos, side);
        }
        return _default;
    }

    public boolean func_175664_x(BlockPos pos) {
        return false;
    }

    public void func_175646_b(BlockPos pos, TileEntity tile) {
    }
}

