/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.block;

import java.util.List;
import javax.annotation.Nullable;
import jp.ngt.ngtlib.block.BlockContainerCustomWithMeta;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.rtm.RTMBlock;
import jp.ngt.rtm.RTMSound;
import jp.ngt.rtm.block.BlockScaffold;
import jp.ngt.rtm.block.tileentity.TileEntityScaffold;
import jp.ngt.rtm.block.tileentity.TileEntityScaffoldStairs;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockScaffoldStairs
extends BlockContainerCustomWithMeta {
    public BlockScaffoldStairs(Block par1) {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(RTMSound.SOUND_METAL2);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityScaffoldStairs();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int facing = NGTMath.floor((double)(NGTMath.normalizeAngle((double)((double)placer.field_70177_z + 180.0)) / 90.0 + 0.5)) & 3;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityScaffold) {
            ((TileEntityScaffold)tile).setDir((byte)facing);
        }
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean isActualState) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityScaffold) {
            byte dir = ((TileEntityScaffold)tile).getDir();
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            byte flag0 = BlockScaffoldStairs.getConnectionType((IBlockAccess)world, x + 1, y, z, dir);
            byte flag1 = BlockScaffoldStairs.getConnectionType((IBlockAccess)world, x - 1, y, z, dir);
            byte flag2 = BlockScaffoldStairs.getConnectionType((IBlockAccess)world, x, y, z + 1, dir);
            byte flag3 = BlockScaffoldStairs.getConnectionType((IBlockAccess)world, x, y, z - 1, dir);
            if (dir == 0 || dir == 2) {
                if (flag1 != 3) {
                    this.setAABB(new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 2.0, 1.0));
                    super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entity, isActualState);
                }
                if (flag0 != 3) {
                    this.setAABB(new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 2.0, 1.0));
                    super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entity, isActualState);
                }
                for (int i = 0; i < 4; ++i) {
                    float f0 = (float)i * 0.25f;
                    float f1 = dir == 2 ? f0 : 0.75f - f0;
                    this.setAABB(new AxisAlignedBB(0.0, (double)(0.0f + f0), (double)f1, 1.0, (double)(0.25f + f0), (double)(0.25f + f1)));
                    super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entity, isActualState);
                }
            } else {
                if (flag3 != 3) {
                    this.setAABB(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 2.0, 0.0625));
                    super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entity, isActualState);
                }
                if (flag2 != 3) {
                    this.setAABB(new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 2.0, 1.0));
                    super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entity, isActualState);
                }
                for (int i = 0; i < 4; ++i) {
                    float f0 = (float)i * 0.25f;
                    float f1 = dir == 1 ? f0 : 0.75f - f0;
                    this.setAABB(new AxisAlignedBB((double)f1, (double)(0.0f + f0), 0.0, (double)(0.25f + f1), (double)(0.25f + f0), 1.0));
                    super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entity, isActualState);
                }
            }
            this.setAABB(field_185505_j);
        } else {
            this.setAABB(field_185505_j);
            super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entity, isActualState);
        }
    }

    public static byte getConnectionType(IBlockAccess world, int x, int y, int z, byte dir) {
        IBlockState state = BlockUtil.getBlockState((IBlockAccess)world, (int)x, (int)y, (int)z);
        Block block = state.func_177230_c();
        Block blockD = BlockUtil.getBlock((IBlockAccess)world, (int)x, (int)(y - 1), (int)z);
        Block blockU = BlockUtil.getBlock((IBlockAccess)world, (int)x, (int)(y + 1), (int)z);
        if (block == RTMBlock.scaffold) {
            TileEntity tile = BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
            if (tile instanceof TileEntityScaffold) {
                byte dir2 = ((TileEntityScaffold)tile).getDir();
                boolean b0 = dir2 == 0 || dir2 == 2;
                return (byte)(b0 ? 1 : 2);
            }
            return 0;
        }
        if (block == RTMBlock.scaffoldStairs) {
            TileEntity tile = BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
            if (tile instanceof TileEntityScaffoldStairs && ((TileEntityScaffoldStairs)tile).getDir() == dir) {
                return 3;
            }
            return 0;
        }
        if (blockD == RTMBlock.scaffoldStairs) {
            TileEntity tile = BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)(y - 1), (int)z);
            if (tile instanceof TileEntityScaffoldStairs && ((TileEntityScaffoldStairs)tile).getDir() == dir) {
                return 3;
            }
            return 0;
        }
        if (blockU == RTMBlock.scaffoldStairs) {
            TileEntity tile = BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)(y + 1), (int)z);
            if (tile instanceof TileEntityScaffoldStairs && ((TileEntityScaffoldStairs)tile).getDir() == dir) {
                return 3;
            }
            return 0;
        }
        if (state.func_185914_p()) {
            return 4;
        }
        return 0;
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!world.field_72995_K) {
            BlockScaffoldStairs.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.getItem(state.func_177230_c().func_176201_c(state)));
        }
    }

    protected ItemStack getItem(int damage) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, damage);
    }

    public Boolean isEntityInsideMaterial(IBlockAccess world, BlockPos pos, IBlockState state, Entity entity, double yToTest, Material materialIn, boolean testingHead) {
        return BlockScaffold.getSpeed(world, pos) != 0.0f;
    }

    public Vec3d func_176197_a(World world, BlockPos pos, Entity entity, Vec3d motion) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityScaffoldStairs) {
            Vec3 vec = ((TileEntityScaffoldStairs)tile).getMotionVec();
            BlockScaffold.addVecToEntity(entity, vec);
        }
        return motion;
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityScaffoldStairs) {
            Vec3 vec = ((TileEntityScaffoldStairs)tile).getMotionVec();
            BlockScaffold.addVecToEntity(entity, vec);
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
    }
}

