/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.block;

import java.util.ArrayList;
import java.util.List;
import jp.ngt.ngtlib.block.BlockContainerCustom;
import jp.ngt.ngtlib.block.BlockLiquidBase;
import jp.ngt.ngtlib.block.BlockSet;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.rtm.RTMBlock;
import jp.ngt.rtm.RTMMaterial;
import jp.ngt.rtm.block.BlockPipe;
import jp.ngt.rtm.block.IPipeConnectable;
import jp.ngt.rtm.block.tileentity.TileEntitySlot;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSlot
extends BlockContainerCustom
implements IPipeConnectable {
    public static final PropertyEnum<EnumFacing> FACING = PropertyEnum.func_177709_a((String)"facing", EnumFacing.class);

    public BlockSlot() {
        super(RTMMaterial.fireproof);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(FACING, (Comparable)EnumFacing.UP));
        this.func_149675_a(true);
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public TileEntity func_149915_a(World par1, int par2) {
        return new TileEntitySlot();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)facing.func_176734_d());
    }

    public void inhaleLiquid(World world, int x, int y, int z) {
        int m0 = BlockUtil.getMetadata((IBlockAccess)world, (int)x, (int)y, (int)z);
        int x0 = x + BlockUtil.facing[m0][0];
        int y0 = y + BlockUtil.facing[m0][1];
        int z0 = z + BlockUtil.facing[m0][2];
        Block target = BlockUtil.getBlock((IBlockAccess)world, (int)x0, (int)y0, (int)z0);
        int meta = BlockUtil.getMetadata((IBlockAccess)world, (int)x0, (int)y0, (int)z0);
        if (target instanceof BlockLiquid && this.addLiquid(world, x, y, z, target, meta)) {
            world.func_175698_g(new BlockPos(x0, y0, z0));
        }
    }

    public boolean addLiquid(World world, int x, int y, int z, Block block, int metadata) {
        int z1;
        int y1;
        int m0 = BlockUtil.getMetadata((IBlockAccess)world, (int)x, (int)y, (int)z);
        int x1 = x - BlockUtil.facing[m0][0];
        Block b0 = BlockUtil.getBlock((IBlockAccess)world, (int)x1, (int)(y1 = y - BlockUtil.facing[m0][1]), (int)(z1 = z - BlockUtil.facing[m0][2]));
        if (b0 == RTMBlock.pipe) {
            List<BlockSet> list = ((BlockPipe)RTMBlock.pipe).setLiquid(world, x1, y1, z1, x, y, z, new ArrayList<BlockSet>(), 0);
            while (!list.isEmpty()) {
                BlockSet bs = list.get(world.field_73012_v.nextInt(list.size()));
                if (this.setLiquid(world, bs.x, bs.y, bs.z, block, metadata)) {
                    return true;
                }
                list.remove(bs);
            }
            return false;
        }
        return this.setLiquid(world, x1, y1, z1, block, metadata);
    }

    protected boolean setLiquid(World world, int x, int y, int z, Block block, int metadata) {
        int z0;
        int y0;
        int m0 = BlockUtil.getMetadata((IBlockAccess)world, (int)x, (int)y, (int)z);
        int x0 = x - BlockUtil.facing[m0][0];
        if (BlockUtil.isAir((IBlockAccess)world, (int)x0, (int)(y0 = y - BlockUtil.facing[m0][1]), (int)(z0 = z - BlockUtil.facing[m0][2]))) {
            BlockUtil.setBlock((World)world, (int)x0, (int)y0, (int)z0, (Block)block, (int)metadata, (int)3);
            return true;
        }
        if (block instanceof BlockLiquidBase) {
            for (int y1 = 1; y1 < 16; ++y1) {
                if (BlockUtil.getBlock((IBlockAccess)world, (int)x0, (int)(y0 + y1 - 1), (int)z0) != block || !BlockUtil.isAir((IBlockAccess)world, (int)x0, (int)(y0 + y1), (int)z0)) continue;
                BlockUtil.setBlock((World)world, (int)x0, (int)(y0 + y1), (int)z0, (Block)block, (int)metadata, (int)3);
                return true;
            }
        }
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P();
        switch (meta) {
            case 1: {
                iblockstate = iblockstate.func_177226_a(FACING, (Comparable)EnumFacing.EAST);
                break;
            }
            case 2: {
                iblockstate = iblockstate.func_177226_a(FACING, (Comparable)EnumFacing.WEST);
                break;
            }
            case 3: {
                iblockstate = iblockstate.func_177226_a(FACING, (Comparable)EnumFacing.SOUTH);
                break;
            }
            case 4: {
                iblockstate = iblockstate.func_177226_a(FACING, (Comparable)EnumFacing.NORTH);
                break;
            }
            case 5: {
                iblockstate = iblockstate.func_177226_a(FACING, (Comparable)EnumFacing.DOWN);
                break;
            }
            default: {
                iblockstate = iblockstate.func_177226_a(FACING, (Comparable)EnumFacing.UP);
            }
        }
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public String getHarvestTool(IBlockState state) {
        return "pickaxe";
    }

    public int getHarvestLevel(IBlockState state) {
        return 0;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        IBlockState state = world.func_180495_p(pos);
        for (IProperty prop : state.func_177228_b().keySet()) {
            if (!prop.func_177701_a().equals("facing")) continue;
            world.func_175656_a(pos, state.func_177231_a(prop));
            return true;
        }
        return false;
    }
}

