/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.block.decoration;

public class Face
implements Cloneable {
    public String name;
    public String texture;
    public float shadow;
    public FaceType type;
    public float[][] vertex;

    public Face clone() {
        Face face = new Face();
        face.name = this.name;
        face.texture = this.texture;
        face.shadow = this.shadow;
        face.type = this.type;
        face.vertex = new float[this.vertex.length][];
        for (int i = 0; i < face.vertex.length; ++i) {
            face.vertex[i] = new float[this.vertex[i].length];
            for (int j = 0; j < face.vertex[i].length; ++j) {
                face.vertex[i][j] = this.vertex[i][j];
            }
        }
        return face;
    }

    public void addVec(float[] vec3, boolean lockUV) {
        for (float[] vtx : this.vertex) {
            Face.addVecToVertex(vtx, this.type, vec3, lockUV);
        }
    }

    public static void addVecToVertex(float[] vtx, FaceType faceType, float[] vec3, boolean lockUV) {
        for (int i = 0; i < 3; ++i) {
            int n = i;
            vtx[n] = vtx[n] + vec3[i];
        }
        if (lockUV) {
            float[] uv = faceType.func.vertexToUV(vtx[0], vtx[1], vtx[2]);
            vtx[3] = uv[0];
            vtx[4] = uv[1];
        }
    }

    public static Face getDefaultFace() {
        float minU = 0.0f;
        float maxU = 1.0f;
        float minV = 0.0f;
        float maxV = 1.0f;
        Face top = new Face();
        top.name = "top";
        top.texture = "minecraft:decoration/deco_platform_top";
        top.shadow = 1.0f;
        top.vertex = new float[][]{{0.0f, 1.0f, 1.0f, minU, minV}, {1.0f, 1.0f, 1.0f, minU, maxV}, {1.0f, 1.0f, 0.0f, maxU, maxV}, {0.0f, 1.0f, 0.0f, maxU, minV}};
        return top;
    }

    public static interface UVFunc {
        public float[] vertexToUV(float var1, float var2, float var3);
    }

    public static enum FaceType {
        TOP((x, y, z) -> new float[]{1.0f - z, x}),
        BOTTOM((x, y, z) -> new float[]{z, x}),
        LEFT((x, y, z) -> new float[]{1.0f - z, 1.0f - y}),
        RIGHT((x, y, z) -> new float[]{z, 1.0f - y}),
        FRONT((x, y, z) -> new float[]{x, 1.0f - y}),
        BACK((x, y, z) -> new float[]{1.0f - x, 1.0f - y});

        public final UVFunc func;

        private FaceType(UVFunc par1) {
            this.func = par1;
        }
    }
}

