/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.block.tileentity;

import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.ngtlib.renderer.NGTRenderer;
import jp.ngt.ngtlib.renderer.NGTTessellator;
import jp.ngt.ngtlib.renderer.model.IModelNGT;
import jp.ngt.ngtlib.renderer.model.ModelLoader;
import jp.ngt.ngtlib.renderer.model.VecAccuracy;
import jp.ngt.ngtlib.util.NGTUtilClient;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.block.tileentity.TileEntityEffect;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class RenderEffect
extends TileEntitySpecialRenderer<TileEntityEffect> {
    private static final ResourceLocation tex_N = new ResourceLocation("rtm", "textures/effect/explosion_n.png");
    private static final ResourceLocation tex_S = new ResourceLocation("rtm", "textures/effect/explosion_s.png");
    private static final ResourceLocation tex_R = new ResourceLocation("rtm", "textures/effect/explosion_r.png");
    private IModelNGT model;
    private IModelNGT sphere;
    private IModelNGT ring;
    private boolean finishLoading;
    private static final String[] PARTS_NAME = new String[]{"obj1", "obj2", "obj3", "obj4", "obj5"};

    public RenderEffect() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                RenderEffect.this.model = (IModelNGT)ModelLoader.loadModel((ResourceLocation)new ResourceLocation("rtm", "models/explosion_n.mqo"), (VecAccuracy)VecAccuracy.MEDIUM, (Object[])new Object[0]);
                RenderEffect.this.sphere = (IModelNGT)ModelLoader.loadModel((ResourceLocation)new ResourceLocation("rtm", "models/explosion_s.mqo"), (VecAccuracy)VecAccuracy.MEDIUM, (Object[])new Object[0]);
                RenderEffect.this.ring = (IModelNGT)ModelLoader.loadModel((ResourceLocation)new ResourceLocation("rtm", "models/explosion_r.mqo"), (VecAccuracy)VecAccuracy.MEDIUM, (Object[])new Object[0]);
                RenderEffect.this.finishLoading = true;
            }
        };
        thread.start();
    }

    private void render(TileEntityEffect entity, double x, double y, double z, float partialTick) {
        if (!this.finishLoading) {
            return;
        }
        if (entity.shouldUpdateAsAtomicBomb()) {
            GL11.glPushMatrix();
            GL11.glEnable((int)32826);
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
            this.renderExplosionEffect(entity, x, y, z, partialTick);
            GL11.glPopMatrix();
        } else {
            ItemStack item = NGTUtilClient.getMinecraft().field_71439_g.func_184614_ca();
            if (!item.func_190926_b() && item.func_77973_b().func_77658_a().contains("effect")) {
                GL11.glPushMatrix();
                GL11.glEnable((int)32826);
                GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
                GL11.glDisable((int)3553);
                NGTTessellator tessellator = NGTTessellator.instance;
                tessellator.startDrawingQuads();
                tessellator.setColorRGBA_I(0xFF0000, 255);
                NGTRenderer.renderSphere((NGTTessellator)tessellator, (float)0.25f);
                tessellator.draw();
                GL11.glEnable((int)3553);
                GL11.glPopMatrix();
            }
        }
    }

    private void renderExplosionEffect(TileEntityEffect par1, double par2, double par3, double par4, float par5) {
        if (par1.tickCount < 40) {
            float alpha = 1.0f - (float)par1.tickCount / 40.0f;
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)1, (int)1);
            GL11.glDisable((int)2896);
            GL11.glDepthMask((boolean)true);
            GLHelper.setLightmapMaxBrightness();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            float size = (-0.025f * (float)Math.pow((float)par1.tickCount - 20.0f, 2.0) + 10.0f) * 0.25f * 20.0f;
            GL11.glScalef((float)size, (float)size, (float)size);
            this.func_147499_a(tex_S);
            GL11.glMatrixMode((int)5890);
            GL11.glLoadIdentity();
            float f0 = (float)(par1.tickCount % 100) + par5;
            GL11.glTranslatef((float)0.0f, (float)(-f0 * 0.01f), (float)0.0f);
            GL11.glMatrixMode((int)5888);
            this.sphere.renderAll(RTMCore.smoothing);
            GL11.glMatrixMode((int)5890);
            GL11.glLoadIdentity();
            GL11.glMatrixMode((int)5888);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3008);
            GL11.glDepthMask((boolean)true);
        } else {
            float f0 = par1.tickCount - 40;
            float size1 = (float)(par1.getSigmoid(f0, 0.03125f) * 20.0);
            float size2 = (float)(par1.getSigmoid(f0, 0.015625f) * 20.0);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDepthMask((boolean)true);
            float color = 1.0f - f0 / 760.0f;
            GL11.glColor4f((float)color, (float)color, (float)color, (float)color);
            GLHelper.setLightmapMaxBrightness();
            this.func_147499_a(tex_N);
            GL11.glMatrixMode((int)5890);
            GL11.glLoadIdentity();
            float f1 = (float)(par1.tickCount % 100) + par5;
            GL11.glTranslatef((float)0.0f, (float)(f1 * 0.01f), (float)0.0f);
            GL11.glMatrixMode((int)5888);
            GL11.glPushMatrix();
            GL11.glScalef((float)size1, (float)size1, (float)size1);
            this.model.renderPart(RTMCore.smoothing, "objC");
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glScalef((float)size1, (float)size2, (float)size1);
            this.model.renderPart(RTMCore.smoothing, "objB");
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glScalef((float)size2, (float)size2, (float)size2);
            float color2 = color * 0.75f;
            GL11.glColor4f((float)color2, (float)color2, (float)color2, (float)color2);
            float f2 = (float)(par1.tickCount % 2880) * 0.125f;
            GL11.glRotatef((float)f2, (float)0.0f, (float)1.0f, (float)0.0f);
            this.model.renderPart(RTMCore.smoothing, "objD_1");
            GL11.glRotatef((float)(-f2 * 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            this.model.renderPart(RTMCore.smoothing, "objD_2");
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5890);
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)(-f1 * 0.01f), (float)0.0f);
            GL11.glMatrixMode((int)5888);
            GL11.glPushMatrix();
            float f3 = (size1 - size2) * 6.61f;
            GL11.glTranslatef((float)0.0f, (float)(-f3), (float)0.0f);
            GL11.glScalef((float)size1, (float)size1, (float)size1);
            GL11.glColor4f((float)color, (float)color, (float)color, (float)color);
            this.model.renderPart(RTMCore.smoothing, "objA");
            GL11.glPopMatrix();
            this.func_147499_a(tex_R);
            GL11.glMatrixMode((int)5890);
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)(-f1 * 0.01f), (float)0.0f);
            GL11.glMatrixMode((int)5888);
            GL11.glPushMatrix();
            f3 = (float)(par1.getLinear(f0) * 0.1);
            GL11.glScalef((float)f3, (float)(f3 * 0.75f), (float)f3);
            GL11.glTranslatef((float)0.0f, (float)0.5f, (float)0.0f);
            for (int i = 0; i < PARTS_NAME.length; ++i) {
                GL11.glColor4f((float)color, (float)color, (float)color, (float)color2);
                this.ring.renderPart(RTMCore.smoothing, PARTS_NAME[i]);
                color2 *= 0.75f;
            }
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5890);
            GL11.glLoadIdentity();
            GL11.glMatrixMode((int)5888);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3008);
            GL11.glDepthMask((boolean)true);
        }
    }

    public void render(TileEntityEffect par1, double par2, double par3, double par4, float par5, int par6, float alpha) {
        this.render(par1, par2, par3, par4, par5);
    }
}

