/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.block.tileentity;

import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.ngtlib.renderer.NGTTessellator;
import jp.ngt.ngtlib.util.NGTUtilClient;
import jp.ngt.rtm.block.tileentity.MechanismType;
import jp.ngt.rtm.block.tileentity.TileEntityMechanism;
import jp.ngt.rtm.modelpack.cfg.MechanismConfig;
import jp.ngt.rtm.modelpack.cfg.WireConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetMechanism;
import jp.ngt.rtm.modelpack.modelset.ModelSetWire;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class RenderMechanism
extends TileEntitySpecialRenderer<TileEntityMechanism> {
    private void renderMechanism(TileEntityMechanism tileEntity, double par2, double par4, double par6, float partialTick) {
        this.updateRotation(tileEntity);
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glTranslatef((float)((float)par2 + 0.5f), (float)((float)par4 + 0.5f), (float)((float)par6 + 0.5f));
        int pass = MinecraftForgeClient.getRenderPass();
        ModelSetMechanism modelSet = tileEntity.getResourceState().getResourceSet();
        MechanismConfig cfg = (MechanismConfig)modelSet.getConfig();
        if (cfg.type == MechanismType.PULLEY && tileEntity.getPulleySource() != null && pass == 0) {
            this.renderWire(tileEntity, partialTick);
        }
        if (NGTUtilClient.getMinecraft().field_71474_y.field_74330_P) {
            float prevLineWidth = GL11.glGetFloat((int)2849);
            GL11.glLineWidth((float)5.0f);
            if (tileEntity.getType() == MechanismType.PULLEY) {
                this.renderWirePos(tileEntity);
            }
            GL11.glLineWidth((float)prevLineWidth);
        }
        this.rotateBySide(tileEntity.side);
        GL11.glRotatef((float)NGTMath.wrapAngle((float)((float)tileEntity.dir * 90.0f)), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)0.0f);
        modelSet.modelObj.render(tileEntity, cfg, pass, partialTick);
        GL11.glPopMatrix();
    }

    private void updateRotation(TileEntityMechanism tileEntity) {
        double len;
        long time = System.currentTimeMillis();
        int timeDif = tileEntity.prevTime <= 0L ? 0 : (int)(time - tileEntity.prevTime);
        tileEntity.prevTime = time;
        for (int i = 0; i < tileEntity.rotations.length; ++i) {
            float speed = tileEntity.getOutputRaw(i);
            double d0 = 360.0 * (double)speed * ((double)timeDif / 60000.0);
            float prevRotation = tileEntity.rotations[i];
            tileEntity.rotations[i] = NGTMath.wrapAngle((float)(prevRotation + (float)d0));
        }
        MechanismConfig cfg = (MechanismConfig)tileEntity.getResourceState().getResourceSet().getConfig();
        if (cfg.type == MechanismType.PULLEY && (len = tileEntity.wirePosDst.sub(tileEntity.wirePosSrc).length()) > 0.0) {
            float speedRPM = tileEntity.getOutputRaw(1);
            double speedMPS = (double)(speedRPM * cfg.radius) * Math.PI / 30.0;
            double move = (double)tileEntity.wireMove - speedMPS * (double)timeDif / 1000.0;
            if (move < 0.0) {
                move += len;
            }
            tileEntity.wireMove = (float)(move % len);
        }
    }

    private void rotateBySide(EnumFacing side) {
        switch (side) {
            case DOWN: {
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case UP: {
                break;
            }
            case NORTH: {
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case SOUTH: {
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case EAST: {
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
    }

    private void renderWire(TileEntityMechanism tileEntity, float partialTick) {
        ModelSetWire modelSet = tileEntity.getWireState().getResourceSet();
        if (modelSet.isDummy()) {
            return;
        }
        Vec3 dstVec = Vec3.ZERO;
        Vec3 srcVec = Vec3.ZERO;
        if (tileEntity.isConnectedToPlayer()) {
            EntityPlayerSP player = NGTUtilClient.getMinecraft().field_71439_g;
            if (player.func_145782_y() == tileEntity.getPulleySource().func_177958_n()) {
                Vec3 v1;
                double px = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTick;
                double py = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTick;
                double pz = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTick;
                double difX = px - ((double)tileEntity.getX() + 0.5);
                double difY = py + 1.0 - ((double)tileEntity.getY() + 0.5);
                double difZ = pz - ((double)tileEntity.getZ() + 0.5);
                Vec3 vp = new Vec3(difX, difY, difZ);
                Vec3 vn = tileEntity.getPulleyNormal();
                Vec3 v0 = new Vec3(difX - difX * vn.getX(), difY - difY * vn.getY(), difZ - difZ * vn.getZ());
                float r = ((MechanismConfig)tileEntity.getResourceState().getResourceSet().getConfig()).radius;
                float angle = (float)NGTMath.toDegrees((double)Math.acos((double)r / v0.length()));
                float invert = tileEntity.invertWirePos ? 1.0f : -1.0f;
                dstVec = v1 = v0.normalize().multi((double)r).rotateAroundVec(vn, angle * invert);
                srcVec = vp;
            }
        } else {
            dstVec = tileEntity.wirePosDst;
            srcVec = tileEntity.wirePosSrc;
        }
        this.renderWire(tileEntity, modelSet, dstVec, srcVec, tileEntity.wireMove, 0);
    }

    private void renderWire(TileEntityMechanism tileEntity, ModelSetWire modelSet, Vec3 dstVec, Vec3 srcVec, float wireMove, int pass) {
        NGTUtilClient.bindTexture((ResourceLocation)modelSet.modelObj.textures[0].material.texture);
        WireConfig cfg = (WireConfig)modelSet.getConfig();
        GL11.glPushMatrix();
        Vec3 v0 = dstVec.sub(srcVec);
        GL11.glTranslatef((float)((float)srcVec.getX()), (float)((float)srcVec.getY()), (float)((float)srcVec.getZ()));
        GL11.glRotatef((float)(v0.getYaw() + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(v0.getPitch() - 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        double length = v0.length();
        float secLen = cfg.sectionLength;
        double move2 = tileEntity.wireMove % secLen;
        if (move2 > 0.0) {
            length += (double)secLen;
            GL11.glTranslatef((float)0.0f, (float)((float)move2 - secLen), (float)0.0f);
        }
        int split = NGTMath.floor((double)(length / (double)secLen));
        float scaleY = (float)(length / (double)split / (double)secLen);
        GL11.glScalef((float)1.0f, (float)scaleY, (float)1.0f);
        for (int i = 0; i < split; ++i) {
            modelSet.modelObj.model.renderAll(cfg.smoothing);
            GL11.glTranslatef((float)0.0f, (float)secLen, (float)0.0f);
        }
        GL11.glPopMatrix();
        if (!tileEntity.wirePosDstOpposite.equals((Object)Vec3.ZERO)) {
            GL11.glPushMatrix();
            this.rotateBySide(tileEntity.side);
            float r = ((MechanismConfig)tileEntity.getResourceState().getResourceSet().getConfig()).radius;
            float angle = tileEntity.wirePosDst.getAngle360(tileEntity.wirePosDstOpposite, tileEntity.getPulleyNormal()) + 180.0f;
            double circumference = Math.PI * 2 * (double)r;
            double arcLen = circumference * ((double)angle / 360.0);
            move2 = (double)secLen - move2;
            float firstPosAngle = tileEntity.wirePosAngle;
            if (move2 > 0.0) {
                arcLen += (double)secLen;
                float ro = (float)(360.0 * ((move2 - (double)secLen) / circumference));
                firstPosAngle += ro;
            }
            int split2 = NGTMath.floor((double)(arcLen / (double)secLen));
            float secAngle = (float)(360.0 * ((double)secLen / circumference));
            GL11.glRotatef((float)(firstPosAngle + secAngle * 0.5f), (float)0.0f, (float)1.0f, (float)0.0f);
            for (int i = 0; i < split2; ++i) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)r, (float)0.0f, (float)0.0f);
                float move3 = -(secLen * 0.5f);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)move3);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                modelSet.modelObj.model.renderAll(cfg.smoothing);
                GL11.glPopMatrix();
                GL11.glRotatef((float)secAngle, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            GL11.glPopMatrix();
        }
    }

    private void renderAxis(TileEntityMechanism tileEntity) {
        GL11.glPushMatrix();
        EnumFacing[] ia = tileEntity.indexConverter[0];
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        NGTTessellator tessellator = NGTTessellator.instance;
        tessellator.startDrawing(1);
        this.renderAxisParts(tessellator, ia[5], 0xFF0000);
        this.renderAxisParts(tessellator, ia[1], 65280);
        this.renderAxisParts(tessellator, ia[3], 255);
        tessellator.draw();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    private void renderAxisParts(NGTTessellator tessellator, EnumFacing face, int color) {
        float scale = 2.0f;
        tessellator.setColorRGBA_I(color, 255);
        tessellator.addVertex(0.0f, 0.0f, 0.0f);
        tessellator.addVertex((float)face.func_176730_m().func_177958_n() * scale, (float)face.func_176730_m().func_177956_o() * scale, (float)face.func_176730_m().func_177952_p() * scale);
    }

    private void renderWirePos(TileEntityMechanism tileEntity) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        NGTTessellator tessellator = NGTTessellator.instance;
        tessellator.startDrawing(1);
        this.renderWirePosVec(tessellator, tileEntity.wirePosSrc, 0xFF0000);
        this.renderWirePosVec(tessellator, tileEntity.wirePosDst, 65280);
        this.renderWirePosVec(tessellator, tileEntity.wirePosDstOpposite, 255);
        tessellator.draw();
        this.rotateBySide(tileEntity.side);
        GL11.glRotatef((float)tileEntity.wirePosAngle, (float)0.0f, (float)1.0f, (float)0.0f);
        tessellator.startDrawing(1);
        tessellator.setColorRGBA_I(0xFF00FF, 255);
        tessellator.addVertex(0.0f, 0.0f, 0.0f);
        tessellator.addVertex(0.0f, 0.0f, 3.0f);
        tessellator.draw();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    private void renderWirePosVec(NGTTessellator tessellator, Vec3 vec, int color) {
        tessellator.setColorRGBA_I(color, 255);
        tessellator.addVertex(0.0f, 0.0f, 0.0f);
        tessellator.addVertex((float)vec.getX(), (float)vec.getY(), (float)vec.getZ());
    }

    public void render(TileEntityMechanism tileEntity, double par2, double par4, double par6, float par8, int par9, float alpha) {
        this.renderMechanism(tileEntity, par2, par4, par6, par8);
    }
}

