/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.block.tileentity;

import java.util.Random;
import jp.ngt.ngtlib.block.BlockLiquidBase;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.math.PooledVec3;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.RTMFluid;
import jp.ngt.rtm.block.tileentity.TileEntityConverter;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityConverterCore
extends TileEntityConverter {
    private static final int Max_Capacity = 720;
    private byte direction;
    private int capacity;
    private int mode = 0;
    private int count = 0;
    private int prevMode = 0;
    private float pitch = 0.0f;
    public boolean powered = false;
    private boolean prevPowered = false;

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.direction = nbt.func_74771_c("dir");
        this.capacity = nbt.func_74762_e("capacity");
        this.mode = nbt.func_74762_e("mode");
        this.count = nbt.func_74762_e("count");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("dir", this.direction);
        nbt.func_74768_a("capacity", this.capacity);
        nbt.func_74768_a("mode", this.mode);
        nbt.func_74768_a("count", this.count);
        return nbt;
    }

    @Override
    public void func_73660_a() {
        int x = this.getX();
        int y = this.getY();
        int z = this.getZ();
        this.prevPowered = this.powered;
        this.powered = false;
        this.prevMode = this.mode;
        if (!this.prevPowered && this.pitch == 0.0f) {
            if (BlockUtil.getBlock((IBlockAccess)this.func_145831_w(), (int)x, (int)(y + 1), (int)z) == RTMFluid.liquefiedPigIron) {
                if (this.capacity < 720) {
                    int meta = BlockUtil.getMetadata((IBlockAccess)this.func_145831_w(), (int)x, (int)(y + 1), (int)z);
                    this.capacity += meta + 1;
                    if (this.capacity > 720) {
                        this.capacity = 720;
                    }
                    BlockUtil.setAir((World)this.field_145850_b, (int)x, (int)(y + 1), (int)z);
                    if (this.capacity > 540) {
                        this.mode = 1;
                    }
                }
            } else if (this.capacity > 0) {
                if (this.mode == 1) {
                    this.mode = 2;
                } else if (this.mode == 2) {
                    ++this.count;
                    if (this.count > this.capacity * 16) {
                        this.mode = 3;
                        this.count = 0;
                    }
                }
            }
        }
        if (this.mode == 0 || this.mode == 3) {
            this.pitch = this.prevPowered ? (this.pitch += 0.5f) : (this.pitch -= 0.5f);
            if (this.pitch > 90.0f) {
                this.pitch = 90.0f;
            }
            if (this.pitch < 0.0f) {
                this.pitch = 0.0f;
            }
            if (this.prevPowered && this.pitch > 27.0f) {
                Vec3 vec3 = PooledVec3.create((double)0.0, (double)2.04805, (double)2.9275);
                vec3 = vec3.rotateAroundX(-this.pitch);
                vec3 = vec3.rotateAroundY((float)(-this.direction) * 90.0f);
                if (this.mode == 3) {
                    if (this.capacity > 0) {
                        --this.capacity;
                    } else {
                        this.mode = 0;
                    }
                }
                if (this.field_145850_b.field_72995_K) {
                    if (this.mode == 3 && this.capacity > 0) {
                        for (int i = 0; i < 10; ++i) {
                            Random random = this.field_145850_b.field_73012_v;
                            double x0 = (double)x + vec3.getX() + 0.5 - 0.25 + (double)(random.nextFloat() * 0.5f);
                            double y0 = (double)y + vec3.getY() - 0.25 + (double)(random.nextFloat() * 0.5f);
                            double z0 = (double)z + vec3.getZ() + 0.5 - 0.25 + (double)(random.nextFloat() * 0.5f);
                            RTMCore.proxy.spawnModParticle(this.field_145850_b, x0, y0, z0, 0.0, -0.125, 0.0);
                        }
                    }
                } else if (this.mode == 3 && this.capacity > 0) {
                    int x1 = NGTMath.floor((double)((double)x + vec3.getX() + 0.5));
                    int y1 = NGTMath.floor((double)((double)y + vec3.getY()));
                    int z1 = NGTMath.floor((double)((double)z + vec3.getZ() + 0.5));
                    while (BlockUtil.getBlock((IBlockAccess)this.func_145831_w(), (int)x1, (int)y1, (int)z1) == Blocks.field_150350_a || BlockUtil.getBlock((IBlockAccess)this.func_145831_w(), (int)x1, (int)y1, (int)z1) == RTMFluid.liquefiedSteel) {
                        --y;
                    }
                    BlockLiquidBase.addLiquid((World)this.field_145850_b, (int)x1, (int)(y1 + 1), (int)z1, (Block)RTMFluid.liquefiedSteel, (int)1, (boolean)true);
                }
            }
        }
        if (!this.field_145850_b.field_72995_K && this.mode != this.prevMode) {
            this.sendPacket();
            NGTLog.sendChatMessageToAll((String)("message.converter.mode" + this.mode), (Object[])new Object[0]);
        }
    }

    public float getPitch() {
        return this.pitch;
    }

    public int getMode() {
        return this.mode;
    }

    public byte getDirection() {
        return this.direction;
    }

    public void setDirection(byte par1) {
        this.direction = par1;
        this.sendPacket();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        int x = this.getX();
        int y = this.getY();
        int z = this.getZ();
        AxisAlignedBB bb = new AxisAlignedBB((double)(x - 3), (double)(y - 3), (double)(z - 3), (double)(x + 4), (double)(y + 4), (double)(z + 4));
        return bb;
    }
}

