/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.block.tt;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.ngt.ngtlib.renderer.media.FontImage;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.rtm.block.tt.StationTimeTable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SignboardText {
    private static final int IMAGE_SIZE = 48;
    private static final float TO_SEC = 0.001f;
    private static final String SEPARATOR = "\\|";
    private static final Pattern TT_SETTING = Pattern.compile("tt\\(col=(-?[0-9]+)\\,offset=([0-9]+)\\)");
    private FontImage[] texts;
    private String rawText;
    public float posU = 0.0f;
    public float posV = 0.0f;
    public float size = 0.25f;
    public float width = 1.5f;
    public AnimeType animeType = AnimeType.SWITCH;
    public float animeSpeed = 1.0f;
    private float prevMinU;
    private long prevTime;
    private int index;
    private StationTimeTable timeTable;
    private boolean ttMode;
    private int ttOffset;
    private int ttTrack;

    public SignboardText(boolean isClient, StationTimeTable tt) {
        this.timeTable = tt;
        this.setText("sample|aaa", "Meiryo UI", 0, 0, isClient);
    }

    public static SignboardText readFromNBT(NBTTagCompound nbt, StationTimeTable tt) {
        SignboardText st = new SignboardText(!NGTUtil.isServer(), tt);
        String s1 = nbt.func_74779_i("Text");
        String s2 = nbt.func_74779_i("Font");
        int i1 = nbt.func_74762_e("Style");
        int i2 = nbt.func_74762_e("Color");
        st.posU = nbt.func_74760_g("PosU");
        st.posV = nbt.func_74760_g("PosV");
        st.size = nbt.func_74760_g("Size");
        st.width = nbt.func_74760_g("Width");
        st.animeType = AnimeType.values()[nbt.func_74762_e("AnimeType")];
        st.animeSpeed = nbt.func_74760_g("AnimeSpeed");
        st.setText(s1, s2, i1, i2, !NGTUtil.isServer());
        return st;
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("Text", this.rawText);
        nbt.func_74778_a("Font", this.getText().getFont());
        nbt.func_74768_a("Style", this.getText().getStyle());
        nbt.func_74768_a("Color", this.getText().getColor());
        nbt.func_74776_a("PosU", this.posU);
        nbt.func_74776_a("PosV", this.posV);
        nbt.func_74776_a("Size", this.size);
        nbt.func_74776_a("Width", this.width);
        nbt.func_74768_a("AnimeType", this.animeType.ordinal());
        nbt.func_74776_a("AnimeSpeed", this.animeSpeed);
        return nbt;
    }

    public FontImage getText() {
        if (this.ttMode) {
            int idx = this.timeTable.getMatchTrainIndex(this.ttTrack) + this.ttOffset;
            if (idx >= this.texts.length) {
                idx = this.texts.length - 1;
            }
            return this.texts[idx];
        }
        return this.texts[this.index];
    }

    public String getRawText() {
        return this.rawText;
    }

    public void setText(String pText, String pFont, int pStyle, int pColor, boolean isClient) {
        this.ttMode = false;
        this.ttOffset = 0;
        this.ttTrack = -1;
        Matcher matcher = TT_SETTING.matcher(pText);
        if (matcher.matches()) {
            this.ttMode = true;
            int col = 0;
            try {
                col = Integer.valueOf(matcher.group(1));
                this.ttOffset = Integer.valueOf(matcher.group(2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.texts = new FontImage[this.timeTable.getSize() + 1];
            for (int i = 0; i < this.texts.length - 1; ++i) {
                String s = col == -1 ? this.timeTable.timeTable.trainName[i] : this.timeTable.getData(i, col);
                this.texts[i] = FontImage.create((String)s, (String)pFont, (int)pStyle, (int)pColor, (int)48, (boolean)isClient);
            }
            this.texts[this.texts.length - 1] = FontImage.create((String)" ", (String)pFont, (int)pStyle, (int)pColor, (int)48, (boolean)isClient);
        } else if (this.animeType == AnimeType.SWITCH) {
            String[] sa = pText.split(SEPARATOR);
            this.texts = new FontImage[sa.length];
            for (int i = 0; i < sa.length; ++i) {
                this.texts[i] = FontImage.create((String)sa[i], (String)pFont, (int)pStyle, (int)pColor, (int)48, (boolean)isClient);
            }
        } else {
            this.texts = new FontImage[]{FontImage.create((String)pText, (String)pFont, (int)pStyle, (int)pColor, (int)48, (boolean)isClient)};
        }
        this.rawText = pText;
        this.index = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public SignboardText copy() {
        SignboardText text = new SignboardText(true, this.timeTable);
        FontImage img = this.getText();
        text.setText(this.rawText, img.getFont(), img.getStyle(), img.getColor(), true);
        return text;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(float x, float y, float z, float scale) {
        float minU = 0.0f;
        float maxU = 1.0f;
        float w2 = this.width;
        long time = System.currentTimeMillis();
        float difSec = (float)(time - this.prevTime) * 0.001f;
        boolean drawFlag = true;
        if (this.animeType == AnimeType.SCROLL) {
            minU = this.prevMinU + difSec / this.animeSpeed;
            float tw = 48.0f * this.width / this.size / (float)this.getText().getWidth();
            maxU = (minU %= 1.0f) + tw;
            this.prevTime = time;
            this.prevMinU = minU;
        } else if (this.animeType == AnimeType.FLASH) {
            if (difSec >= this.animeSpeed) {
                drawFlag = false;
                if (difSec >= this.animeSpeed * 2.0f) {
                    this.prevTime = time;
                }
            }
        } else {
            int tw;
            if (this.animeType == AnimeType.SWITCH && difSec >= this.animeSpeed) {
                this.index = (this.index + 1) % this.texts.length;
                this.prevTime = time;
            }
            if ((maxU = (float)(tw = (int)(48.0f * this.width / this.size)) / (float)this.getText().getWidth()) > 1.0f) {
                maxU = 1.0f;
                w2 = this.size * (float)this.getText().getWidth() / (float)this.getText().getHeight();
            }
        }
        float h = this.size * scale;
        float w = w2 * scale;
        if (drawFlag) {
            this.getText().render(x, y, z, w, h, minU, 0.0f, maxU, 1.0f);
        }
    }

    public static enum AnimeType {
        NONE,
        SCROLL,
        SWITCH,
        FLASH,
        FLAP;

    }
}

