/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.block.tt;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ngt.ngtlib.io.NGTFileLoader;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.io.NGTText;
import jp.ngt.ngtlib.renderer.model.ModelFormatException;
import jp.ngt.rtm.block.tt.TimeTable;

public class TimeTableManager {
    public static final String SAMPLE = "tt_sample.csv";
    public static final TimeTableManager INSTANCE = new TimeTableManager();
    private final Map<String, TimeTable> ttEntries = new HashMap<String, TimeTable>();
    private final Map<String, TimeTable> trainToTT = new HashMap<String, TimeTable>();

    private TimeTableManager() {
    }

    public void load() {
        List fileList = NGTFileLoader.findFile(file -> file.getName().startsWith("tt_") && file.getName().endsWith(".csv"));
        for (File file2 : fileList) {
            try {
                this.loadTT(file2);
            }
            catch (IOException e) {
                throw new ModelFormatException(String.format("[TTM] Can't load TT : %s", file2.getAbsolutePath()), (Throwable)e);
            }
        }
    }

    private void loadTT(File file) throws IOException {
        String[][] csv = NGTText.readCSV((File)file, (String)"UTF-8");
        String name = file.getName();
        this.ttEntries.put(name, new TimeTable(name, csv));
        NGTLog.debug((String)"[TTM] Load TT : %s", (Object[])new Object[]{name});
    }

    public TimeTable getTimeTable(String name) {
        if (this.ttEntries.containsKey(name)) {
            return this.ttEntries.get(name);
        }
        return this.ttEntries.get(SAMPLE);
    }

    public void addTTAndTrain(String train, TimeTable tt) {
        this.trainToTT.put(train, tt);
    }

    public TimeTable getTimeTableByTrainName(String name) {
        if (this.trainToTT.containsKey(name)) {
            return this.trainToTT.get(name);
        }
        return this.ttEntries.get(SAMPLE);
    }

    public String[] getNames() {
        Set<String> set = this.ttEntries.keySet();
        return set.toArray(new String[set.size()]);
    }
}

