/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.electric;

import java.util.ArrayList;
import java.util.List;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.rtm.RTMResource;
import jp.ngt.rtm.electric.IProvideElectricity;
import jp.ngt.rtm.electric.TileEntityDummyEW;
import jp.ngt.rtm.electric.TileEntityElectricalWiring;
import jp.ngt.rtm.modelpack.modelset.ModelSetWire;
import jp.ngt.rtm.modelpack.state.ResourceState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Connection {
    private final ResourceState<ModelSetWire> state = new ResourceState(RTMResource.WIRE, null);
    public boolean isRoot;
    public ConnectionType type;
    public int x;
    public int y;
    public int z;
    private Object connectedObject;

    public Connection() {
    }

    public Connection(boolean b, int x2, int y2, int z2, ConnectionType type2, ResourceState par6) {
        this();
        this.isRoot = b;
        this.x = x2;
        this.y = y2;
        this.z = z2;
        this.type = type2;
        if (par6 != null) {
            this.state.readFromNBT(par6.writeToNBT());
        }
    }

    public static List<Connection> readListFromNBT(NBTTagCompound nbt) {
        ArrayList<Connection> list = new ArrayList<Connection>();
        NBTTagList tagList = nbt.func_150295_c("connections", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbt0 = tagList.func_150305_b(i);
            Connection connection = new Connection();
            connection.readFromNBT(nbt0);
            list.add(connection);
        }
        return list;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.state.readFromNBT(nbt.func_74775_l("State"));
        this.isRoot = nbt.func_74767_n("IsRoot");
        if (!nbt.func_74764_b("IsRoot")) {
            this.isRoot = true;
        }
        this.x = nbt.func_74762_e("x");
        this.y = nbt.func_74762_e("y");
        this.z = nbt.func_74762_e("z");
        int typeId = nbt.func_74762_e("type");
        if (this.state.version <= 0) {
            String name = nbt.func_74779_i("ModelName");
            if (name.isEmpty()) {
                switch (typeId) {
                    case 1: {
                        name = "BasicWireBlack";
                        break;
                    }
                    case 2: {
                        name = "SimpleCatenary";
                        typeId = 1;
                        break;
                    }
                    case 50: {
                        name = "BasicWireBlack";
                        break;
                    }
                    case 51: {
                        name = "SimpleCatenary";
                        typeId = 50;
                    }
                }
            }
            this.state.setResourceName(name);
        }
        this.type = ConnectionType.getType(typeId);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("State", (NBTBase)this.state.writeToNBT());
        nbt.func_74757_a("IsRoot", this.isRoot);
        nbt.func_74768_a("x", this.x);
        nbt.func_74768_a("y", this.y);
        nbt.func_74768_a("z", this.z);
        nbt.func_74768_a("type", (int)this.type.id);
    }

    public static void writeListToNBT(NBTTagCompound nbt, List<Connection> list) {
        NBTTagList tagList = new NBTTagList();
        for (Connection connection : list) {
            NBTTagCompound nbt0 = new NBTTagCompound();
            connection.writeToNBT(nbt0);
            tagList.func_74742_a((NBTBase)nbt0);
        }
        nbt.func_74782_a("connections", (NBTBase)tagList);
    }

    public ResourceState<ModelSetWire> getResourceState() {
        return this.state;
    }

    public TileEntityElectricalWiring getElectricalWiring(World world) {
        if (this.type == ConnectionType.WIRE || this.type == ConnectionType.TO_ENTITY) {
            if (this.connectedObject != null && this.connectedObject instanceof TileEntityElectricalWiring) {
                return (TileEntityElectricalWiring)((Object)this.connectedObject);
            }
            if (this.type == ConnectionType.TO_ENTITY) {
                this.connectedObject = TileEntityElectricalWiring.getWireEntity(world, this.x, this.y, this.z);
                return (TileEntityElectricalWiring)((Object)this.connectedObject);
            }
            TileEntity te = BlockUtil.getTileEntity((IBlockAccess)world, (int)this.x, (int)this.y, (int)this.z);
            if (te instanceof TileEntityElectricalWiring) {
                this.connectedObject = (TileEntityElectricalWiring)te;
                return (TileEntityElectricalWiring)((Object)this.connectedObject);
            }
        }
        return null;
    }

    public IProvideElectricity getIProvideElectricity(World world) {
        TileEntity te;
        if (this.type == ConnectionType.DIRECT && (te = BlockUtil.getTileEntity((IBlockAccess)world, (int)this.x, (int)this.y, (int)this.z)) instanceof IProvideElectricity) {
            return (IProvideElectricity)te;
        }
        return null;
    }

    public EntityPlayer getPlayer(World world) {
        if (this.type == ConnectionType.TO_PLAYER && this.isAvailable(world)) {
            return (EntityPlayer)this.connectedObject;
        }
        return null;
    }

    public boolean isAvailable(World world) {
        if (this.type == ConnectionType.DIRECT) {
            return true;
        }
        if (this.type == ConnectionType.TO_PLAYER) {
            if (this.connectedObject instanceof EntityPlayer) {
                return TileEntityElectricalWiring.getWireType((EntityPlayer)this.connectedObject) != null;
            }
            Entity entity = world.func_73045_a(this.x);
            if (entity instanceof EntityPlayer) {
                this.connectedObject = entity;
                return true;
            }
            return false;
        }
        if (this.connectedObject == null) {
            this.getElectricalWiring(world);
        }
        if (this.connectedObject instanceof TileEntityDummyEW) {
            TileEntityDummyEW tile = (TileEntityDummyEW)((Object)this.connectedObject);
            if (tile.entityEW == null || tile.entityEW.field_70128_L) {
                return false;
            }
        } else if (this.connectedObject instanceof TileEntityElectricalWiring) {
            return !((TileEntityElectricalWiring)((Object)this.connectedObject)).func_145837_r();
        }
        return this.connectedObject != null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Connection) {
            Connection con = (Connection)obj;
            return this.type == con.type && this.x == con.x && this.y == con.y && this.z == con.z;
        }
        return false;
    }

    public int hashCode() {
        return (this.x & 0xFF) << 16 | (this.y & 0xFF) << 8 | this.z & 0xFF;
    }

    public static enum ConnectionType {
        NONE(0, false),
        WIRE(1, true),
        DIRECT(3, false),
        TO_ENTITY(4, true),
        TO_PLAYER(50, true);

        public final byte id;
        public final boolean isVisible;

        private ConnectionType(int par1, boolean par2) {
            this.id = (byte)par1;
            this.isVisible = par2;
        }

        public static ConnectionType getType(int par1) {
            for (ConnectionType type : ConnectionType.values()) {
                if (type.id != par1) continue;
                return type;
            }
            return NONE;
        }
    }
}

