/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.electric;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ngt.ngtlib.block.TileEntityCustom;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.rtm.electric.IProvideElectricity;
import jp.ngt.rtm.electric.SignalConverterType;
import jp.ngt.rtm.world.IChunkLoader;
import jp.ngt.rtm.world.RTMChunkManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntitySignalConverter
extends TileEntityCustom
implements IProvideElectricity,
ITickable {
    protected ComparatorType comparator = ComparatorType.EQUAL;
    protected int signalOnTrue;
    protected int signalOnFalse;
    protected int signal;

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        int index = nbt.func_74762_e("comparatorIndex");
        ComparatorType type = ComparatorType.getType(index);
        int i0 = nbt.func_74762_e("signal_0");
        int i1 = nbt.func_74762_e("signal_1");
        this.setSignalProp(i0, i1, type);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("comparatorIndex", (int)this.comparator.id);
        nbt.func_74768_a("signal_0", this.signalOnTrue);
        nbt.func_74768_a("signal_1", this.signalOnFalse);
        return nbt;
    }

    public void func_73660_a() {
    }

    public ComparatorType getComparator() {
        return this.comparator;
    }

    public int[] getSignalLevel() {
        return new int[]{this.signalOnTrue, this.signalOnFalse};
    }

    public void setSignalProp(int par1, int par2, ComparatorType par3) {
        this.signalOnTrue = par1;
        this.signalOnFalse = par2;
        this.comparator = par3;
        this.func_70296_d();
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.sendPacket();
    }

    public abstract int getRSOutput();

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 256.0;
    }

    public static TileEntitySignalConverter createTileEntity(int par1) {
        switch (SignalConverterType.getType(par1)) {
            case RSIn: {
                return new TileEntitySC_RSIn();
            }
            case RSOut: {
                return new TileEntitySC_RSOut();
            }
            case Increment: {
                return new TileEntitySC_Increment();
            }
            case Decrement: {
                return new TileEntitySC_Decrement();
            }
            case Wireless: {
                return new TileEntitySC_Wireless();
            }
        }
        return new TileEntitySC_RSIn();
    }

    public static enum ComparatorType {
        EQUAL(0, "=="),
        GREATER_THAN(1, ">"),
        GREATER_EQUAL(2, ">="),
        LESS_THAN(3, "<"),
        LESS_EQUAL(4, "<="),
        NOT_EQUAL(5, "!=");

        public final byte id;
        public final String operator;

        private ComparatorType(int par1, String par2) {
            this.id = (byte)par1;
            this.operator = par2;
        }

        public static ComparatorType getType(int par1) {
            for (ComparatorType type : ComparatorType.values()) {
                if (type.id != par1) continue;
                return type;
            }
            return EQUAL;
        }
    }

    public static class TileEntitySC_Wireless
    extends TileEntitySignalConverter
    implements IChunkLoader {
        private static Map<Integer, List<TileEntitySC_Wireless>> ADAPTER_MAP = new HashMap<Integer, List<TileEntitySC_Wireless>>();
        private int prevChannel = 0;
        private ForgeChunkManager.Ticket ticket;
        private final Set<ChunkPos> loadedChunks = new HashSet<ChunkPos>();
        private boolean finishSetup;

        public TileEntitySC_Wireless() {
            List<TileEntitySC_Wireless> list = this.getList(this.prevChannel);
            list.add(this);
        }

        private List<TileEntitySC_Wireless> getList(int par1) {
            List<TileEntitySC_Wireless> list = ADAPTER_MAP.get(par1);
            if (list == null) {
                list = new ArrayList<TileEntitySC_Wireless>();
                ADAPTER_MAP.put(par1, list);
            }
            return list;
        }

        private void updateAntennaList() {
            List<TileEntitySC_Wireless> list = this.getList(this.prevChannel);
            if (list.contains(this)) {
                list.remove(this);
            }
            List<TileEntitySC_Wireless> list2 = this.getList(this.getChannel());
            list2.add(this);
            this.prevChannel = this.getChannel();
        }

        @Override
        public void func_73660_a() {
            super.func_73660_a();
            if (!this.field_145850_b.field_72995_K) {
                this.updateChunks();
            }
        }

        public void func_145843_s() {
            super.func_145843_s();
            if (!this.field_145850_b.field_72995_K) {
                this.releaseTicket();
            }
        }

        public void func_145829_t() {
            super.func_145829_t();
            if (!this.field_145850_b.field_72995_K) {
                this.updateChunks();
            }
        }

        public int getChannel() {
            return this.signalOnTrue;
        }

        public int getChunkLoadRange() {
            return this.signalOnFalse;
        }

        @Override
        public void setSignalProp(int par1, int par2, ComparatorType par3) {
            super.setSignalProp(par1, par2, par3);
            if (this.field_145850_b == null || !this.field_145850_b.field_72995_K) {
                this.updateAntennaList();
            }
        }

        @Override
        public int getRSOutput() {
            return 0;
        }

        @Override
        public int getElectricity() {
            return this.signal;
        }

        @Override
        public void setElectricity(int x, int y, int z, int level) {
            List<TileEntitySC_Wireless> list = this.getList(this.getChannel());
            for (TileEntitySC_Wireless tile : list) {
                tile.setWirelessSignal(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), level);
            }
        }

        private void setWirelessSignal(int x, int y, int z, int level) {
            this.signal = level;
        }

        private void updateChunks() {
            if (this.isChunkLoaderEnable()) {
                this.forceChunkLoading();
            } else {
                this.releaseTicket();
            }
        }

        @Override
        public boolean isChunkLoaderEnable() {
            return this.getChunkLoadRange() > 0;
        }

        private void releaseTicket() {
            this.loadedChunks.clear();
            if (this.ticket != null) {
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
                this.ticket = null;
            }
        }

        private boolean requestTicket() {
            ForgeChunkManager.Ticket chunkTicket = RTMChunkManager.INSTANCE.getNewTicket(this.field_145850_b, ForgeChunkManager.Type.NORMAL);
            if (chunkTicket != null) {
                int depth = this.getChunkLoadRange();
                chunkTicket.getModData();
                chunkTicket.setChunkListDepth(depth);
                RTMChunkManager.writeData(chunkTicket, (TileEntity)this);
                this.setChunkTicket(chunkTicket);
                return true;
            }
            NGTLog.debug((String)"[RTM] Failed to get ticket (Chunk Loader)");
            return false;
        }

        @Override
        public void setChunkTicket(ForgeChunkManager.Ticket par1) {
            if (this.ticket != par1) {
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
            }
            this.ticket = par1;
            this.finishSetup = false;
        }

        @Override
        public void forceChunkLoading() {
            int cX = this.func_174877_v().func_177958_n() >> 4;
            int cZ = this.func_174877_v().func_177952_p() >> 4;
            this.forceChunkLoading(cX, cZ);
        }

        @Override
        public void forceChunkLoading(int x, int z) {
            if (!this.field_145850_b.field_72995_K) {
                if (this.ticket == null && !this.requestTicket()) {
                    return;
                }
                if (!this.finishSetup) {
                    this.setupChunks(x, z);
                    this.finishSetup = true;
                }
                for (ChunkPos chunk : this.loadedChunks) {
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)chunk);
                }
                ChunkPos myChunk = new ChunkPos(x, z);
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)myChunk);
            }
        }

        private void setupChunks(int xChunk, int zChunk) {
            int range = this.getChunkLoadRange();
            RTMChunkManager.INSTANCE.getChunksAround(this.loadedChunks, xChunk, zChunk, range);
        }
    }

    public static class TileEntitySC_Decrement
    extends TileEntitySignalConverter {
        @Override
        public int getRSOutput() {
            return 0;
        }

        @Override
        public int getElectricity() {
            return this.signal;
        }

        @Override
        public void setElectricity(int x, int y, int z, int level) {
            this.signal = level > 1 ? --level : level;
        }
    }

    public static class TileEntitySC_Increment
    extends TileEntitySignalConverter {
        @Override
        public int getRSOutput() {
            return 0;
        }

        @Override
        public int getElectricity() {
            return this.signal;
        }

        @Override
        public void setElectricity(int x, int y, int z, int level) {
            this.signal = level > 0 ? ++level : 0;
        }
    }

    public static class TileEntitySC_RSOut
    extends TileEntitySignalConverter {
        @Override
        public int getRSOutput() {
            return this.signal == 1 ? 15 : 0;
        }

        @Override
        public int getElectricity() {
            return 0;
        }

        @Override
        public void setElectricity(int x, int y, int z, int level) {
            int i0 = -1;
            switch (this.comparator) {
                case EQUAL: {
                    i0 = level == this.signalOnTrue ? 1 : 0;
                    break;
                }
                case GREATER_EQUAL: {
                    i0 = level >= this.signalOnTrue ? 1 : 0;
                    break;
                }
                case GREATER_THAN: {
                    i0 = level > this.signalOnTrue ? 1 : 0;
                    break;
                }
                case LESS_EQUAL: {
                    i0 = level <= this.signalOnTrue ? 1 : 0;
                    break;
                }
                case LESS_THAN: {
                    i0 = level < this.signalOnTrue ? 1 : 0;
                    break;
                }
                case NOT_EQUAL: {
                    i0 = level != this.signalOnTrue ? 1 : 0;
                    break;
                }
            }
            if (i0 >= 0 && i0 != this.signal) {
                this.signal = i0;
                this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
            }
        }
    }

    public static class TileEntitySC_RSIn
    extends TileEntitySignalConverter {
        @Override
        public int getRSOutput() {
            return 0;
        }

        @Override
        public int getElectricity() {
            for (EnumFacing side : EnumFacing.values()) {
                if (!this.field_145850_b.func_175709_b(this.func_174877_v().func_177972_a(side), side)) continue;
                return this.signalOnTrue;
            }
            return this.signalOnFalse;
        }

        @Override
        public void setElectricity(int x, int y, int z, int level) {
        }
    }
}

