/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.electric;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.ngt.ngtlib.math.ILine;
import jp.ngt.ngtlib.math.StraightLine;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.rtm.electric.Connection;
import jp.ngt.rtm.electric.TileEntityConnectorBase;
import jp.ngt.rtm.electric.TileEntityElectricalWiring;
import jp.ngt.rtm.modelpack.cfg.WireConfig;

public final class WireManager {
    public static final WireManager INSTANCE = new WireManager();
    private static final int CHUNK_DIV = 64;
    private static final int SPLIT = 512;
    private static final double Y_TANGE = 2.0;
    private static final double XZ_TANGE = 1.0;
    private final Map<WireChunk, List<WireEntry>> loadedWires = new HashMap<WireChunk, List<WireEntry>>();

    private WireManager() {
    }

    public void addWire(TileEntityElectricalWiring tileEntity, Connection connection) {
        this.editWire(tileEntity, connection, true);
    }

    public void removeWire(TileEntityElectricalWiring tileEntity, Connection connection) {
        this.editWire(tileEntity, connection, false);
    }

    private void editWire(TileEntityElectricalWiring tileEntity, Connection connection, boolean add) {
        if (connection.type == Connection.ConnectionType.WIRE) {
            TileEntityElectricalWiring te2 = connection.getElectricalWiring(tileEntity.func_145831_w());
            if (tileEntity instanceof TileEntityConnectorBase && te2 instanceof TileEntityConnectorBase) {
                TileEntityConnectorBase con1 = (TileEntityConnectorBase)tileEntity;
                TileEntityConnectorBase con2 = (TileEntityConnectorBase)te2;
                con1.updateWirePos();
                con2.updateWirePos();
                Vec3 vec1 = con1.getWirePos();
                vec1 = vec1.add((double)tileEntity.getX() + 0.5, (double)tileEntity.getY() + 0.5, (double)tileEntity.getZ() + 0.5);
                Vec3 vec2 = con2.getWirePos();
                vec2 = vec2.add((double)te2.getX() + 0.5, (double)te2.getY() + 0.5, (double)te2.getZ() + 0.5);
                WireConfig cfg = (WireConfig)connection.getResourceState().getResourceSet().getConfig();
                Vec3 startVec = vec1.getY() <= vec2.getY() ? vec1 : vec2;
                Vec3 endVec = vec1.getY() > vec2.getY() ? vec1 : vec2;
                int x1 = (int)(vec1.getX() <= vec2.getX() ? vec1.getX() : vec2.getX()) / 64;
                int x2 = (int)(vec1.getX() > vec2.getX() ? vec1.getX() : vec2.getX()) / 64;
                int z1 = (int)(vec1.getZ() <= vec2.getZ() ? vec1.getZ() : vec2.getZ()) / 64;
                int z2 = (int)(vec1.getZ() > vec2.getZ() ? vec1.getZ() : vec2.getZ()) / 64;
                double minY = startVec.getY() + (double)cfg.yOffset;
                double maxY = endVec.getY() + (double)cfg.yOffset;
                WireEntry entry = new WireEntry((ILine)new StraightLine(startVec.getZ(), startVec.getX(), endVec.getZ(), endVec.getX()), minY, maxY);
                for (int i = x1; i <= x2; ++i) {
                    for (int j = z1; j <= z2; ++j) {
                        WireChunk chunk = new WireChunk(i, j);
                        List<WireEntry> list = this.loadedWires.get(chunk);
                        if (list == null) {
                            list = new ArrayList<WireEntry>();
                            this.loadedWires.put(chunk, list);
                        }
                        if (add) {
                            list.add(entry);
                            continue;
                        }
                        list.remove(entry);
                    }
                }
            }
        }
    }

    public double getWireY(double x, double y, double z) {
        List<WireEntry> list = this.loadedWires.get(new WireChunk(x, z));
        if (list != null) {
            for (WireEntry entry : list) {
                if (!entry.inRange(x, y, z)) continue;
                int index = entry.lineXZ.getNearlestPoint(512, x, z);
                double resY = entry.minY + (entry.maxY - entry.minY) * ((double)index / 512.0);
                return resY;
            }
        }
        return y;
    }

    public final class WireChunk {
        public final int chunkX;
        public final int chunkZ;

        public WireChunk(double x, double z) {
            this.chunkX = (int)(x / 64.0);
            this.chunkZ = (int)(z / 64.0);
        }

        public WireChunk(int x, int z) {
            this.chunkX = x;
            this.chunkZ = z;
        }

        public boolean equals(Object obj) {
            if (obj instanceof WireChunk) {
                WireChunk chunk = (WireChunk)obj;
                return this.chunkX == chunk.chunkX && this.chunkZ == chunk.chunkZ;
            }
            return false;
        }

        public int hashCode() {
            return this.chunkX & 0xFFF | (this.chunkZ & 0xFFF) << 12;
        }
    }

    public class WireEntry {
        public final ILine lineXZ;
        public final double minX;
        public final double maxX;
        public final double minY;
        public final double maxY;
        public final double minZ;
        public final double maxZ;

        public WireEntry(ILine par1, double par2, double par3) {
            this.lineXZ = par1;
            this.minY = par2;
            this.maxY = par3;
            double[] d1 = par1.getPoint(512, 0);
            double[] d2 = par1.getPoint(512, 512);
            this.minX = d1[1] <= d2[1] ? d1[1] : d2[1];
            this.maxX = d1[1] > d2[1] ? d1[1] : d2[1];
            this.minZ = d1[0] <= d2[0] ? d1[0] : d2[0];
            this.maxZ = d1[0] > d2[0] ? d1[0] : d2[0];
        }

        public boolean inRange(double x, double y, double z) {
            return x >= this.minX - 1.0 && x <= this.maxX + 1.0 && y >= this.minY - 2.0 && y <= this.maxY + 2.0 && z >= this.minZ - 1.0 && z <= this.maxZ + 1.0;
        }

        public boolean equals(Object obj) {
            if (obj instanceof WireEntry) {
                WireEntry entry = (WireEntry)obj;
                return this.minY == entry.minY && this.maxY == entry.maxY && this.lineXZ.equals(entry.lineXZ);
            }
            return false;
        }

        public int hashCode() {
            return this.lineXZ.hashCode();
        }
    }
}

