/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity;

import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.math.PooledVec3;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.ngtlib.renderer.NGTRenderer;
import jp.ngt.ngtlib.renderer.NGTTessellator;
import jp.ngt.ngtlib.renderer.model.ModelLoader;
import jp.ngt.ngtlib.renderer.model.PolygonModel;
import jp.ngt.ngtlib.renderer.model.VecAccuracy;
import jp.ngt.ngtlib.util.NGTUtilClient;
import jp.ngt.rtm.entity.EntityBullet;
import jp.ngt.rtm.entity.npc.EntityNPC;
import jp.ngt.rtm.item.ItemAmmunition;
import jp.ngt.rtm.item.ItemGun;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderBullet
extends Render<EntityBullet> {
    private final PolygonModel cannon = ModelLoader.loadModel((ResourceLocation)new ResourceLocation("rtm", "models/cannonball.obj"), (VecAccuracy)VecAccuracy.MEDIUM, (Object[])new Object[0]);
    private final PolygonModel rocket = ModelLoader.loadModel((ResourceLocation)new ResourceLocation("rtm", "models/200mm_rocket.mqo"), (VecAccuracy)VecAccuracy.MEDIUM, (Object[])new Object[0]);
    private static PolygonModel razerPart0;
    private static PolygonModel razerPart1;
    private static final ResourceLocation TEX_CANNON;
    private static final ResourceLocation TEX_ROCKET;
    private static final ResourceLocation TEX_FLASH;

    public RenderBullet(RenderManager renderManager) {
        super(renderManager);
        razerPart0 = ModelLoader.loadModel((ResourceLocation)new ResourceLocation("rtm", "models/razer_part0.mqo"), (VecAccuracy)VecAccuracy.MEDIUM, (Object[])new Object[0]);
        razerPart1 = ModelLoader.loadModel((ResourceLocation)new ResourceLocation("rtm", "models/razer_part1.mqo"), (VecAccuracy)VecAccuracy.MEDIUM, (Object[])new Object[0]);
    }

    private final void renderBullet(EntityBullet entity, double par2, double par4, double par6, float par8, float par9) {
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glTranslatef((float)((float)par2), (float)((float)par4), (float)((float)par6));
        GL11.glRotatef((float)(entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * par9 - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * par9), (float)0.0f, (float)0.0f, (float)1.0f);
        ItemAmmunition.BulletType type = entity.getBulletType();
        int pass = MinecraftForgeClient.getRenderPass();
        if (pass == 0) {
            boolean brightBullet;
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            boolean bl = brightBullet = (type == ItemAmmunition.BulletType.rifle_5_56mm || type == ItemAmmunition.BulletType.rifle_7_62mm || type == ItemAmmunition.BulletType.rifle_12_7mm) && entity.getCanBreakBlock();
            if (brightBullet) {
                GL11.glDisable((int)3553);
                if (type == ItemAmmunition.BulletType.rifle_12_7mm) {
                    GL11.glScalef((float)0.1f, (float)1.5f, (float)0.1f);
                } else {
                    GL11.glScalef((float)0.05f, (float)0.75f, (float)0.05f);
                }
                GLHelper.disableLighting();
                GLHelper.setLightmapMaxBrightness();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.25f, (float)1.0f);
            } else if (type == ItemAmmunition.BulletType.handgun_9mm || type == ItemAmmunition.BulletType.rifle_5_56mm || type == ItemAmmunition.BulletType.rifle_7_62mm) {
                this.func_110776_a(TEX_CANNON);
                GL11.glScalef((float)0.05f, (float)0.05f, (float)0.05f);
            } else if (type == ItemAmmunition.BulletType.rifle_12_7mm) {
                this.func_110776_a(TEX_CANNON);
                GL11.glScalef((float)0.1f, (float)0.1f, (float)0.1f);
            } else if (type == ItemAmmunition.BulletType.cannon_40cm || type == ItemAmmunition.BulletType.cannon_Atomic) {
                this.func_110776_a(TEX_CANNON);
            } else if (type == ItemAmmunition.BulletType.rocket) {
                this.func_110776_a(TEX_ROCKET);
            }
            if (type == ItemAmmunition.BulletType.rocket) {
                this.rocket.renderAll(false);
            } else {
                this.cannon.renderAll(false);
            }
            if (brightBullet) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GLHelper.enableLighting();
                GL11.glEnable((int)3553);
            }
        } else if (pass == 1 && type == ItemAmmunition.BulletType.rocket) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            NGTRenderer.renderFire((float)0.5f, (float)3.0f, (int)0xFFAA00, (int)25);
            GL11.glDisable((int)3042);
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    public static void onPlayerRender(EntityPlayer player, boolean firstPersonView) {
        int useCount = player.func_184605_cv();
        ItemStack stack = player.field_71071_by.func_70448_g();
        RenderBullet.onShooterRender((EntityLivingBase)player, 0.0, 0.0, 0.0, stack, useCount, firstPersonView);
    }

    public static void onNPCRender(EntityNPC npc, double x, double y, double z) {
        int useCount = npc.getItemUseCount();
        ItemStack stack = npc.getHeldItem();
        RenderBullet.onShooterRender((EntityLivingBase)npc, x, y, z, stack, useCount, false);
    }

    private static void onShooterRender(EntityLivingBase entity, double x, double y, double z, ItemStack stack, int useCount, boolean firstPersonView) {
        if (RenderBullet.shouldRenderMuzzleFlash(stack, useCount)) {
            ItemGun.GunType gunType = ((ItemGun)stack.func_77973_b()).gunType;
            if (gunType == ItemGun.GunType.razer_gun) {
                float size = (float)useCount / (float)gunType.useDuration;
                RenderBullet.renderRazer(entity, x, y, z, size);
            } else {
                RenderBullet.renderMuzzleFlash(entity, x, y, z, firstPersonView);
            }
        }
    }

    private static boolean shouldRenderMuzzleFlash(ItemStack stack, int useCount) {
        ItemGun.GunType gunType;
        return stack != null && stack.func_77973_b() instanceof ItemGun && ((gunType = ((ItemGun)stack.func_77973_b()).gunType) == ItemGun.GunType.razer_gun ? useCount > 0 : useCount % 2 > 0 && (gunType.rapidFire || useCount == gunType.useDuration - 1));
    }

    private static void renderMuzzleFlash(EntityLivingBase entity, double x, double y, double z, boolean firstPersonView) {
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        RenderBullet.setupPosAndRotation(entity);
        GL11.glDisable((int)2884);
        GLHelper.disableLighting();
        GLHelper.setLightmapMaxBrightness();
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDepthMask((boolean)false);
        NGTUtilClient.bindTexture((ResourceLocation)TEX_FLASH);
        float flashR = 0.75f;
        NGTTessellator tessellator = NGTTessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(-flashR, flashR, 0.0f, 1.0f, 0.0f);
        tessellator.addVertexWithUV(-flashR, -flashR, 0.0f, 1.0f, 1.0f);
        tessellator.addVertexWithUV(flashR, -flashR, 0.0f, 0.0f, 1.0f);
        tessellator.addVertexWithUV(flashR, flashR, 0.0f, 0.0f, 0.0f);
        tessellator.draw();
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2884);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GLHelper.enableLighting();
        GL11.glPopMatrix();
    }

    private static void renderRazer(EntityLivingBase entity, double x, double y, double z, float size) {
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        RenderBullet.setupPosAndRotation(entity);
        GLHelper.disableLighting();
        GLHelper.setLightmapMaxBrightness();
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)3553);
        NGTTessellator tessellator = NGTTessellator.instance;
        int i0 = 25;
        for (int i = 0; i < i0; ++i) {
            float f0 = (float)(i + 1) / (float)i0;
            float f1 = 1.0f - (1.0f - f0) * 0.1f;
            GL11.glScalef((float)(f1 * size), (float)(f1 * size), (float)1.0f);
            tessellator.startDrawing(4);
            tessellator.setColorRGBA_F(f0, f0, 1.0f, 0.125f);
            tessellator.addTranslation(0.0f, 0.0f, 127.5f);
            for (int j = 0; j < 128; ++j) {
                razerPart1.tessellateAll(tessellator, true);
                tessellator.addTranslation(0.0f, 0.0f, -1.0f);
            }
            tessellator.resetTranslation();
            razerPart0.tessellateAll(tessellator, true);
            tessellator.draw();
        }
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GLHelper.enableLighting();
        GL11.glPopMatrix();
    }

    private static void setupPosAndRotation(EntityLivingBase entity) {
        if (entity == NGTUtilClient.getMinecraft().field_71439_g && NGTUtilClient.getMinecraft().func_175598_ae().field_78733_k.field_74320_O == 0) {
            GL11.glTranslatef((float)0.2f, (float)0.05f, (float)-1.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            GL11.glRotatef((float)(-entity.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)entity.func_70047_e(), (float)0.0f);
            GL11.glRotatef((float)entity.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.36f, (float)-0.05f, (float)0.4f);
        }
    }

    @Deprecated
    private static void setupPosAndRotation2(EntityLivingBase entity) {
        double d7;
        double d6;
        double d5;
        double d4;
        RenderManager renMg = NGTUtilClient.getMinecraft().func_175598_ae();
        float partialTicks = 0.0f;
        GlStateManager.func_179114_b((float)(-entity.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(renMg.field_78733_k.field_74320_O == 2 ? -1 : 1) * -entity.field_70125_A), (float)1.0f, (float)0.0f, (float)0.0f);
        int k = entity.func_184591_cq() == EnumHandSide.RIGHT ? 1 : -1;
        float f7 = entity.func_70678_g(partialTicks);
        float f8 = MathHelper.func_76126_a((float)((float)NGTMath.firstSqrt((double)f7) * (float)Math.PI));
        float f9 = (entity.field_70760_ar + (entity.field_70761_aq - entity.field_70760_ar) * partialTicks) * ((float)Math.PI / 180);
        double d0 = MathHelper.func_76126_a((float)f9);
        double d1 = MathHelper.func_76134_b((float)f9);
        double d2 = (double)k * 0.35;
        double d3 = 0.8;
        if ((renMg.field_78733_k == null || renMg.field_78733_k.field_74320_O <= 0) && entity == Minecraft.func_71410_x().field_71439_g) {
            Vec3 vec3d = PooledVec3.create((double)((double)k * -0.36), (double)-0.05, (double)0.4);
            vec3d = vec3d.rotateAroundX(-(entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks));
            vec3d = vec3d.rotateAroundY(-(entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTicks));
            vec3d = vec3d.rotateAroundY(f8 * 0.5f);
            vec3d = vec3d.rotateAroundX(-f8 * 0.7f);
            d4 = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks + vec3d.getX();
            d5 = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks + vec3d.getY();
            d6 = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks + vec3d.getZ();
            d7 = entity.func_70047_e();
        } else {
            d4 = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks - d1 * d2 - d0 * 0.8;
            d5 = entity.field_70167_r + (double)entity.func_70047_e() + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks - 0.45;
            d6 = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks - d0 * d2 + d1 * 0.8;
            d7 = entity.func_70093_af() ? -0.1875 : 0.0;
        }
        double d13 = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks;
        double d8 = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks + 0.25;
        double d9 = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks;
        float pX = (float)(d4 - d13);
        float pY = (float)(d5 - d8 + d7);
        float pZ = (float)(d6 - d9);
        GL11.glTranslatef((float)pX, (float)pY, (float)pZ);
    }

    protected ResourceLocation getEntityTexture(EntityBullet par1) {
        return null;
    }

    public void doRender(EntityBullet par1, double par2, double par4, double par6, float par8, float par9) {
        this.renderBullet(par1, par2, par4, par6, par8, par9);
    }

    static {
        TEX_CANNON = new ResourceLocation("rtm", "textures/cannonball.png");
        TEX_ROCKET = new ResourceLocation("rtm", "textures/200mm_rocket.png");
        TEX_FLASH = new ResourceLocation("rtm", "textures/effect/muzzle_flash.png");
    }
}

