/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.fluid;

import java.util.ArrayList;
import java.util.List;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.rtm.RTMItem;
import jp.ngt.rtm.entity.fluid.FluidType;
import jp.ngt.rtm.entity.fluid.FluidVertexHolder;
import jp.ngt.rtm.item.ItemBucketLiquid;
import jp.ngt.rtm.item.ItemPaddle;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityFluid
extends Entity {
    private static final DataParameter<String> TYPE = EntityDataManager.func_187226_a(EntityFluid.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Float> TEMP = EntityDataManager.func_187226_a(EntityFluid.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final float R = 0.125f;
    public static final float SIZE = 0.25f;
    public static final float METABALL_RANGE = 1.0f;
    private static final float METABALL_RANGE_SQ = 1.0f;
    private static AxisAlignedBB COLLISION_BOX = new AxisAlignedBB(-0.0625, -0.0625, -0.0625, 0.0625, 0.0625, 0.0625);
    private static final Item ITEM_IRON_ORE = Item.func_150898_a((Block)Blocks.field_150366_p);
    public final List<EntityFluid> nearFluids = new ArrayList<EntityFluid>();
    public float posDif;
    private int counter;
    private int airCount;
    public FluidVertexHolder fluidVtx;

    public EntityFluid(World world) {
        super(world);
        this.func_70105_a(0.25f, 0.25f);
        if (world.field_72995_K) {
            this.fluidVtx = new FluidVertexHolder();
        }
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(TYPE, (Object)"");
        this.func_184212_Q().func_187214_a(TEMP, (Object)Float.valueOf(0.0f));
    }

    public AxisAlignedBB func_70046_E() {
        return COLLISION_BOX.func_72317_d(this.field_70165_t, this.field_70163_u + 0.125, this.field_70161_v);
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70075_an() {
        return true;
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.setFluidType(nbt.func_74779_i("type"));
        this.setTemperture(nbt.func_74760_g("temperture"));
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74778_a("type", this.getFluidType().toString());
        nbt.func_74776_a("temperture", this.getTemperature());
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70181_x -= 0.03;
        this.calcFluidMovement();
        this.func_145771_j(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        this.fixPosByBlockCollision();
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        float f = 0.98f;
        if (this.field_70122_E) {
            BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
            IBlockState underState = this.field_70170_p.func_180495_p(underPos);
            f *= underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this);
        }
        this.field_70159_w *= (double)f;
        this.field_70181_x *= 0.98;
        this.field_70179_y *= (double)f;
        if (this.field_70122_E) {
            this.field_70181_x *= -0.9;
        }
        this.updateFluidState();
    }

    protected void updateFluidState() {
        float temp = this.getTemperature();
        if (temp >= 500.0f) {
            ++this.counter;
        }
        if (this.field_70170_p.field_72995_K) {
            float f0 = 1.0f - this.getNormalizedTemperture();
            if (this.getFluidType() == FluidType.COKE) {
                int rand = 100 + (int)(100.0f * f0);
                if (this.getTemperature() > 200.0f && this.field_70170_p.field_73012_v.nextInt(rand) == 0) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u + 0.25, this.field_70161_v, 0.0, 0.125, 0.0, new int[0]);
                }
            } else if (this.getFluidType().type == FluidType.Type.LIQUID) {
                int rand = 250 + (int)(250.0f * f0);
                if (this.getTemperature() > 300.0f && this.field_70170_p.field_73012_v.nextInt(rand) == 0) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t, this.field_70163_u + 0.25, this.field_70161_v, 0.0, 0.125, 0.0, new int[0]);
                }
            }
            this.fluidVtx.update(this);
        } else {
            int max;
            if (temp > 0.0f) {
                if (this.field_70170_p.func_180495_p(new BlockPos((Entity)this)).func_185904_a() == Material.field_151586_h) {
                    temp -= 20.0f;
                } else if (this.getFluidType() != FluidType.COKE && this.field_70170_p.field_73012_v.nextInt(10) == 0) {
                    temp -= 1.0f;
                }
                if (temp != this.getTemperature()) {
                    this.setTemperture(temp);
                }
            }
            if ((max = this.getFluidType().life) > 0 && this.counter >= max) {
                this.func_70106_y();
            }
        }
    }

    private void calcFluidMovement() {
        this.nearFluids.clear();
        this.posDif = 0.0f;
        double repRange = 0.3;
        double repulsion = this.getFluidType().viscosity * this.getNormalizedTemperture();
        double px = this.field_70165_t;
        double py = this.field_70163_u;
        double pz = this.field_70161_v;
        double maxDif = 0.0;
        double accumDif = 0.0;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(1.0, 1.0, 1.0));
        for (Entity entity2 : list) {
            if (entity2.field_70128_L) continue;
            if (entity2 instanceof EntityFluid) {
                EntityFluid entity = (EntityFluid)entity2;
                if (entity == this) continue;
                double difX = px - entity.field_70165_t;
                double difY = py - entity.field_70163_u;
                double difZ = pz - entity.field_70161_v;
                double distanceSq = this.func_70068_e(entity);
                if (distanceSq < 0.09) {
                    double distance = NGTMath.firstSqrt((double)distanceSq);
                    double d0 = (0.3 - distance) * repulsion;
                    px += difX / distance * d0;
                    py += difY / distance * d0;
                    pz += difZ / distance * d0;
                }
                if (this.field_70170_p.field_72995_K) {
                    if (distanceSq <= 1.0 && this.getFluidType().type != FluidType.Type.SOLID) {
                        double dif;
                        this.nearFluids.add(entity);
                        if (!this.field_70122_E && entity.field_70163_u < this.field_70163_u && (dif = this.field_70163_u - entity.field_70163_u) > maxDif) {
                            maxDif = dif;
                            accumDif = entity.posDif;
                        }
                    }
                } else if (distanceSq <= 1.0) {
                    float temp2;
                    float temp1 = this.getTemperature();
                    if (temp1 > (temp2 = entity.getTemperature())) {
                        float f0 = (temp1 - temp2) * this.getFluidType().thermalConductivity;
                        temp1 -= f0;
                        temp2 += f0;
                    } else if (temp2 > temp1) {
                        float f0 = (temp2 - temp1) * entity.getFluidType().thermalConductivity;
                        temp2 -= f0;
                        temp1 += f0;
                    }
                    this.setTemperture(temp1);
                    entity.setTemperture(temp2);
                }
                this.onFluidCollide(entity);
                continue;
            }
            this.onEntityCollideFluid(entity2);
        }
        if (this.field_70170_p.field_72995_K) {
            this.posDif = (float)(accumDif + maxDif);
        }
        this.field_70159_w += px - this.field_70165_t;
        this.field_70179_y += pz - this.field_70161_v;
    }

    protected void onFluidCollide(EntityFluid fluid) {
        if (!this.field_70170_p.field_72995_K && this.func_70068_e(fluid) <= 1.0 && fluid.getFluidType() == FluidType.IRON_ORE && fluid.getTemperature() >= FluidType.PIG_IRON.meltingPoint) {
            int countInc = this.field_70170_p.field_73012_v.nextInt(2) + 2;
            ItemBucketLiquid.setFluid(this.field_70170_p, fluid.field_70165_t, fluid.field_70163_u, fluid.field_70161_v, FluidType.PIG_IRON, countInc, this.getTemperature());
            fluid.setFluidType(FluidType.SLAG);
            fluid.setTemperture(this.getTemperature());
            this.counter += 2000;
        }
    }

    protected void onEntityCollideFluid(Entity entity) {
        if (!this.field_70170_p.field_72995_K && this.func_70068_e(entity) <= 0.0625) {
            boolean burnFlag;
            boolean bl = burnFlag = this.getTemperature() > 300.0f;
            if (entity instanceof EntityItem) {
                boolean bl2 = burnFlag = !this.addItem((EntityItem)entity);
            }
            if (burnFlag && this.field_70170_p.field_73012_v.nextInt(5) == 0) {
                entity.func_70097_a(DamageSource.field_76371_c, 2.0f * this.getNormalizedTemperture());
                entity.func_70015_d(5);
            }
        }
    }

    private boolean addItem(EntityItem entity) {
        ItemStack stack = entity.func_92059_d();
        if (stack.func_77973_b() == RTMItem.coke) {
            ItemBucketLiquid.setFluid(this.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, FluidType.COKE, stack.func_190916_E(), 0.0f);
            entity.func_70106_y();
            return true;
        }
        if (stack.func_77973_b() == ITEM_IRON_ORE) {
            ItemBucketLiquid.setFluid(this.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, FluidType.IRON_ORE, stack.func_190916_E(), 0.0f);
            entity.func_70106_y();
            return true;
        }
        return false;
    }

    protected void fixPosByBlockCollision() {
        this.airCount = 0;
        double newX = this.field_70165_t + this.field_70159_w;
        double newY = this.field_70163_u + (this.field_70122_E ? 0.0 : this.field_70181_x);
        double newZ = this.field_70161_v + this.field_70179_y;
        int bx = MathHelper.func_76128_c((double)newX);
        int by = MathHelper.func_76128_c((double)newY);
        int bz = MathHelper.func_76128_c((double)newZ);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            int z;
            int y;
            int x = bx + face.func_176730_m().func_177958_n();
            boolean isAir = BlockUtil.isAir((IBlockAccess)this.field_70170_p, (int)x, (int)(y = by + face.func_176730_m().func_177956_o()), (int)(z = bz + face.func_176730_m().func_177952_p()));
            this.airCount += isAir ? 1 : 0;
            if (!isAir || face != EnumFacing.DOWN) continue;
            AxisAlignedBB aabb = this.func_174813_aQ();
            int minX = MathHelper.func_76128_c((double)aabb.field_72340_a);
            int maxX = MathHelper.func_76128_c((double)aabb.field_72336_d);
            int minZ = MathHelper.func_76128_c((double)aabb.field_72339_c);
            int maxZ = MathHelper.func_76128_c((double)aabb.field_72334_f);
            double d0 = 0.25;
            if (minX < bx) {
                this.field_70159_w += ((double)bx - aabb.field_72340_a) * d0;
            } else if (maxX > bx) {
                this.field_70159_w -= (aabb.field_72336_d - (double)(bx + 1)) * d0;
            }
            if (minZ < bz) {
                this.field_70179_y += ((double)bz - aabb.field_72339_c) * d0;
                continue;
            }
            if (maxZ <= bz) continue;
            this.field_70179_y -= (aabb.field_72334_f - (double)(bz + 1)) * d0;
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        float temp = this.getTemperature();
        if (NGTUtil.isEquippedItem((EntityPlayer)player, (Item)Items.field_151133_ar) || NGTUtil.isEquippedItem((EntityPlayer)player, (Item)RTMItem.bucketLiquid)) {
            if (temp > this.getFluidType().meltingPoint) {
                return ItemBucketLiquid.pickupFluid(player, this);
            }
        } else {
            if (NGTUtil.isEquippedItem((EntityPlayer)player, (Item)RTMItem.bellows)) {
                if (!this.field_70170_p.field_72995_K) {
                    this.setTemperture(temp - 10.0f);
                }
                return true;
            }
            if (NGTUtil.isEquippedItem((EntityPlayer)player, (Item)RTMItem.paddle)) {
                if (!this.field_70170_p.field_72995_K) {
                    ItemPaddle.pushPull(player, this, -1.0f);
                }
                return true;
            }
            if (NGTUtil.isEquippedItem((EntityPlayer)player, (Item)Items.field_151033_d)) {
                if (!this.field_70170_p.field_72995_K && this.getFluidType() == FluidType.COKE && this.getTemperature() < 500.0f) {
                    this.setTemperture(500.0f);
                }
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean func_70097_a(DamageSource source, float strength) {
        block7: {
            Item item;
            EntityPlayer player;
            block10: {
                block8: {
                    block11: {
                        block9: {
                            if (this.field_70170_p.field_72995_K || !(source.func_76364_f() instanceof EntityPlayer)) break block7;
                            player = (EntityPlayer)source.func_76346_g();
                            item = null;
                            if (!NGTUtil.isEquippedItem((EntityPlayer)player, (Item)RTMItem.iron_hacksaw)) break block8;
                            if (!(this.getTemperature() <= 100.0f)) {
                                NGTLog.showChatMessage((ITextComponent)new TextComponentString(String.format("Temperture is too hot ! (%5.1f)", Float.valueOf(this.getTemperature()))));
                                return true;
                            }
                            if (this.getFluidType() != FluidType.STEEL) break block9;
                            item = RTMItem.steel_ingot;
                            break block10;
                        }
                        if (this.getFluidType() != FluidType.PIG_IRON) break block11;
                        item = Items.field_151042_j;
                        break block10;
                    }
                    if (this.getFluidType() == FluidType.SLAG) {
                        item = Item.func_150898_a((Block)Blocks.field_150347_e);
                        break block10;
                    } else if (this.getFluidType() == FluidType.IRON_ORE) {
                        item = Item.func_150898_a((Block)Blocks.field_150366_p);
                    }
                    break block10;
                }
                if (NGTUtil.isEquippedItem((EntityPlayer)player, (Item)RTMItem.paddle)) {
                    ItemPaddle.pushPull(player, this, 1.0f);
                    return true;
                }
            }
            if (item == null && this.getFluidType() == FluidType.COKE) {
                item = RTMItem.coke;
            }
            if (item != null) {
                player.func_184614_ca().func_77972_a(1, (EntityLivingBase)player);
                player.func_70099_a(new ItemStack(item, 1, 0), 1.0f);
                this.func_70106_y();
            }
        }
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    public float getNormalizedLife() {
        int max = this.getFluidType().life;
        return max > 0 ? (float)(max - this.counter) / (float)max : 1.0f;
    }

    public FluidType getFluidType() {
        String s = (String)this.func_184212_Q().func_187225_a(TYPE);
        return FluidType.valueOf(s);
    }

    private void setFluidType(String type) {
        if (type == null || type.isEmpty()) {
            type = FluidType.STEEL.toString();
        }
        this.func_184212_Q().func_187227_b(TYPE, (Object)type);
    }

    public void setFluidType(FluidType type) {
        this.setFluidType(type.toString());
        this.counter = 0;
    }

    public float getTemperature() {
        return ((Float)this.func_184212_Q().func_187225_a(TEMP)).floatValue();
    }

    public float getNormalizedTemperture() {
        float temp = this.getTemperature();
        if (temp > this.getFluidType().meltingPoint) {
            return 1.0f;
        }
        return temp / this.getFluidType().meltingPoint;
    }

    public void setTemperture(float f) {
        f = f < 0.0f ? 0.0f : f;
        this.func_184212_Q().func_187227_b(TEMP, (Object)Float.valueOf(f));
    }

    public int countAir() {
        return this.airCount;
    }
}

