/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.fluid;

import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.renderer.ModelSolid;
import jp.ngt.rtm.entity.fluid.EntityFluid;
import jp.ngt.rtm.entity.fluid.FluidType;

public final class FluidVertexHolder {
    public static final int SPLIT_H = 4;
    public static final int SPLIT_W = 8;
    public final float[][] buffer = new float[40][4];

    public void update(EntityFluid fluid) {
        boolean isSolid = fluid.getFluidType().type == FluidType.Type.SOLID;
        int splitW = isSolid ? 4 : 8;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < splitW; ++j) {
                int i2 = (i + 1) * 2;
                int j3 = j * (16 / splitW);
                this.addVertex(fluid, (i + 1) * 8 + j, ModelSolid.SPHERE[i2 * 16 + j3]);
                i2 = i * 2;
                this.addVertex(fluid, i * 8 + j, ModelSolid.SPHERE[i2 * 16 + j3]);
            }
        }
    }

    private void addVertex(EntityFluid entity, int bufIndex, float[] vtx) {
        float colorF;
        float scale = 0.125f;
        double thresholdSq = NGTMath.pow((double)0.3, (int)2);
        float metaballCoef = scale * 0.2f;
        float orgX = vtx[0] * scale;
        float orgY = vtx[1] * scale;
        float orgZ = vtx[2] * scale;
        float x = orgX;
        float y = orgY;
        float z = orgZ;
        if (entity.getFluidType().type != FluidType.Type.SOLID) {
            for (int i = 0; i < entity.nearFluids.size(); ++i) {
                EntityFluid target = entity.nearFluids.get(i);
                double dx = target.field_70165_t - (entity.field_70165_t + (double)orgX);
                double dy = target.field_70163_u - (entity.field_70163_u + (double)orgY);
                double dz = target.field_70161_v - (entity.field_70161_v + (double)orgZ);
                double distanceSq = dx * dx + dy * dy + dz * dz;
                if (!(distanceSq < thresholdSq)) continue;
                double d0 = (double)metaballCoef / distanceSq;
                x = (float)((double)x + (target.field_70165_t - entity.field_70165_t) * d0);
                y = (float)((double)y + (target.field_70163_u - entity.field_70163_u) * d0);
                z = (float)((double)z + (target.field_70161_v - entity.field_70161_v) * d0);
            }
            double len = NGTMath.firstSqrt((double)(x * x + y * y + z * z));
            if (len > 0.25) {
                x = (float)((double)x * (0.25 / len));
                y = (float)((double)y * (0.25 / len));
                z = (float)((double)z * (0.25 / len));
                len = 0.25;
            }
        }
        float f = (colorF = (y / scale + 1.0f) * 0.5f) < 0.0f ? 0.0f : (colorF = colorF > 1.0f ? 1.0f : colorF);
        if (entity.posDif > 0.0f) {
            float f0 = entity.posDif / 0.125f;
            f0 = (f0 > 1.0f ? 1.0f : f0) * 0.9f;
            colorF = colorF * (1.0f - f0) + f0;
        }
        this.buffer[bufIndex][0] = x;
        this.buffer[bufIndex][1] = y;
        this.buffer[bufIndex][2] = z;
        this.buffer[bufIndex][3] = colorF;
    }
}

