/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.fluid;

import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.ngtlib.renderer.NGTRenderer;
import jp.ngt.ngtlib.renderer.NGTTessellator;
import jp.ngt.rtm.entity.fluid.EntityFluid;
import jp.ngt.rtm.entity.fluid.FluidType;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class RenderFluid
extends Render<EntityFluid> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/entity/experience_orb.png");

    public RenderFluid(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(EntityFluid entity, double x, double y, double z, float entityYaw, float partialTicks) {
        boolean isCoke;
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glTranslatef((float)((float)x), (float)((float)y + 0.125f), (float)((float)z));
        float scale = entity.getNormalizedLife();
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        int pass = MinecraftForgeClient.getRenderPass();
        boolean bl = isCoke = entity.getFluidType() == FluidType.COKE;
        if (pass == 0 || pass == 1 && isCoke) {
            GL11.glDisable((int)3553);
            GLHelper.disableLighting();
            GLHelper.setLightmapMaxBrightness();
            GL11.glShadeModel((int)7425);
            if (pass == 1) {
                if (isCoke && entity.getTemperature() >= 1000.0f) {
                    this.renderFire(entity);
                }
            } else {
                if (entity.getFluidType().type == FluidType.Type.SOLID) {
                    switch (entity.func_145782_y() % 4) {
                        case 0: {
                            GL11.glRotatef((float)5.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                            break;
                        }
                        case 1: {
                            GL11.glRotatef((float)5.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                            break;
                        }
                        case 2: {
                            GL11.glRotatef((float)-5.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                            break;
                        }
                        case 3: {
                            GL11.glRotatef((float)-5.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        }
                    }
                }
                this.renderMetaball(entity);
            }
            GL11.glShadeModel((int)7424);
            GLHelper.enableLighting();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3553);
        }
        GL11.glPopMatrix();
    }

    private void renderMetaball(EntityFluid entity) {
        float normTemp = entity.getNormalizedTemperture();
        boolean isSolid = entity.getFluidType().type == FluidType.Type.SOLID;
        int splitW = isSolid ? 4 : 8;
        NGTTessellator tessellator = NGTTessellator.instance;
        tessellator.startDrawing(5);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j <= splitW; ++j) {
                int j2 = j % splitW;
                this.addVertex(tessellator, entity, (i + 1) * 8 + j2, normTemp);
                this.addVertex(tessellator, entity, i * 8 + j2, normTemp);
            }
        }
        tessellator.draw();
    }

    private final void addVertex(NGTTessellator tessellator, EntityFluid fluid, int index, float temp) {
        float[] fa = fluid.fluidVtx.buffer[index];
        tessellator.setColorOpaque_I(fluid.getFluidType().getColor(fa[3], temp));
        tessellator.addVertex(fa[0], fa[1], fa[2]);
    }

    private void renderFire(EntityFluid entity) {
        GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        double d0 = (double)((System.currentTimeMillis() + (long)(entity.func_145782_y() * 50)) % 5000L) / 5000.0 * 360.0;
        float tempNormal = entity.getNormalizedTemperture();
        float scale = ((NGTMath.sin((float)((float)d0)) + 1.0f) * 0.5f + 2.0f) * tempNormal;
        int color = 0xAA00FF;
        NGTRenderer.renderFire((float)0.2f, (float)(0.25f * scale), (int)color, (int)5);
    }

    protected ResourceLocation getEntityTexture(EntityFluid entity) {
        return null;
    }
}

