/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.npc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jp.ngt.ngtlib.io.FileType;
import jp.ngt.ngtlib.io.NGTFileLoader;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.io.NGTText;
import jp.ngt.rtm.entity.npc.MenuEntry;
import jp.ngt.rtm.entity.npc.Role;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class Menu {
    private final List<MenuEntry> menuList = new ArrayList<MenuEntry>();

    public Menu(String s, Role role) {
        this.init(s, role);
    }

    public boolean add(MenuEntry entry) {
        if (!entry.item.func_190926_b()) {
            int index = this.menuList.indexOf(entry);
            if (index >= 0) {
                NGTLog.debug((String)"[Menu] \u91cd\u8907\u30a2\u30a4\u30c6\u30e0\u3092\u524a\u9664 : %s", (Object[])new Object[]{entry.item.func_82833_r()});
                this.menuList.remove(index);
            }
            return this.menuList.add(entry);
        }
        return false;
    }

    public void remove(int index) {
        this.menuList.remove(index);
    }

    public MenuEntry get(int index) {
        return this.menuList.get(index);
    }

    public List<MenuEntry> getList() {
        return this.menuList;
    }

    public boolean init(String s, Role role) {
        this.menuList.clear();
        if (s != null && !s.isEmpty()) {
            try {
                NBTTagCompound nbt0 = JsonToNBT.func_180713_a((String)s);
                NBTTagList nbttaglist = nbt0.func_150295_c("list", 10);
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    NBTTagCompound nbt = nbttaglist.func_150305_b(i);
                    MenuEntry entry = MenuEntry.readFromNBT(nbt);
                    if (entry == null) continue;
                    this.add(entry);
                }
                if (!this.menuList.isEmpty()) {
                    return true;
                }
            }
            catch (NBTException e) {
                e.printStackTrace();
            }
        }
        if (role == Role.SALESPERSON) {
            this.add(new MenuEntry(new ItemStack(Items.field_151106_aX, 10), 200));
            this.add(new MenuEntry(new ItemStack(Items.field_179566_aV, 5), 500));
        } else if (role == Role.BUYER) {
            this.add(new MenuEntry(new ItemStack(Items.field_151106_aX, 1), 20));
            this.add(new MenuEntry(new ItemStack(Items.field_179566_aV, 1), 100));
        }
        return false;
    }

    public String toString() {
        NBTTagList nbttaglist = new NBTTagList();
        for (MenuEntry entry : this.menuList) {
            nbttaglist.func_74742_a((NBTBase)entry.writeToNBT());
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("list", (NBTBase)nbttaglist);
        return nbt.toString();
    }

    public boolean exportToText() {
        File file = NGTFileLoader.saveFile((FileType[])new FileType[]{FileType.JSON});
        if (file != null) {
            return NGTText.writeToText((File)file, (String[])new String[]{this.toString()});
        }
        return false;
    }

    public boolean importFromText(Role role) {
        File file = NGTFileLoader.selectFile((FileType[])new FileType[]{FileType.JSON});
        if (file != null) {
            try {
                return this.init(NGTText.readText((File)file, (boolean)false, (String)"UTF-8"), role);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

